/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.diboot.core.config.BaseConfig;
import com.diboot.core.config.Cons;
import com.diboot.core.entity.AbstractEntity;
import com.diboot.core.event.OperationEvent;
import com.diboot.core.exception.BusinessException;
import com.diboot.core.service.impl.BaseServiceImpl;
import com.diboot.core.util.V;
import com.diboot.core.vo.LabelValue;
import com.diboot.core.vo.Pagination;
import com.diboot.core.vo.Status;
import com.diboot.iam.auth.IamCustomize;
import com.diboot.iam.dto.IamUserFormDTO;
import com.diboot.iam.entity.IamAccount;
import com.diboot.iam.entity.IamOrg;
import com.diboot.iam.entity.IamRole;
import com.diboot.iam.entity.IamUser;
import com.diboot.iam.entity.IamUserPosition;
import com.diboot.iam.mapper.IamUserMapper;
import com.diboot.iam.service.IamAccountService;
import com.diboot.iam.service.IamOrgService;
import com.diboot.iam.service.IamRoleService;
import com.diboot.iam.service.IamUserPositionService;
import com.diboot.iam.service.IamUserRoleService;
import com.diboot.iam.service.IamUserService;
import com.diboot.iam.util.IamSecurityUtils;
import com.diboot.iam.vo.IamUserPositionVO;
import com.diboot.iam.vo.IamUserVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IamUserServiceImpl
extends BaseServiceImpl<IamUserMapper, IamUser>
implements IamUserService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamUserServiceImpl.class);
    @Autowired
    private IamUserRoleService iamUserRoleService;
    @Autowired
    private IamAccountService iamAccountService;
    @Autowired
    private IamOrgService iamOrgService;
    @Autowired
    private IamRoleService iamRoleService;
    @Autowired
    private IamUserPositionService iamUserPositionService;
    @Autowired(required=false)
    private IamCustomize iamCustomize;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean createUserRelatedInfo(IamUserFormDTO userFormDTO) {
        this.createEntity((Object)userFormDTO);
        if (V.notEmpty((String)userFormDTO.getUsername())) {
            this.createAccount(userFormDTO);
            this.iamUserRoleService.createUserRoleRelations(userFormDTO.getUserType(), (String)((Object)userFormDTO.getId()), userFormDTO.getRoleIdList());
        }
        if (V.notEmpty(userFormDTO.getUserPositionList())) {
            this.iamUserPositionService.updateUserPositionRelations(userFormDTO.getUserType(), (String)((Object)userFormDTO.getId()), userFormDTO.getUserPositionList());
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateUserRelatedInfo(IamUserFormDTO userFormDTO) {
        IamAccount iamAccount;
        this.updateEntity((Object)userFormDTO);
        if (userFormDTO.getUserPositionList() != null) {
            this.iamUserPositionService.updateUserPositionRelations(userFormDTO.getUserType(), (String)((Object)userFormDTO.getId()), userFormDTO.getUserPositionList());
        }
        if ((iamAccount = (IamAccount)((Object)this.iamAccountService.getSingleEntity((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IamAccount::getUserType, (Object)IamUser.class.getSimpleName())).eq(IamAccount::getUserId, (Object)userFormDTO.getId())))) == null) {
            if (V.isEmpty((String)userFormDTO.getUsername())) {
                return true;
            }
            this.createAccount(userFormDTO);
            this.iamUserRoleService.createUserRoleRelations(userFormDTO.getUserType(), (String)((Object)userFormDTO.getId()), userFormDTO.getRoleIdList());
        } else if (V.isEmpty((String)userFormDTO.getUsername())) {
            this.deleteAccount((String)((Object)userFormDTO.getId()));
            this.iamUserRoleService.updateUserRoleRelations(iamAccount.getUserType(), iamAccount.getUserId(), Collections.emptyList());
        } else {
            iamAccount.setAuthAccount(userFormDTO.getUsername()).setStatus(userFormDTO.getAccountStatus());
            if (Cons.ENABLE_STATUS.I.name().equals(userFormDTO.getStatus())) {
                iamAccount.setStatus(Cons.ENABLE_STATUS.I.name());
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new OperationEvent(IamUser.class.getSimpleName(), (Object)userFormDTO));
            }
            if (V.notEmpty((String)userFormDTO.getPassword())) {
                iamAccount.setAuthSecret(userFormDTO.getPassword());
                this.iamCustomize.encryptPwd(iamAccount);
            }
            this.iamAccountService.updateEntity((Object)iamAccount);
            this.iamUserRoleService.updateUserRoleRelations(iamAccount.getUserType(), iamAccount.getUserId(), userFormDTO.getRoleIdList());
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteUserAndRelatedInfo(String id) {
        if (!this.exists(AbstractEntity::getId, id)) {
            throw new BusinessException(Status.FAIL_OPERATION, "exception.business.userService.deleteRecordNonExist", new Object[0]);
        }
        this.deleteEntity((Serializable)((Object)id));
        this.deleteAccount(id);
        this.deleteUserPositions(id);
        return true;
    }

    @Override
    public List<String> filterDuplicateUserNums(List<String> userNumList) {
        if (V.isEmpty(userNumList)) {
            return Collections.emptyList();
        }
        int totalSize = userNumList.size();
        int batchSize = BaseConfig.getBatchSize();
        HashSet<String> uniqueUserNumSet = new HashSet<String>(totalSize);
        for (int startInx = 0; startInx < totalSize; startInx += batchSize) {
            List<String> existUserNumList = this.checkUserNumDuplicate(userNumList.subList(startInx, Math.min(startInx + batchSize, totalSize)));
            if (!V.notEmpty(existUserNumList)) continue;
            uniqueUserNumSet.addAll(existUserNumList);
        }
        return new ArrayList<String>(uniqueUserNumSet);
    }

    @Override
    public boolean isUserNumExists(String id, String userNum) {
        if (V.isEmpty((String)userNum)) {
            return true;
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{IamUser::getUserNum}).eq(IamUser::getUserNum, (Object)userNum);
        if (V.notEmpty((String)id)) {
            wrapper.ne(AbstractEntity::getId, (Object)id);
        }
        wrapper.orderByDesc(AbstractEntity::getId);
        return this.exists((Wrapper)wrapper);
    }

    @Override
    public List<String> getUserIdsByManagerId(String managerId) {
        if (managerId == null) {
            return null;
        }
        List<String> orgIds = this.iamOrgService.getOrgIdsByManagerId(managerId);
        if (V.isEmpty(orgIds)) {
            return Collections.emptyList();
        }
        List iamUserIds = this.getValuesOfField((Wrapper)Wrappers.lambdaQuery().in(IamUser::getOrgId, orgIds), AbstractEntity::getId);
        return iamUserIds;
    }

    @Override
    public String getUserLeaderId(String userId) {
        IamUser iamUser = (IamUser)((Object)this.getEntity((Serializable)((Object)userId)));
        if (V.isEmpty((Object)((Object)iamUser))) {
            return null;
        }
        IamOrg iamOrg = (IamOrg)((Object)this.iamOrgService.getEntity((Serializable)((Object)iamUser.getOrgId())));
        if (V.isEmpty((Object)((Object)iamOrg)) || V.isEmpty((String)iamOrg.getManagerId())) {
            return null;
        }
        return iamOrg.getManagerId();
    }

    @Override
    public List<IamUser> getUsersByRoleIds(List<String> roleIds) {
        List<String> ids = this.iamUserRoleService.getUserIdsByRoleIds(roleIds);
        return this.getEntityListByIds(ids);
    }

    @Override
    public List<IamUser> getUsersByRoleCode(String roleCode) {
        if (V.isEmpty((String)roleCode)) {
            return Collections.emptyList();
        }
        return this.getUsersByRoleCodes(Arrays.asList(roleCode));
    }

    @Override
    public List<IamUser> getUsersByRoleCodes(List<String> roleCodes) {
        if (V.isEmpty(roleCodes)) {
            return Collections.emptyList();
        }
        List roleIds = this.iamRoleService.getValuesOfField((Wrapper)Wrappers.lambdaQuery().select(new SFunction[]{AbstractEntity::getId}).in(IamRole::getCode, roleCodes), AbstractEntity::getId);
        if (V.isEmpty((Collection)roleIds)) {
            return Collections.emptyList();
        }
        List<String> ids = this.iamUserRoleService.getUserIdsByRoleIds(roleIds);
        return this.getEntityListByIds(ids);
    }

    @Override
    public Map<String, LabelValue> getLabelValueMap(List<String> ids) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new QueryWrapper().lambda().select(new SFunction[]{IamUser::getRealname, AbstractEntity::getId, IamUser::getUserNum}).in(AbstractEntity::getId, ids);
        return this.getEntityList((Wrapper)queryWrapper).stream().collect(Collectors.toMap(ent -> (String)((Object)ent.getId()), ent -> new LabelValue(ent.getRealname(), (Object)ent.getId()).setExt((Object)ent.getUserNum())));
    }

    @Override
    public List<IamUserVO> getUserViewList(QueryWrapper<IamUser> queryWrapper, Pagination pagination, String orgId) {
        ArrayList<String> orgIds = new ArrayList<String>();
        if (V.notEmpty((String)orgId)) {
            orgIds.add(orgId);
            orgIds.addAll(this.iamOrgService.getChildOrgIds(orgId));
            LambdaQueryWrapper queryUserIds = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IamUserPosition::getUserType, (Object)IamUser.class.getSimpleName())).in(IamUserPosition::getOrgId, orgIds);
            List userIds = this.iamUserPositionService.getValuesOfField((Wrapper)queryUserIds, IamUserPosition::getUserId);
            queryWrapper.and(query -> ((QueryWrapper)((QueryWrapper)query.in((Object)Cons.ColumnName.org_id.name(), (Collection)orgIds)).or()).in(V.notEmpty((Collection)userIds), (Object)Cons.FieldName.id.name(), (Collection)userIds));
        }
        List voList = this.getViewObjectList((Wrapper)queryWrapper, pagination, IamUserVO.class);
        if (V.isEmpty(orgIds)) {
            return voList;
        }
        for (IamUserVO user : voList) {
            List<IamUserPositionVO> userPositionList = user.getUserPositionList();
            if (!V.notEmpty(userPositionList)) continue;
            user.setUserPositionList(userPositionList.stream().filter(p -> orgIds.contains(p.getOrgId())).collect(Collectors.toList()));
        }
        return voList;
    }

    @Override
    public void refreshUserInfo(IamUser currentUser) {
        IamUser latestInfo = (IamUser)((Object)this.getEntity(currentUser.getId()));
        currentUser.setRealname(latestInfo.getRealname()).setStatus(latestInfo.getStatus()).setAvatarUrl(latestInfo.getAvatarUrl()).setUserNum(latestInfo.getUserNum()).setGender(latestInfo.getGender()).setBirthdate(latestInfo.getBirthdate()).setEmail(latestInfo.getEmail()).setMobilePhone(latestInfo.getMobilePhone()).setOrgId(latestInfo.getOrgId());
    }

    private List<String> checkUserNumDuplicate(List<String> userNumList) {
        if (V.isEmpty(userNumList)) {
            return Collections.emptyList();
        }
        List iamUserNums = this.getValuesOfField((Wrapper)Wrappers.lambdaQuery().in(IamUser::getUserNum, userNumList), IamUser::getUserNum);
        return iamUserNums;
    }

    protected void createAccount(IamUserFormDTO userFormDTO) {
        IamAccount iamAccount = new IamAccount().setTenantId(userFormDTO.getTenantId()).setUserType(IamUser.class.getSimpleName()).setUserId((String)((Object)userFormDTO.getId())).setAuthAccount(userFormDTO.getUsername()).setAuthSecret(userFormDTO.getPassword()).setAuthType(userFormDTO.getAuthType()).setStatus(userFormDTO.getAccountStatus());
        if (Cons.ENABLE_STATUS.I.name().equals(userFormDTO.getStatus())) {
            iamAccount.setStatus(Cons.ENABLE_STATUS.I.name());
        }
        this.iamAccountService.createEntity(iamAccount);
    }

    private void deleteAccount(String userId) {
        if (V.equals((Object)userId, (Object)IamSecurityUtils.getCurrentUserId())) {
            throw new BusinessException("exception.business.userService.deleteSelfAccount", new Object[0]);
        }
        this.iamAccountService.deleteEntities((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IamAccount::getUserType, (Object)IamUser.class.getSimpleName())).eq(IamAccount::getUserId, (Object)userId));
        this.iamUserRoleService.deleteUserRoleRelations(IamUser.class.getSimpleName(), userId);
    }

    private void deleteUserPositions(String userId) {
        this.iamUserPositionService.deleteEntities((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IamUserPosition::getUserType, (Object)IamUser.class.getSimpleName())).eq(IamUserPosition::getUserId, (Object)userId));
    }

    public void beforeCreate(IamUser iamUser) {
        if (this.isUserNumExists(null, iamUser.getUserNum())) {
            log.warn("\u4fdd\u5b58\u7528\u6237\u5f02\u5e38: \u5458\u5de5\u7f16\u53f7{} \u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01", (Object)iamUser.getUserNum());
            throw new BusinessException(Status.FAIL_VALIDATION, "exception.business.userService.userNumExist", new Object[]{iamUser.getUserNum()});
        }
    }

    public void beforeUpdate(IamUser iamUser) {
        if (this.isUserNumExists((String)((Object)iamUser.getId()), iamUser.getUserNum())) {
            log.warn("\u4fdd\u5b58\u7528\u6237\u5f02\u5e38: \u5458\u5de5\u7f16\u53f7{} \u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01", (Object)iamUser.getUserNum());
            throw new BusinessException(Status.FAIL_VALIDATION, "exception.business.userService.userNumExist", new Object[]{iamUser.getUserNum()});
        }
    }
}

