/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.diboot.core.binding.Binder;
import com.diboot.core.config.BaseConfig;
import com.diboot.core.entity.AbstractEntity;
import com.diboot.core.service.impl.BaseServiceImpl;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.V;
import com.diboot.iam.auth.IamCustomize;
import com.diboot.iam.auth.IamExtensible;
import com.diboot.iam.config.Cons;
import com.diboot.iam.entity.BaseLoginUser;
import com.diboot.iam.entity.IamResource;
import com.diboot.iam.entity.IamRole;
import com.diboot.iam.entity.IamUserRole;
import com.diboot.iam.exception.PermissionException;
import com.diboot.iam.mapper.IamRoleMapper;
import com.diboot.iam.mapper.IamUserRoleMapper;
import com.diboot.iam.service.IamResourceService;
import com.diboot.iam.service.IamRoleService;
import com.diboot.iam.service.IamUserRoleService;
import com.diboot.iam.util.IamHelper;
import com.diboot.iam.vo.IamRoleVO;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IamUserRoleServiceImpl
extends BaseServiceImpl<IamUserRoleMapper, IamUserRole>
implements IamUserRoleService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamUserRoleServiceImpl.class);
    @Autowired
    private IamRoleService iamRoleService;
    @Autowired
    private IamRoleMapper iamRoleMapper;
    @Autowired
    private IamResourceService iamResourceService;
    @Autowired(required=false)
    private IamExtensible iamExtensible;
    @Autowired(required=false)
    private IamCustomize iamCustomize;
    private static String ROLE_ID_SUPER_ADMIN = null;

    @Override
    public List<IamRole> getUserRoleList(String tenantId, String userType, String userId, String extensionObjId) {
        List<IamRole> extRoles;
        List userRoleList = this.getEntityList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{IamUserRole::getRoleId}).eq(IamUserRole::getUserType, (Object)userType)).eq(IamUserRole::getUserId, (Object)userId)).eq(IamUserRole::getTenantId, (Object)tenantId));
        if (V.isEmpty((Collection)userRoleList)) {
            return Collections.emptyList();
        }
        List roleIds = BeanUtils.collectToList((List)userRoleList, IamUserRole::getRoleId);
        List roles = this.iamRoleMapper.findByIds(roleIds, BaseConfig.getActiveFlagValue());
        if (this.getIamExtensible() != null && V.notEmpty(extRoles = this.getIamExtensible().getExtensionRoles(userType, userId, extensionObjId))) {
            roles.addAll(extRoles);
            roles = BeanUtils.distinctByKey(roles, AbstractEntity::getId);
        }
        return roles;
    }

    public boolean createEntity(IamUserRole entity) {
        boolean success;
        String superAdminRoleId = this.getSuperAdminRoleId();
        if (superAdminRoleId != null && superAdminRoleId.equals(entity.getRoleId())) {
            this.checkSuperAdminIdentity();
        }
        if (success = super.createEntity((Object)entity)) {
            this.clearUserAuthCache(entity.getUserType(), entity.getUserId());
        }
        return success;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean createEntities(Collection entityList) {
        boolean success;
        if (V.isEmpty((Collection)entityList)) {
            return true;
        }
        String superAdminRoleId = this.getSuperAdminRoleId();
        boolean hasSuperAdmin = false;
        String userType = null;
        String userId = null;
        for (Object entity : entityList) {
            IamUserRole iamUserRole = (IamUserRole)((Object)entity);
            if (superAdminRoleId != null && superAdminRoleId.equals(iamUserRole.getRoleId())) {
                hasSuperAdmin = true;
            }
            if (userId != null) continue;
            userType = iamUserRole.getUserType();
            userId = iamUserRole.getUserId();
        }
        if (hasSuperAdmin) {
            this.checkSuperAdminIdentity();
        }
        if (success = super.createEntities(entityList)) {
            this.clearUserAuthCache(userType, userId);
        }
        return success;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean createUserRoleRelations(String userType, String userId, List<String> roleIds) {
        if (V.isEmpty(roleIds)) {
            return true;
        }
        String superAdminRoleId = this.getSuperAdminRoleId();
        if (superAdminRoleId != null && roleIds.contains(superAdminRoleId)) {
            this.checkSuperAdminIdentity();
        }
        return super.createOrUpdateN2NRelations(IamUserRole::getUserId, (Object)userId, IamUserRole::getRoleId, roleIds, q -> q.lambda().eq(IamUserRole::getUserType, (Object)userType), e -> e.setUserType(userType));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateUserRoleRelations(String userType, String userId, List<String> roleIds) {
        boolean success;
        if (roleIds == null) {
            return true;
        }
        String superAdminRoleId = this.getSuperAdminRoleId();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IamUserRole::getUserType, (Object)userType)).eq(IamUserRole::getUserId, (Object)userId)).eq(IamUserRole::getRoleId, (Object)superAdminRoleId)).orderByDesc(AbstractEntity::getId);
        if (superAdminRoleId != null && (roleIds.contains(superAdminRoleId) || this.exists((Wrapper)queryWrapper))) {
            this.checkSuperAdminIdentity();
        }
        if (success = super.createOrUpdateN2NRelations(IamUserRole::getUserId, (Object)userId, IamUserRole::getRoleId, roleIds, q -> q.lambda().eq(IamUserRole::getUserType, (Object)userType), e -> e.setUserType(userType))) {
            this.clearUserAuthCache(userType, userId);
        }
        return success;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteUserRoleRelations(String userType, String userId) {
        String superAdminRoleId = this.getSuperAdminRoleId();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IamUserRole::getUserType, (Object)userType)).eq(IamUserRole::getUserId, (Object)userId)).eq(IamUserRole::getRoleId, (Object)superAdminRoleId)).orderByDesc(AbstractEntity::getId);
        if (superAdminRoleId != null && this.exists((Wrapper)queryWrapper) && !this.iamCustomize.checkCurrentUserHasRole("SUPER_ADMIN")) {
            throw new PermissionException("exception.permission.userRoleService.deleteUserRoleRelations.noPermission", new Object[0]);
        }
        return this.deleteEntities((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IamUserRole::getUserType, (Object)userType)).eq(IamUserRole::getUserId, (Object)userId));
    }

    @Override
    public List<IamRoleVO> getAllRoleVOList(BaseLoginUser userObject) {
        List roleList = this.getUserRoleList(userObject.getTenantId(), ((Object)((Object)userObject)).getClass().getSimpleName(), (String)((Object)userObject.getId()));
        if (V.isEmpty((Collection)roleList)) {
            return null;
        }
        return Binder.convertAndBindRelations((List)roleList, IamRoleVO.class);
    }

    @Override
    public IamExtensible getIamExtensible() {
        return this.iamExtensible;
    }

    @Override
    public IamRoleVO buildRoleVo4FrontEnd(BaseLoginUser loginUser) {
        List<IamRoleVO> roleVOList = this.getAllRoleVOList(loginUser);
        if (V.isEmpty(roleVOList)) {
            return null;
        }
        for (IamRoleVO roleVO : roleVOList) {
            if (!"SUPER_ADMIN".equalsIgnoreCase(roleVO.getCode())) continue;
            List<IamResource> iamPermissions = this.iamResourceService.getAllResources(Cons.APPLICATION);
            roleVO.setPermissionList(iamPermissions);
            break;
        }
        return IamHelper.buildRoleVo4FrontEnd(roleVOList);
    }

    @Override
    public List<String> getUserIdsByRoleIds(List<String> roleIds) {
        List userIds = this.getValuesOfField((Wrapper)Wrappers.lambdaQuery().select(new SFunction[]{IamUserRole::getRoleId}).in(IamUserRole::getRoleId, roleIds), IamUserRole::getUserId);
        return userIds;
    }

    private String getSuperAdminRoleId() {
        LambdaQueryWrapper queryWrapper;
        IamRole admin;
        if (ROLE_ID_SUPER_ADMIN == null && (admin = (IamRole)((Object)this.iamRoleService.getSingleEntity((Wrapper)(queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{AbstractEntity::getId}).eq(IamRole::getCode, (Object)"SUPER_ADMIN"))))) != null) {
            ROLE_ID_SUPER_ADMIN = (String)((Object)admin.getId());
        }
        return ROLE_ID_SUPER_ADMIN;
    }

    private void checkSuperAdminIdentity() {
        if (!this.iamCustomize.checkCurrentUserHasRole("SUPER_ADMIN")) {
            throw new PermissionException("exception.permission.userRoleService.checkSuperAdminIdentity.noPermission", new Object[0]);
        }
    }

    private void clearUserAuthCache(String userType, String userId) {
        this.iamCustomize.clearAuthorizationCache(userType, userId);
    }
}

