/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.diboot.core.exception.BusinessException;
import com.diboot.core.service.impl.BaseServiceImpl;
import com.diboot.core.util.V;
import com.diboot.core.vo.Status;
import com.diboot.iam.entity.IamUserPosition;
import com.diboot.iam.mapper.IamUserPositionMapper;
import com.diboot.iam.service.IamUserPositionService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IamUserPositionServiceImpl
extends BaseServiceImpl<IamUserPositionMapper, IamUserPosition>
implements IamUserPositionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamUserPositionServiceImpl.class);

    @Override
    public List<IamUserPosition> getUserPositionListByUser(String userType, String userId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IamUserPosition::getUserType, (Object)userType)).eq(IamUserPosition::getUserId, (Object)userId)).orderByDesc(IamUserPosition::getIsPrimaryPosition);
        return ((IamUserPositionMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<String> getPositionIdsByOrg(String orgId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{IamUserPosition::getPositionId}).eq(IamUserPosition::getOrgId, (Object)orgId);
        List userPositions = ((IamUserPositionMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (V.notEmpty((Collection)userPositions)) {
            return userPositions.stream().map(IamUserPosition::getPositionId).distinct().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public IamUserPosition getUserPrimaryPosition(String userType, String userId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IamUserPosition::getUserType, (Object)userType)).eq(IamUserPosition::getUserId, (Object)userId)).eq(IamUserPosition::getIsPrimaryPosition, (Object)true);
        List userPositionList = ((IamUserPositionMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (V.isEmpty((Collection)userPositionList)) {
            return null;
        }
        if (userPositionList.size() > 1) {
            log.warn("\u7528\u6237 {}:{} \u4e3b\u5c97\u591a\u4e8e1\u4e2a\uff0c\u5f53\u524d\u4ee5\u7b2c\u4e00\u4e2a\u4e3a\u51c6", (Object)userType, (Object)userId);
        }
        return (IamUserPosition)((Object)userPositionList.get(0));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateUserPositionRelations(String userType, String userId, List<IamUserPosition> userPositionList) {
        LambdaQueryWrapper deleteWrapper;
        long count;
        if (V.isEmpty((String)userType) || V.isEmpty((String)userId)) {
            throw new BusinessException(Status.FAIL_OPERATION, "exception.business.paramsError", new Object[0]);
        }
        if (V.notEmpty(userPositionList)) {
            for (IamUserPosition userPosition : userPositionList) {
                userPosition.setUserType(userType);
                userPosition.setUserId(userId);
            }
        }
        if ((count = ((IamUserPositionMapper)this.baseMapper).selectCount((Wrapper)(deleteWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IamUserPosition::getUserType, (Object)userType)).eq(IamUserPosition::getUserId, (Object)userId))).longValue()) > 0L) {
            ((IamUserPositionMapper)this.baseMapper).delete((Wrapper)deleteWrapper);
        }
        if (V.isEmpty(userPositionList)) {
            return true;
        }
        for (IamUserPosition userPosition : userPositionList) {
            userPosition.setId(null);
            ((IamUserPositionMapper)this.baseMapper).insert((Object)userPosition);
        }
        return true;
    }

    @Override
    public List<String> getUserIdsByPosition(String orgId, List<String> positionIds) {
        List userPositions;
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{IamUserPosition::getUserId}).in(IamUserPosition::getPositionId, positionIds);
        if (V.notEmpty((String)orgId)) {
            queryWrapper.eq(IamUserPosition::getOrgId, (Object)orgId);
        }
        if (V.notEmpty((Collection)(userPositions = ((IamUserPositionMapper)this.baseMapper).selectList((Wrapper)queryWrapper)))) {
            return userPositions.stream().map(IamUserPosition::getUserId).distinct().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

