/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.diboot.core.binding.Binder;
import com.diboot.core.binding.RelationsBinder;
import com.diboot.core.entity.AbstractEntity;
import com.diboot.core.event.OperationEvent;
import com.diboot.core.exception.BusinessException;
import com.diboot.core.service.impl.BaseServiceImpl;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.V;
import com.diboot.core.vo.LabelValue;
import com.diboot.core.vo.Status;
import com.diboot.iam.auth.IamTenantPermission;
import com.diboot.iam.config.Cons;
import com.diboot.iam.entity.BaseLoginUser;
import com.diboot.iam.entity.IamResource;
import com.diboot.iam.entity.IamRole;
import com.diboot.iam.entity.IamRoleResource;
import com.diboot.iam.entity.route.RouteMeta;
import com.diboot.iam.entity.route.RouteRecord;
import com.diboot.iam.mapper.IamRoleResourceMapper;
import com.diboot.iam.service.IamResourceService;
import com.diboot.iam.service.IamRoleResourceService;
import com.diboot.iam.service.IamRoleService;
import com.diboot.iam.service.IamUserRoleService;
import com.diboot.iam.util.IamSecurityUtils;
import com.diboot.iam.vo.IamResourceListVO;
import com.diboot.iam.vo.IamResourceVO;
import com.diboot.iam.vo.PositionDataScope;
import com.diboot.iam.vo.ResourceRoleVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IamRoleResourceServiceImpl
extends BaseServiceImpl<IamRoleResourceMapper, IamRoleResource>
implements IamRoleResourceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamRoleResourceServiceImpl.class);
    @Autowired
    private IamRoleService iamRoleService;
    @Autowired
    private IamResourceService iamResourceService;
    @Autowired
    private IamUserRoleService iamUserRoleService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @Override
    public List<RouteRecord> getRouteRecords() {
        List<IamRole> roleList;
        BaseLoginUser currentUser = (BaseLoginUser)((Object)IamSecurityUtils.getCurrentUser());
        if (currentUser == null) {
            throw new BusinessException(Status.FAIL_NO_PERMISSION, "exception.business.roleResourceService.fetchMenuAfterLogin", new Object[0]);
        }
        LabelValue extensionObj = currentUser.getExtensionObj();
        String extensionObjId = null;
        if (extensionObj != null) {
            extensionObjId = ((PositionDataScope)extensionObj.getExt()).getPositionId();
        }
        if (V.isEmpty(roleList = this.iamUserRoleService.getUserRoleList(currentUser.getTenantId(), ((Object)((Object)currentUser)).getClass().getSimpleName(), (String)((Object)currentUser.getId()), extensionObjId))) {
            return Collections.emptyList();
        }
        boolean isAdmin = false;
        boolean isTenantAdmin = false;
        for (IamRole iamRole : roleList) {
            if ("SUPER_ADMIN".equalsIgnoreCase(iamRole.getCode())) {
                isAdmin = true;
                break;
            }
            if (!"TENANT_ADMIN".equalsIgnoreCase(iamRole.getCode())) continue;
            isTenantAdmin = true;
            break;
        }
        List<String> permissionIds = null;
        if (isTenantAdmin) {
            IamTenantPermission iamTenantPermission = (IamTenantPermission)ContextHolder.getBean(IamTenantPermission.class);
            if (V.isEmpty((Object)iamTenantPermission)) {
                throw new BusinessException(Status.FAIL_OPERATION, "exception.business.roleResourceService.tenantNonConfigPermission", new Object[0]);
            }
            permissionIds = iamTenantPermission.findAllPermissions(currentUser.getTenantId());
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IamResource::getStatus, (Object)Cons.DICTCODE_RESOURCE_STATUS.A.name());
        if (!isAdmin && !isTenantAdmin) {
            List<String> roleIds = roleList.stream().map(AbstractEntity::getId).collect(Collectors.toList());
            permissionIds = this.getPermissionIdsByRoleIds(roleIds);
        }
        if (!isAdmin && V.isEmpty(permissionIds)) {
            return Collections.emptyList();
        }
        wrapper.in(V.notEmpty(permissionIds), IamResource::getId, permissionIds);
        List menuPermissionList = this.iamResourceService.getEntityList((Wrapper)wrapper);
        if (V.isEmpty((Collection)menuPermissionList)) {
            return Collections.emptyList();
        }
        RelationsBinder.bind((List)menuPermissionList);
        Map<String, List<IamResource>> listMap = menuPermissionList.stream().collect(Collectors.groupingBy(e -> Cons.RESOURCE_PERMISSION_DISPLAY_TYPE.PERMISSION.name().equals(e.getDisplayType()) ? e.getParentId() : "0"));
        List iamResourceList = BeanUtils.convertList(listMap.get("0"), IamResourceListVO.class);
        iamResourceList.forEach(e -> e.setPermissionList((List)listMap.get(e.getId())));
        ArrayList<RouteRecord> routeRecordList = new ArrayList<RouteRecord>();
        this.buildRouteRecordList(routeRecordList, BeanUtils.buildTree((List)iamResourceList));
        return routeRecordList;
    }

    @Override
    public List<IamResourceVO> getPermissionVOList(String appModule, String roleId) {
        ArrayList<String> roleIdList = new ArrayList<String>();
        roleIdList.add(roleId);
        return this.getPermissionVOList(appModule, roleIdList);
    }

    @Override
    public List<IamResourceVO> getPermissionVOList(String appModule, List<String> roleIds) {
        List<IamResource> list = this.getPermissionList(appModule, roleIds);
        List voList = BeanUtils.convertList(list, IamResourceVO.class);
        return BeanUtils.buildTree((List)voList, (Object)"0");
    }

    @Override
    public List<IamResource> getPermissionList(String appModule, List<String> roleIds) {
        if (V.isEmpty(roleIds)) {
            return Collections.emptyList();
        }
        List<String> permissionIds = this.getPermissionIdsByRoleIds(roleIds);
        if (V.isEmpty(permissionIds)) {
            return Collections.emptyList();
        }
        return this.iamResourceService.getEntityList((Wrapper)Wrappers.lambdaQuery().in(IamResource::getId, permissionIds));
    }

    @Override
    public List<String> getPermissionCodeList(String appModule, List<String> roleIds) {
        List<String> permissionIds = this.getPermissionIdsByRoleIds(roleIds);
        if (V.isEmpty(permissionIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{IamResource::getPermissionCode}).in(IamResource::getId, permissionIds)).isNotNull(IamResource::getPermissionCode);
        return this.iamResourceService.getValuesOfField((Wrapper)queryWrapper, IamResource::getPermissionCode);
    }

    @Override
    public List<ResourceRoleVO> getAllResourceRoleVOList() {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().isNotNull(IamResource::getPermissionCode);
        List list = this.iamResourceService.getEntityList((Wrapper)wrapper);
        if (list == null) {
            list = Collections.emptyList();
        }
        return Binder.convertAndBindRelations(list, ResourceRoleVO.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean createRoleResourceRelations(String roleId, List<String> resourceIdList) {
        if (V.isEmpty(resourceIdList)) {
            return true;
        }
        ArrayList<IamRoleResource> roleResourceList = new ArrayList<IamRoleResource>();
        for (String resourceId : resourceIdList) {
            roleResourceList.add(new IamRoleResource(roleId, resourceId));
        }
        boolean success = this.createEntities(roleResourceList);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new OperationEvent(IamRoleResource.class.getSimpleName(), (Object)roleId));
        return success;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateRoleResourceRelations(String roleId, List<String> resourceIdList) {
        if (resourceIdList == null) {
            return true;
        }
        this.deleteEntities((Wrapper)Wrappers.lambdaQuery().eq(IamRoleResource::getRoleId, (Object)roleId));
        if (resourceIdList.isEmpty()) {
            return true;
        }
        ArrayList<IamRoleResource> roleResourceList = new ArrayList<IamRoleResource>();
        for (String resourceId : resourceIdList) {
            roleResourceList.add(new IamRoleResource(roleId, resourceId));
        }
        boolean success = this.createEntities(roleResourceList);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new OperationEvent(IamRoleResource.class.getSimpleName(), (Object)roleId));
        return success;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteRoleResourceRelations(String roleId) {
        if (roleId == null) {
            return false;
        }
        boolean success = this.deleteEntities(IamRoleResource::getRoleId, roleId);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new OperationEvent(IamRoleResource.class.getSimpleName(), (Object)roleId));
        return success;
    }

    @Override
    public IamRoleService getRoleService() {
        return this.iamRoleService;
    }

    @Override
    public IamResourceService getPermissionService() {
        return this.iamResourceService;
    }

    private List<String> getPermissionIdsByRoleIds(List<String> roleIds) {
        if (V.isEmpty(roleIds)) {
            return Collections.emptyList();
        }
        return this.getValuesOfField((Wrapper)Wrappers.lambdaQuery().in(IamRoleResource::getRoleId, roleIds), IamRoleResource::getResourceId);
    }

    private void buildRouteRecordList(List<RouteRecord> routeRecordList, List<IamResourceListVO> iamResourceListVOList) {
        for (IamResourceListVO resource : iamResourceListVOList) {
            RouteRecord routeRecord = new RouteRecord();
            RouteMeta routeMeta = resource.getRouteMeta();
            routeMeta.setTitle(resource.getDisplayName()).setSort(resource.getSortId());
            if (V.notEmpty(resource.getPermissionList())) {
                routeMeta.setPermissions(resource.getPermissionList().stream().map(IamResource::getResourceCode).collect(Collectors.toList()));
            }
            routeRecord.setName(resource.getResourceCode()).setPath(resource.getRoutePath()).setRedirect(routeMeta.getRedirectPath()).setMeta(routeMeta);
            if (V.notEmpty(resource.getChildren())) {
                ArrayList<RouteRecord> routeRecordChildren = new ArrayList<RouteRecord>();
                this.buildRouteRecordList(routeRecordChildren, resource.getChildren());
                routeRecord.setChildren(routeRecordChildren);
            }
            routeRecordList.add(routeRecord);
        }
    }
}

