/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.diboot.core.binding.RelationsBinder;
import com.diboot.core.exception.BusinessException;
import com.diboot.core.service.I18nConfigService;
import com.diboot.core.service.impl.BaseServiceImpl;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.V;
import com.diboot.core.vo.LabelValue;
import com.diboot.core.vo.Status;
import com.diboot.iam.config.Cons;
import com.diboot.iam.dto.IamResourceDTO;
import com.diboot.iam.entity.IamResource;
import com.diboot.iam.mapper.IamResourceMapper;
import com.diboot.iam.service.IamResourceService;
import com.diboot.iam.vo.IamResourceListVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IamResourceServiceImpl
extends BaseServiceImpl<IamResourceMapper, IamResource>
implements IamResourceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamResourceServiceImpl.class);
    @Autowired(required=false)
    private I18nConfigService i18nConfigService;

    protected void beforeUpdate(IamResource entity) {
        String oldDisplayName;
        if (this.i18nConfigService != null && V.notEquals((Object)(oldDisplayName = (String)this.getValueOfField((Serializable)((Object)entity.getId()), IamResource::getDisplayName)), (Object)entity.getDisplayName())) {
            this.i18nConfigService.updateI18nContent("zh_CN", entity.getDisplayNameI18n(), entity.getDisplayName());
            log.debug("\u83dc\u5355 {} \u7684\u56fd\u9645\u5316\u4e2d\u6587\u5185\u5bb9\u5df2\u66f4\u6539\u4e3a {}", (Object)oldDisplayName, (Object)entity.getDisplayName());
        }
        super.beforeUpdate((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deepCreateResourceAndChildren(IamResourceListVO iamResource) {
        if (iamResource == null) {
            return;
        }
        if (!super.createEntity((Object)iamResource)) {
            log.warn("\u65b0\u5efa\u8d44\u6e90\u6743\u9650\u5931\u8d25\uff0cdisplayType = {}", (Object)iamResource.getDisplayType());
            throw new BusinessException(Status.FAIL_OPERATION, "exception.business.resourceService.createFailed", new Object[0]);
        }
        List<IamResourceListVO> children = iamResource.getChildren();
        if (V.notEmpty(children)) {
            for (IamResourceListVO vo : children) {
                vo.setParentId(iamResource.getId());
                if (V.isEmpty((String)vo.getId())) {
                    vo.setTenantId(iamResource.getTenantId());
                }
                this.deepCreateResourceAndChildren(vo);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createMenuResources(IamResourceDTO iamResourceDTO) {
        boolean success = this.createEntity((Object)iamResourceDTO);
        if (!success) {
            throw new BusinessException(Status.FAIL_OPERATION, "exception.business.resourceService.createFailed", new Object[0]);
        }
        List<IamResource> permissionList = iamResourceDTO.getPermissionList();
        if (V.isEmpty(permissionList)) {
            return;
        }
        permissionList.forEach(p -> {
            p.setParentId(iamResourceDTO.getId());
            p.setTenantId(iamResourceDTO.getTenantId());
            p.setDisplayType(Cons.RESOURCE_PERMISSION_DISPLAY_TYPE.PERMISSION.name());
        });
        this.createEntities(permissionList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMenuResources(IamResourceDTO iamResourceDTO) {
        if (V.equals((Object)iamResourceDTO.getId(), (Object)iamResourceDTO.getParentId())) {
            throw new BusinessException(Status.FAIL_OPERATION, "exception.business.resourceService.setParentIdEqId", new Object[0]);
        }
        this.updateEntity((Object)iamResourceDTO);
        List<IamResource> permissionList = iamResourceDTO.getPermissionList();
        permissionList.forEach(p -> {
            p.setParentId(iamResourceDTO.getId());
            if (V.isEmpty((String)p.getId())) {
                p.setTenantId(iamResourceDTO.getTenantId());
            }
            p.setDisplayType(Cons.RESOURCE_PERMISSION_DISPLAY_TYPE.PERMISSION.name());
        });
        List updatePermissionList = permissionList.stream().filter(p -> V.notEmpty((String)p.getId())).collect(Collectors.toList());
        List createPermissionList = permissionList.stream().filter(p -> V.isEmpty((String)p.getId())).collect(Collectors.toList());
        LambdaQueryWrapper deleteWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IamResource::getParentId, (Object)iamResourceDTO.getId())).eq(IamResource::getDisplayType, (Object)Cons.RESOURCE_PERMISSION_DISPLAY_TYPE.PERMISSION);
        if (V.notEmpty(updatePermissionList)) {
            deleteWrapper.notIn(IamResource::getId, (Collection)updatePermissionList.stream().map(IamResource::getId).collect(Collectors.toList()));
        }
        this.deleteEntities((Wrapper)deleteWrapper);
        if (V.notEmpty(createPermissionList)) {
            this.createEntities(createPermissionList);
        }
        if (V.notEmpty(updatePermissionList)) {
            this.updateEntities(updatePermissionList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteMenuResources(String id) {
        List<String> subMenuIdList;
        if (V.isEmpty((String)id)) {
            throw new BusinessException(Status.FAIL_OPERATION, "exception.business.resourceService.paramsError", new Object[0]);
        }
        this.deleteEntity((Serializable)((Object)id));
        LambdaQueryWrapper subWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IamResource::getParentId, (Object)id);
        List subList = this.getEntityList((Wrapper)subWrapper);
        if (subList.size() > 0) {
            this.deleteEntities((Wrapper)subWrapper);
        }
        if (V.notEmpty(subMenuIdList = subList.stream().filter(item -> Cons.RESOURCE_PERMISSION_DISPLAY_TYPE.MENU.name().equals(item.getDisplayType())).map(IamResource::getId).collect(Collectors.toList()))) {
            subMenuIdList.forEach(menuId -> {
                log.info("\u5f00\u59cb\u9012\u5f52\u5220\u9664\u5b50\u8d44\u6e90\uff1a{}", menuId);
                this.deleteMenuResources((String)menuId);
            });
        }
    }

    @Override
    public List<IamResource> getAllResources(String application) {
        List entList = this.getEntityList(null);
        return entList;
    }

    @Override
    public List<IamResourceListVO> getMenuResources(String application) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(V.notEmpty((String)application), IamResource::getAppModule, (Object)application)).ne(IamResource::getDisplayType, (Object)Cons.RESOURCE_PERMISSION_DISPLAY_TYPE.PERMISSION.name());
        List menuPermissionList = this.getEntityList((Wrapper)wrapper);
        if (V.isEmpty((Collection)menuPermissionList)) {
            return Collections.emptyList();
        }
        List iamResourceTreeVOList = RelationsBinder.convertAndBind((List)menuPermissionList, IamResourceListVO.class);
        return BeanUtils.buildTree((List)iamResourceTreeVOList, (Object)"0");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteMenuResources(List<String> idList) {
        List<String> subMenuIdList;
        if (V.isEmpty(idList)) {
            throw new BusinessException(Status.FAIL_OPERATION, "exception.business.resourceService.nullIdList", new Object[0]);
        }
        this.deleteEntities((Wrapper)Wrappers.lambdaQuery().in(IamResource::getId, idList));
        LambdaQueryWrapper subWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().in(IamResource::getParentId, idList);
        List subList = this.getEntityList((Wrapper)subWrapper);
        if (subList.size() > 0) {
            this.deleteEntities((Wrapper)subWrapper);
        }
        if (V.notEmpty(subMenuIdList = subList.stream().filter(item -> Cons.RESOURCE_PERMISSION_DISPLAY_TYPE.MENU.name().equals(item.getDisplayType())).map(IamResource::getId).collect(Collectors.toList()))) {
            this.deleteMenuResources(subMenuIdList);
        }
    }

    @Override
    public List<LabelValue> getMenuCatalogues() {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{IamResource::getDisplayName, IamResource::getId, IamResource::getRoutePath, IamResource::getParentId}).in(IamResource::getDisplayType, new Object[]{Cons.RESOURCE_PERMISSION_DISPLAY_TYPE.CATALOGUE.name()})).orderByAsc(IamResource::getSortId);
        return this.getLabelValueList((Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createOrUpdateMenuResources(IamResourceDTO resourceDTO) {
        if (V.isEmpty((String)resourceDTO.getId())) {
            this.createMenuResources(resourceDTO);
            return;
        }
        this.updateEntity((Object)resourceDTO);
        List<IamResource> permissionList = resourceDTO.getPermissionList();
        if (V.isEmpty(permissionList)) {
            return;
        }
        ArrayList resourceCodes = new ArrayList();
        permissionList.forEach(p -> {
            p.setParentId(resourceDTO.getId());
            p.setDisplayType(Cons.RESOURCE_PERMISSION_DISPLAY_TYPE.PERMISSION.name());
            resourceCodes.add(p.getResourceCode());
        });
        LambdaQueryWrapper oldPermissionsQuery = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(IamResource::getParentId, (Object)resourceDTO.getId())).eq(IamResource::getDisplayType, (Object)Cons.RESOURCE_PERMISSION_DISPLAY_TYPE.PERMISSION.name())).in(IamResource::getResourceCode, resourceCodes);
        List oldPermissionList = this.getEntityList((Wrapper)oldPermissionsQuery);
        Map<String, IamResource> oldPermissionMap = oldPermissionList.stream().collect(Collectors.toMap(IamResource::getResourceCode, p -> p));
        ArrayList<IamResource> updatePermissionList = new ArrayList<IamResource>();
        ArrayList<IamResource> createPermissionList = new ArrayList<IamResource>();
        for (IamResource current : permissionList) {
            IamResource originRes = oldPermissionMap.get(current.getResourceCode());
            if (originRes != null) {
                originRes.setMeta(current.getMeta()).setPermissionCode(current.getPermissionCode()).setDisplayName(current.getDisplayName());
                updatePermissionList.add(originRes);
                continue;
            }
            current.setTenantId(resourceDTO.getTenantId());
            createPermissionList.add(current);
        }
        if (V.notEmpty(createPermissionList)) {
            this.createEntities(createPermissionList);
        }
        if (V.notEmpty(updatePermissionList)) {
            this.updateEntities(updatePermissionList);
        }
    }
}

