/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.service.impl;

import com.diboot.core.service.impl.BaseServiceImpl;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.V;
import com.diboot.iam.entity.IamPosition;
import com.diboot.iam.entity.IamUserPosition;
import com.diboot.iam.mapper.IamPositionMapper;
import com.diboot.iam.service.IamPositionService;
import com.diboot.iam.service.IamUserPositionService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IamPositionServiceImpl
extends BaseServiceImpl<IamPositionMapper, IamPosition>
implements IamPositionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamPositionServiceImpl.class);
    @Autowired
    private IamUserPositionService iamUserPositionService;

    @Override
    public List<IamPosition> getPositionsByUser(String userType, String userId) {
        List<IamUserPosition> userPositionList = this.iamUserPositionService.getUserPositionListByUser(userType, userId);
        List positionIds = BeanUtils.collectToList(userPositionList, IamUserPosition::getPositionId);
        return V.isEmpty((Collection)positionIds) ? Collections.emptyList() : this.getEntityListByIds(positionIds);
    }

    @Override
    public List<IamPosition> getPositionsByOrg(String orgId) {
        List<String> positionIds = this.iamUserPositionService.getPositionIdsByOrg(orgId);
        return V.isEmpty(positionIds) ? Collections.emptyList() : this.getEntityListByIds(positionIds);
    }
}

