/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.diboot.core.config.BaseConfig;
import com.diboot.core.entity.AbstractEntity;
import com.diboot.core.entity.BaseTreeEntity;
import com.diboot.core.exception.BusinessException;
import com.diboot.core.service.impl.BaseServiceImpl;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.LabelValue;
import com.diboot.iam.config.Cons;
import com.diboot.iam.entity.IamOrg;
import com.diboot.iam.mapper.IamOrgMapper;
import com.diboot.iam.service.IamOrgService;
import com.diboot.iam.vo.IamOrgVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IamOrgServiceImpl
extends BaseServiceImpl<IamOrgMapper, IamOrg>
implements IamOrgService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamOrgServiceImpl.class);

    public boolean createEntity(IamOrg iamOrg) {
        this.enhanceIamOrg(iamOrg);
        return super.createEntity((Object)iamOrg);
    }

    public boolean updateEntity(IamOrg iamOrg) {
        this.enhanceIamOrg(iamOrg);
        return super.updateEntity((Object)iamOrg);
    }

    private void enhanceIamOrg(IamOrg iamOrg) {
        IamOrg parentOrg;
        if (!"0".equals(iamOrg.getParentId()) && (parentOrg = (IamOrg)((Object)this.getEntity(iamOrg.getParentId()))) != null) {
            if (Cons.DICTCODE_ORG_TYPE.COMP.name().equals(parentOrg.getType())) {
                iamOrg.setRootOrgId((String)((Object)parentOrg.getId()));
            } else {
                if (Cons.DICTCODE_ORG_TYPE.COMP.name().equals(iamOrg.getType())) {
                    throw new BusinessException("exception.business.orgService.deptHasComp", new Object[0]);
                }
                iamOrg.setRootOrgId(parentOrg.getRootOrgId());
            }
            if (V.isEmpty((String)parentOrg.getParentIdsPath())) {
                iamOrg.setParentIdsPath((String)((Object)parentOrg.getId()));
            } else {
                iamOrg.setParentIdsPath(S.joinWith((String)",", (Object[])new Object[]{parentOrg.getParentIdsPath(), parentOrg.getId()}));
            }
        }
    }

    @Override
    public List<String> getChildOrgIds(String rootOrgId) {
        if (rootOrgId == null) {
            return Collections.emptyList();
        }
        IamOrg parentOrg = (IamOrg)((Object)this.getEntity((Serializable)((Object)rootOrgId)));
        LambdaQueryWrapper select = Wrappers.lambdaQuery();
        if (parentOrg != null) {
            String parentIds = parentOrg.getParentIdsPath() == null ? rootOrgId + "," : (parentOrg.getParentIdsPath().endsWith(",") ? parentOrg.getParentIdsPath() + rootOrgId : parentOrg.getParentIdsPath() + "," + rootOrgId);
            select.likeRight(BaseTreeEntity::getParentIdsPath, (Object)parentIds);
        }
        select.orderByAsc(IamOrg::getSortId);
        return this.getValuesOfField((Wrapper)select, AbstractEntity::getId);
    }

    @Override
    public List<IamOrgVO> getOrgTree(String rootOrgId) {
        List orgList;
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.orderByAsc(IamOrg::getSortId);
        IamOrg parentOrg = (IamOrg)((Object)this.getEntity((Serializable)((Object)rootOrgId)));
        if (parentOrg != null) {
            String parentIds = parentOrg.getParentIdsPath() == null ? rootOrgId : S.joinWith((String)",", (Object[])new Object[]{parentOrg.getParentIdsPath(), rootOrgId});
            queryWrapper.likeRight(BaseTreeEntity::getParentIdsPath, (Object)parentIds);
        }
        if (V.isEmpty((Collection)(orgList = this.getEntityList((Wrapper)queryWrapper)))) {
            return Collections.emptyList();
        }
        List orgVOList = BeanUtils.convertList((List)orgList, IamOrgVO.class);
        return BeanUtils.buildTree((List)orgVOList, (Object)rootOrgId);
    }

    @Override
    public List<LabelValue> getSimpleOrgTree(String rootOrgId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.select(new SFunction[]{IamOrg::getName, AbstractEntity::getId, IamOrg::getCode, BaseTreeEntity::getParentId}).orderByAsc(IamOrg::getSortId);
        IamOrg parentOrg = (IamOrg)((Object)this.getEntity((Serializable)((Object)rootOrgId)));
        if (parentOrg != null) {
            String parentIds = parentOrg.getParentIdsPath() == null ? rootOrgId : S.joinWith((String)",", (Object[])new Object[]{parentOrg.getParentIdsPath(), rootOrgId});
            queryWrapper.likeRight(BaseTreeEntity::getParentIdsPath, (Object)parentIds);
        }
        return this.getLabelValueList((Wrapper)queryWrapper);
    }

    @Override
    public List<String> getParentOrgIds(String orgId) {
        IamOrg parentOrg = (IamOrg)((Object)this.getEntity((Serializable)((Object)orgId)));
        if (parentOrg == null || parentOrg.getParentIdsPath() == null) {
            return Collections.emptyList();
        }
        return S.splitToList((String)parentOrg.getParentIdsPath());
    }

    @Override
    public List<String> getOrgIdsByManagerId(String managerId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IamOrg::getManagerId, (Object)managerId)).orderByAsc(IamOrg::getSortId);
        return this.getValuesOfField((Wrapper)queryWrapper, AbstractEntity::getId);
    }

    @Override
    public Map<String, LabelValue> getLabelValueMap(List<String> ids) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{IamOrg::getName, AbstractEntity::getId, IamOrg::getCode}).in(AbstractEntity::getId, ids);
        return this.getEntityList((Wrapper)queryWrapper).stream().collect(Collectors.toMap(ent -> (String)((Object)ent.getId()), ent -> new LabelValue(ent.getName(), (Object)ent.getId()).setExt((Object)ent.getCode())));
    }

    @Override
    public String getTenantRootOrgId(String tenantId) {
        return ((IamOrgMapper)this.getMapper()).getTenantRootOrgId(tenantId, BaseConfig.getActiveFlagValue());
    }
}

