/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.diboot.core.entity.AbstractEntity;
import com.diboot.core.service.impl.BaseServiceImpl;
import com.diboot.core.util.Encryptor;
import com.diboot.core.util.V;
import com.diboot.iam.entity.BaseLoginUser;
import com.diboot.iam.entity.IamLoginTrace;
import com.diboot.iam.mapper.IamLoginTraceMapper;
import com.diboot.iam.service.IamLoginTraceService;
import com.diboot.iam.shiro.IamAuthToken;
import com.diboot.iam.util.IamSecurityUtils;
import com.diboot.iam.util.TokenUtils;
import com.diboot.iam.vo.IamLoginTraceVO;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IamLoginTraceServiceImpl
extends BaseServiceImpl<IamLoginTraceMapper, IamLoginTrace>
implements IamLoginTraceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamLoginTraceServiceImpl.class);

    @Override
    public boolean updateLogoutInfo(String token, String userType, String userId) {
        IamLoginTrace latestTrace;
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().select(new SFunction[]{AbstractEntity::getId}).eq(IamLoginTrace::getUserType, (Object)userType)).eq(IamLoginTrace::getUserId, (Object)userId)).eq(IamLoginTrace::getIsSuccess, (Object)true)).orderByDesc(AbstractEntity::getId);
        if (V.notEmpty((String)token)) {
            queryWrapper.eq(IamLoginTrace::getSignature, (Object)Encryptor.encrypt((String)token, (String[])new String[0]));
        }
        if ((latestTrace = (IamLoginTrace)((Object)this.getSingleEntity((Wrapper)queryWrapper))) != null) {
            LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().set(IamLoginTrace::getLogoutTime, (Object)LocalDateTime.now())).eq(AbstractEntity::getId, (Object)latestTrace.getId());
            return super.update((Wrapper)updateWrapper);
        }
        return false;
    }

    @Override
    public void saveTokenRefreshTrace(String refreshToken, String oldToken) {
        String oldSignature = Encryptor.encrypt((String)oldToken, (String[])new String[0]);
        BaseLoginUser user = (BaseLoginUser)((Object)IamSecurityUtils.getCurrentUser());
        String newSignature = Encryptor.encrypt((String)refreshToken, (String[])new String[0]);
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(IamLoginTrace::getSignature, (Object)newSignature)).set(IamLoginTrace::getSignType, (Object)IamLoginTrace.SIGN_TYPE.REFRESH_TOKEN.name())).eq(IamLoginTrace::getSignature, (Object)oldSignature);
        if (user != null) {
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(IamLoginTrace::getUserType, (Object)user.getUserType())).eq(IamLoginTrace::getUserId, (Object)user.getId())).eq(IamLoginTrace::getIsSuccess, (Object)true);
        }
        this.updateEntity((Wrapper)updateWrapper);
    }

    @Override
    public void appendLoginStatus(List<IamLoginTraceVO> voList) {
        if (V.isEmpty(voList)) {
            return;
        }
        for (IamLoginTraceVO vo : voList) {
            if (V.notEmpty((Object)vo.getLogoutTime())) {
                vo.setOnlineStatus(IamLoginTraceVO.ONLINE_STATUS.LOGOUT.name());
                continue;
            }
            if (V.isEmpty((String)vo.getSignature())) {
                vo.setOnlineStatus(IamLoginTraceVO.ONLINE_STATUS.UNKNOWN.name());
                continue;
            }
            String token = Encryptor.decrypt((String)vo.getSignature(), (String[])new String[0]);
            if (V.isEmpty((String)token)) {
                vo.setOnlineStatus(IamLoginTraceVO.ONLINE_STATUS.UNKNOWN.name());
                continue;
            }
            String cachedUserInfo = TokenUtils.getCachedUserInfoStr(token);
            if (V.isEmpty((String)cachedUserInfo)) {
                vo.setOnlineStatus(IamLoginTraceVO.ONLINE_STATUS.INVALID.name());
                continue;
            }
            IamAuthToken authToken = new IamAuthToken(cachedUserInfo);
            if (vo.isExpired(authToken.getExpiresInMinutes())) {
                vo.setOnlineStatus(IamLoginTraceVO.ONLINE_STATUS.INVALID.name());
                continue;
            }
            vo.setOnlineStatus(IamLoginTraceVO.ONLINE_STATUS.ONLINE.name());
        }
    }
}

