/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.diboot.core.config.BaseConfig;
import com.diboot.core.entity.AbstractEntity;
import com.diboot.core.exception.BusinessException;
import com.diboot.core.service.impl.BaseServiceImpl;
import com.diboot.core.util.V;
import com.diboot.core.vo.Status;
import com.diboot.iam.auth.IamCustomize;
import com.diboot.iam.config.Cons;
import com.diboot.iam.dto.ChangePwdDTO;
import com.diboot.iam.entity.IamAccount;
import com.diboot.iam.mapper.IamAccountMapper;
import com.diboot.iam.service.IamAccountService;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IamAccountServiceImpl
extends BaseServiceImpl<IamAccountMapper, IamAccount>
implements IamAccountService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamAccountServiceImpl.class);
    @Autowired(required=false)
    private IamCustomize iamCustomize;

    @Override
    public boolean createEntity(IamAccount iamAccount) {
        if (V.notEmpty((String)iamAccount.getAuthSecret())) {
            this.iamCustomize.encryptPwd(iamAccount);
        }
        return super.createEntity((Object)iamAccount);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean createEntities(List<IamAccount> accountList) {
        if (V.isEmpty(accountList)) {
            return true;
        }
        for (IamAccount account : accountList) {
            if (!V.notEmpty((String)account.getAuthSecret())) continue;
            this.iamCustomize.encryptPwd(account);
        }
        return super.createEntities(accountList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean changePwd(ChangePwdDTO changePwdDTO, IamAccount iamAccount) throws Exception {
        if (iamAccount == null) {
            throw new BusinessException(Status.FAIL_OPERATION, "exception.business.account.nonExist", new Object[0]);
        }
        if (!Cons.DICTCODE_AUTH_TYPE.PWD.name().equals(iamAccount.getAuthType())) {
            throw new BusinessException(Status.FAIL_OPERATION, "exception.business.account.nonSupportModifyPwd", new Object[0]);
        }
        if (V.notEquals((Object)changePwdDTO.getPassword(), (Object)changePwdDTO.getConfirmPassword())) {
            throw new BusinessException(Status.FAIL_OPERATION, "exception.business.account.pwdInconformable", new Object[0]);
        }
        String oldAuthSecret = this.iamCustomize.encryptPwd(changePwdDTO.getOldPassword(), iamAccount.getSecretSalt());
        if (V.notEquals((Object)oldAuthSecret, (Object)iamAccount.getAuthSecret())) {
            throw new BusinessException(Status.FAIL_OPERATION, "exception.business.account.oldPwdError", new Object[0]);
        }
        iamAccount.setAuthSecret(changePwdDTO.getPassword());
        this.iamCustomize.encryptPwd(iamAccount);
        boolean success = this.updateEntity((Object)iamAccount);
        return success;
    }

    @Override
    public String getAuthAccount(String userType, String userId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().select(new SFunction[]{IamAccount::getAuthAccount}).eq(IamAccount::getUserType, (Object)userType)).eq(IamAccount::getUserId, (Object)userId);
        IamAccount account = (IamAccount)((Object)this.getSingleEntity((Wrapper)queryWrapper));
        return account != null ? account.getAuthAccount() : null;
    }

    @Override
    public boolean isAccountExists(IamAccount iamAccount) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(IamAccount::getAuthAccount, (Object)iamAccount.getAuthAccount())).eq(IamAccount::getAuthType, (Object)iamAccount.getAuthType())).eq(IamAccount::getUserType, (Object)iamAccount.getUserType())).ne(V.notEmpty((String)iamAccount.getUserId()), IamAccount::getUserId, (Object)iamAccount.getUserId())).orderByDesc(AbstractEntity::getId);
        return this.exists((Wrapper)queryWrapper);
    }

    @Override
    public boolean isAccountExists(String tenantId, String userType, String username, String userId) {
        return ((IamAccountMapper)this.baseMapper).checkUsernameDuplicate(tenantId, userType, username, userId, BaseConfig.getActiveFlagValue());
    }

    @Override
    public boolean updateAccountStatus(String accountId, String status) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().set(IamAccount::getStatus, (Object)status)).eq(AbstractEntity::getId, (Object)accountId);
        return super.update((Wrapper)updateWrapper);
    }

    public void beforeCreate(IamAccount iamAccount) {
        if (this.isAccountExists(iamAccount)) {
            log.warn("\u4fdd\u5b58\u8d26\u53f7\u5f02\u5e38: \u8d26\u53f7 {} \u5df2\u5b58\u5728", (Object)iamAccount.getAuthAccount());
            throw new BusinessException(Status.FAIL_VALIDATION, "exception.business.account.exist", new Object[]{iamAccount.getAuthAccount()});
        }
    }

    public void beforeUpdate(IamAccount iamAccount) {
        this.beforeCreate(iamAccount);
    }
}

