/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.redis;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class ShiroRedisCache<K, V>
implements Cache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(ShiroRedisCache.class);
    private RedisTemplate redisTemplate;
    private String cacheName;
    private static final String SUFFIX_KEYS = "_KEYS";
    private int tokenExpireMinutes;

    public ShiroRedisCache(String cacheName, RedisTemplate redisTemplate, int tokenExpireMinutes) {
        this.cacheName = cacheName;
        this.redisTemplate = redisTemplate;
        this.tokenExpireMinutes = tokenExpireMinutes;
    }

    private String getKey(String key) {
        return this.cacheName + ":" + key;
    }

    public V get(K k) throws CacheException {
        String key = this.getKey(k.toString());
        log.debug("get key : {}", (Object)key);
        return (V)this.redisTemplate.opsForValue().get((Object)key);
    }

    public V put(K k, V v) throws CacheException {
        if (k == null || v == null) {
            return null;
        }
        String key = this.getKey(k.toString());
        log.debug("put key : {}, value: {}", (Object)key, v);
        this.redisTemplate.opsForValue().set((Object)key, v, (long)this.tokenExpireMinutes, TimeUnit.MINUTES);
        this.redisTemplate.opsForSet().add((Object)(this.cacheName + SUFFIX_KEYS), new Object[]{key});
        log.debug("redis\u7f13\u5b58\u65b0\u589ekey\uff1a{}", (Object)key);
        return v;
    }

    public V remove(K k) throws CacheException {
        if (k == null) {
            return null;
        }
        String key = this.getKey(k.toString());
        V value = this.get(k);
        log.debug("remove key : {}", (Object)key);
        this.redisTemplate.delete((Object)key);
        this.redisTemplate.opsForSet().remove((Object)(this.cacheName + SUFFIX_KEYS), new Object[]{key});
        log.debug("redis\u7f13\u5b58\u79fb\u9664key\uff1a{}", (Object)key);
        return value;
    }

    public void clear() throws CacheException {
        this.redisTemplate.delete(this.keys());
    }

    public int size() {
        return this.keys().size();
    }

    public Set<K> keys() {
        return this.redisTemplate.opsForSet().members((Object)(this.cacheName + SUFFIX_KEYS));
    }

    public Collection<V> values() {
        Set<K> keys = this.keys();
        HashSet<Object> values = new HashSet<Object>(keys.size());
        for (K key : keys) {
            Object value = this.redisTemplate.opsForValue().get(key);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }
}

