/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.listener;

import com.diboot.core.event.ExceptionEvent;
import com.diboot.core.util.BeanUtils;
import com.diboot.iam.entity.IamOperationLog;
import com.diboot.iam.entity.IamUser;
import com.diboot.iam.service.IamOperationLogService;
import com.diboot.iam.util.IamSecurityUtils;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"diboot.iam.save-exception-stack-trace"}, havingValue="true")
public class ExceptionEventListener
implements ApplicationListener<ExceptionEvent> {
    @Autowired
    private IamOperationLogService operationLogService;

    public void onApplicationEvent(ExceptionEvent event) {
        IamUser user = null;
        try {
            user = (IamUser)((Object)IamSecurityUtils.getCurrentUser());
        }
        catch (Exception exception) {
            // empty catch block
        }
        IamOperationLog operationLog = new IamOperationLog();
        Map msgMap = event.getMsgMap();
        int code = (Integer)msgMap.get("code");
        String msg = (String)msgMap.get("msg");
        msgMap.remove("code");
        msgMap.remove("msg");
        BeanUtils.bindProperties((Object)((Object)operationLog), (Map)msgMap);
        if (user != null) {
            operationLog.setUserType(((Object)((Object)user)).getClass().getSimpleName()).setUserId((String)((Object)user.getId())).setUserRealname(user.getRealname());
        } else {
            operationLog.setUserType("-").setUserId("-1").setUserRealname("-");
        }
        Exception exception = (Exception)event.getSource();
        operationLog.setBusinessObj("Exception").setOperation("\u5f02\u5e38").setErrorMsg(this.extractStackTrace(exception)).setStatusCode(code);
        this.operationLogService.createEntity((Object)operationLog);
        event.getMsgMap().put("code", code);
        event.getMsgMap().put("msg", msg);
    }

    private String extractStackTrace(Exception e) {
        StringBuilder sb = new StringBuilder(e.getClass().getName()).append(": ").append(e.getMessage());
        for (StackTraceElement element : e.getStackTrace()) {
            sb.append("\n\tat ").append(element.getClassName()).append(element.getMethodName()).append("(").append(element.getFileName()).append(":").append(element.getLineNumber()).append(")");
        }
        Throwable ourCause = e.getCause();
        if (ourCause != null) {
            sb.append("\nCaused by: ").append(ourCause.getMessage());
        }
        return sb.toString();
    }
}

