/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.init;

import com.diboot.core.cache.BaseCacheManager;
import com.diboot.core.cache.DynamicRedisCacheManager;
import com.diboot.core.config.Cons;
import com.diboot.iam.cache.SystemConfigCacheManager;
import com.diboot.iam.config.IamProperties;
import com.diboot.iam.redis.ShiroRedisCacheManager;
import com.diboot.starter.IamAutoConfig;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shiro.cache.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;

@Order(value=911)
@Configuration
@ConditionalOnBean(value={RedisTemplate.class})
@ConditionalOnClass(value={RedisOperations.class})
@ConditionalOnResource(resources={"org/springframework/data/redis"})
@AutoConfigureBefore(value={IamAutoConfig.class})
public class IamRedisAutoConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamRedisAutoConfig.class);
    @Autowired
    private IamProperties iamProperties;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public IamRedisAutoConfig() {
        log.info("\u521d\u59cb\u5316 IAM \u7ec4\u4ef6 Redis \u81ea\u52a8\u914d\u7f6e");
    }

    @Bean(name={"shiroCacheManager"})
    @ConditionalOnMissingBean(value={CacheManager.class})
    public CacheManager shiroCacheManager(RedisTemplate<String, Object> redisTemplate) {
        log.info("\u521d\u59cb\u5316shiro\u7f13\u5b58: ShiroRedisCacheManager");
        return new ShiroRedisCacheManager(redisTemplate, this.iamProperties.getTokenExpiresMinutes());
    }

    @Bean(name={"iamCacheManager"})
    @ConditionalOnMissingBean(name={"iamCacheManager"})
    public BaseCacheManager iamCacheManager() {
        log.info("\u521d\u59cb\u5316 IAM Redis\u7f13\u5b58: DynamicRedisCacheManager");
        HashMap<String, Integer> cacheName2ExpireMap = new HashMap<String, Integer>(){
            {
                this.put("token-userinfo", IamRedisAutoConfig.this.iamProperties.getTokenExpiresMinutes());
                this.put("token-refresh", 10);
                this.put("CAPTCHA", 5);
            }
        };
        return new DynamicRedisCacheManager(this.redisTemplate, (Map)cacheName2ExpireMap);
    }

    @Bean
    @ConditionalOnMissingBean
    public SystemConfigCacheManager systemConfigCacheManager() {
        log.info("\u521d\u59cb\u5316 SystemConfig Redis\u7f13\u5b58: DynamicRedisCacheManager");
        HashMap<String, Integer> cacheName2ExpireMap = new HashMap<String, Integer>(){
            {
                this.put(Cons.CACHE_NAME_SYSTEM_CONFIG, 1440);
            }
        };
        DynamicRedisCacheManager memoryCacheManager = new DynamicRedisCacheManager(this.redisTemplate, (Map)cacheName2ExpireMap);
        return new SystemConfigCacheManager((BaseCacheManager)memoryCacheManager);
    }
}

