/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.init;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.diboot.core.entity.Dictionary;
import com.diboot.core.entity.I18nConfig;
import com.diboot.core.exception.BusinessException;
import com.diboot.core.mapper.I18nConfigMapper;
import com.diboot.core.service.DictionaryService;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.JSON;
import com.diboot.core.util.SqlFileInitializer;
import com.diboot.core.vo.DictionaryVO;
import com.diboot.iam.config.Cons;
import com.diboot.iam.entity.IamAccount;
import com.diboot.iam.entity.IamOrg;
import com.diboot.iam.entity.IamResource;
import com.diboot.iam.entity.IamRole;
import com.diboot.iam.entity.IamUser;
import com.diboot.iam.entity.IamUserRole;
import com.diboot.iam.service.IamAccountService;
import com.diboot.iam.service.IamOrgService;
import com.diboot.iam.service.IamResourceService;
import com.diboot.iam.service.IamRoleService;
import com.diboot.iam.service.IamUserRoleService;
import com.diboot.iam.service.IamUserService;
import com.diboot.iam.vo.IamResourceListVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=912)
@Component
@ConditionalOnProperty(prefix="diboot", name={"init-sql"}, havingValue="true")
public class IamPluginInitializer
implements ApplicationRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamPluginInitializer.class);

    public void run(ApplicationArguments args) throws Exception {
        String initDetectSql = "SELECT id FROM dbt_iam_role WHERE id='0'";
        if (!SqlFileInitializer.checkSqlExecutable((String)initDetectSql)) {
            log.info("diboot-IAM \u521d\u59cb\u5316SQL ...");
            SqlFileInitializer.initBootstrapSql(this.getClass(), (String)"iam");
            this.insertInitData();
            log.info("diboot-IAM \u521d\u59cb\u5316SQL\u5b8c\u6210.");
        }
    }

    private synchronized void insertInitData() {
        IamRoleService iamRoleService;
        I18nConfigMapper i18nConfigMapper;
        IamResourceService resourcePermissionService;
        DictionaryService dictionaryService = (DictionaryService)ContextHolder.getBean(DictionaryService.class);
        if (dictionaryService != null && !dictionaryService.exists(Dictionary::getType, (Object)"AUTH_TYPE")) {
            String[] DICT_INIT_DATA;
            for (String dictJson : DICT_INIT_DATA = new String[]{"{\"type\":\"AUTH_TYPE\", \"itemName\":\"\u767b\u5f55\u8ba4\u8bc1\u65b9\u5f0f\", \"description\":\"IAM\u7528\u6237\u767b\u5f55\u8ba4\u8bc1\u65b9\u5f0f\", \"children\":[{\"itemName\":\"\u7528\u6237\u540d\u5bc6\u7801\", \"itemNameI18n\":\"Dictionary.AUTH_TYPE.PWD\", \"itemValue\":\"PWD\", \"sortId\":1},{\"itemName\":\"\u5355\u70b9\u767b\u5f55\", \"itemNameI18n\":\"Dictionary.AUTH_TYPE.SSO\", \"itemValue\":\"SSO\", \"sortId\":2},{\"itemName\":\"\u516c\u4f17\u53f7\", \"itemNameI18n\":\"Dictionary.AUTH_TYPE.WX_MP\", \"itemValue\":\"WX_MP\", \"sortId\":3},{\"itemName\":\"\u4f01\u4e1a\u5fae\u4fe1\", \"itemNameI18n\":\"Dictionary.AUTH_TYPE.WX_CP\", \"itemValue\":\"WX_CP\", \"sortId\":4},{\"itemName\":\"\u5176\u4ed6\", \"itemNameI18n\":\"Dictionary.AUTH_TYPE.Other\", \"itemValue\":\"OTHER\", \"sortId\":5}]}", "{\"type\":\"ACCOUNT_STATUS\",\"itemName\":\"\u8d26\u53f7\u72b6\u6001\", \"description\":\"IAM\u767b\u5f55\u8d26\u53f7\u72b6\u6001\",\"children\":[{\"itemName\":\"\u6709\u6548\",\"itemNameI18n\":\"Dictionary.ACCOUNT_STATUS.A\", \"itemValue\":\"A\",\"extension\":{\"color\":\"#2ECC71\"},\"sortId\":1},{\"itemName\":\"\u65e0\u6548\",\"itemNameI18n\":\"Dictionary.ACCOUNT_STATUS.I\", \"itemValue\":\"I\",\"sortId\":2},{\"itemName\":\"\u9501\u5b9a\",\"itemNameI18n\":\"Dictionary.ACCOUNT_STATUS.L\", \"itemValue\":\"L\",\"extension\":{\"color\":\"#FF6F00\"},\"sortId\":3}]}", "{\"type\":\"USER_STATUS\",\"itemName\":\"\u7528\u6237\u72b6\u6001\", \"description\":\"IAM\u7528\u6237\u72b6\u6001\",\"isEditable\":true,\"children\":[{\"itemName\":\"\u5728\u804c\",\"itemNameI18n\":\"Dictionary.USER_STATUS.A\", \"itemValue\":\"A\",\"extension\":{\"color\":\"#2ECC71\"},\"sortId\":1},{\"itemName\":\"\u79bb\u804c\",\"itemNameI18n\":\"Dictionary.USER_STATUS.I\", \"itemValue\":\"I\",\"sortId\":2}]}", "{\"itemName\":\"\u7528\u6237\u6027\u522b\", \"type\":\"GENDER\",\"description\":\"\u7528\u6237\u6027\u522b\u6570\u636e\u5b57\u5178\",\"children\":[{\"itemValue\":\"F\",\"itemName\":\"\u5973\",\"itemNameI18n\":\"Dictionary.GENDER.F\",\"extension\":{\"color\":\"#FD8BB8\"}},{\"itemValue\":\"M\",\"itemName\":\"\u7537\",\"itemNameI18n\":\"Dictionary.GENDER.M\",\"extension\":{\"color\":\"#55B0EE\"}}]}", "{\"type\":\"RESOURCE_TYPE\", \"itemName\":\"\u8d44\u6e90\u7c7b\u578b\", \"description\":\"IAM\u8d44\u6e90\u7c7b\u578b\", \"children\":[{\"itemName\":\"\u83dc\u5355\", \"itemNameI18n\":\"Dictionary.RESOURCE_TYPE.MENU\", \"itemValue\":\"MENU\", \"sortId\":1},{\"itemName\":\"\u6309\u94ae/\u64cd\u4f5c\", \"itemNameI18n\":\"Dictionary.RESOURCE_TYPE.OPERATION\", \"itemValue\":\"OPERATION\", \"sortId\":2}]}", "{\"itemName\":\"\u524d\u7aef\u6309\u94ae/\u6743\u9650\u7f16\u7801\", \"type\":\"RESOURCE_CODE\",\"description\":\"\u524d\u7aef\u6309\u94ae/\u6743\u9650\u7f16\u7801 \u5e38\u7528\u9009\u9879\",\"children\":[{\"sortId\":1,\"itemName\":\"\u8be6\u60c5\",\"itemNameI18n\":\"Dictionary.RESOURCE_CODE.detail\", \"itemValue\":\"detail\"},{\"sortId\":2,\"itemName\":\"\u65b0\u5efa\",\"itemNameI18n\":\"Dictionary.RESOURCE_CODE.create\", \"itemValue\":\"create\"},{\"sortId\":3,\"itemName\":\"\u66f4\u65b0\",\"itemNameI18n\":\"Dictionary.RESOURCE_CODE.update\", \"itemValue\":\"update\"},{\"sortId\":4,\"itemName\":\"\u5220\u9664\",\"itemNameI18n\":\"Dictionary.RESOURCE_CODE.delete\", \"itemValue\":\"delete\"},{\"sortId\":5,\"itemName\":\"\u5bfc\u51fa\",\"itemNameI18n\":\"Dictionary.RESOURCE_CODE.export\", \"itemValue\":\"export\"},{\"sortId\":6,\"itemName\":\"\u5bfc\u5165\",\"itemNameI18n\":\"Dictionary.RESOURCE_CODE.import\", \"itemValue\":\"import\"}]}", "{\"type\":\"ORG_TYPE\", \"itemName\":\"\u7ec4\u7ec7\u7c7b\u578b\", \"description\":\"\u7ec4\u7ec7\u8282\u70b9\u7c7b\u578b\", \"isEditable\":false, \"children\":[{\"itemName\":\"\u90e8\u95e8\", \"itemNameI18n\":\"Dictionary.ORG_TYPE.DEPT\", \"itemValue\":\"DEPT\", \"sortId\":1},{\"itemName\":\"\u516c\u53f8\", \"itemNameI18n\":\"Dictionary.ORG_TYPE.COMP\", \"itemValue\":\"COMP\", \"sortId\":2}]}", "{\"type\":\"DATA_PERMISSION_TYPE\", \"itemName\":\"IAM\u6570\u636e\u6743\u9650\u7c7b\u578b\", \"description\":\"IAM\u6570\u636e\u6743\u9650\u7c7b\u578b\u5b9a\u4e49\", \"isEditable\":true, \"children\":[{\"itemName\":\"\u672c\u4eba\", \"itemNameI18n\":\"Dictionary.DATA_PERMISSION_TYPE.SELF\", \"itemValue\":\"SELF\", \"sortId\":1},{\"itemName\":\"\u672c\u4eba\u53ca\u4e0b\u5c5e\", \"itemNameI18n\":\"Dictionary.DATA_PERMISSION_TYPE.SELF_AND_SUB\", \"itemValue\":\"SELF_AND_SUB\", \"sortId\":2},{\"itemName\":\"\u672c\u90e8\u95e8\", \"itemNameI18n\":\"Dictionary.DATA_PERMISSION_TYPE.DEPT\", \"itemValue\":\"DEPT\", \"sortId\":3},{\"itemName\":\"\u672c\u90e8\u95e8\u53ca\u4e0b\u5c5e\u90e8\u95e8\", \"itemNameI18n\":\"Dictionary.DATA_PERMISSION_TYPE.DEPT_AND_SUB\", \"itemValue\":\"DEPT_AND_SUB\", \"sortId\":4},{\"itemName\":\"\u5168\u90e8\", \"itemNameI18n\":\"Dictionary.DATA_PERMISSION_TYPE.ALL\", \"itemValue\":\"ALL\", \"sortId\":5}]}", "{\"type\":\"POSITION_GRADE\", \"itemName\":\"\u804c\u7ea7\u5b9a\u4e49\", \"description\":\"\u804c\u52a1\u7ea7\u522b\u5b9a\u4e49\", \"isEditable\":true, \"children\":[{\"itemName\":\"\u521d\u7ea7\", \"itemNameI18n\":\"Dictionary.POSITION_GRADE.E1\", \"itemValue\":\"E1\", \"sortId\":1},{\"itemName\":\"\u4e2d\u7ea7\", \"itemNameI18n\":\"Dictionary.POSITION_GRADE.E2\", \"itemValue\":\"E2\", \"sortId\":2},{\"itemName\":\"\u9ad8\u7ea7\", \"itemNameI18n\":\"Dictionary.POSITION_GRADE.E3\", \"itemValue\":\"E3\", \"sortId\":3},{\"itemName\":\"\u4e13\u5bb6\", \"itemNameI18n\":\"Dictionary.POSITION_GRADE.E4\", \"itemValue\":\"E4\", \"sortId\":4}]}"}) {
                DictionaryVO dictVo = (DictionaryVO)JSON.toJavaObject((String)dictJson, DictionaryVO.class);
                dictVo.setParentId("0");
                dictionaryService.createDictAndChildren(dictVo);
            }
        }
        if ((resourcePermissionService = (IamResourceService)ContextHolder.getBean(IamResourceService.class)) != null && !resourcePermissionService.exists(IamResource::getResourceCode, "system")) {
            String[] RESOURCE_PERMISSION_DATA = new String[]{"{\"displayType\":\"CATALOGUE\",\"displayName\":\"\u7ec4\u7ec7\u4eba\u5458\",\"displayNameI18n\":\"Resource.OrgStructure\",\"routePath\":\"org-structure\",\"resourceCode\":\"OrgStructure\",\"meta\":\"{\\\"icon\\\":\\\"Element:UserFilled\\\"}\",\"sortId\":\"90\",\"children\":[{\"displayType\":\"MENU\",\"displayName\":\"\u4eba\u5458\u7ba1\u7406\",\"displayNameI18n\":\"Resource.User\",\"routePath\":\"user\",\"resourceCode\":\"User\",\"permissionCode\":\"IamOrg:read,IamUser:read\",\"meta\":\"{\\\"icon\\\":\\\"Element:User\\\",\\\"componentPath\\\":\\\"@/views/org-structure/user/index.vue\\\"}\",\"sortId\":\"1\",\"children\":[{\"displayType\":\"PERMISSION\",\"displayName\":\"\u65b0\u5efa\",\"resourceCode\":\"create\",\"displayNameI18n\":\"operation.create\",\"permissionCode\":\"IamUser:write\",\"sortId\":\"40\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u66f4\u65b0\",\"resourceCode\":\"update\",\"displayNameI18n\":\"operation.update\",\"permissionCode\":\"IamUser:write,IamUser:read\",\"sortId\":\"39\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u5220\u9664\",\"resourceCode\":\"delete\",\"displayNameI18n\":\"operation.delete\",\"permissionCode\":\"IamUser:write\",\"sortId\":\"38\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u8be6\u60c5\",\"resourceCode\":\"detail\",\"displayNameI18n\":\"operation.detail\",\"permissionCode\":\"IamUser:read\",\"sortId\":\"37\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u5bfc\u5165\",\"resourceCode\":\"import\",\"displayNameI18n\":\"operation.import\",\"permissionCode\":\"IamUserExcel:import\",\"sortId\":\"36\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u5bfc\u51fa\",\"resourceCode\":\"export\",\"displayNameI18n\":\"operation.export\",\"permissionCode\":\"IamUserExcel:export\",\"sortId\":\"35\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u4eba\u5458\u5c97\u4f4d\u8bbe\u7f6e\",\"resourceCode\":\"position\",\"displayNameI18n\":\"Resource.User.PositionSetting\",\"permissionCode\":\"IamPosition:write,IamPosition:read\",\"sortId\":\"34\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u6dfb\u52a0\u5c97\u4f4d\",\"resourceCode\":\"addPosition\",\"displayNameI18n\":\"Resource.User.AddPosition\",\"permissionCode\":\"IamPosition:write,IamPosition:read\",\"sortId\":\"33\"}]},{\"displayType\":\"MENU\",\"displayName\":\"\u7ec4\u7ec7\u90e8\u95e8\",\"displayNameI18n\":\"Resource.Org\",\"routePath\":\"org\",\"resourceCode\":\"Org\",\"permissionCode\":\"IamOrg:read\",\"meta\":\"{\\\"icon\\\":\\\"Element:Folder\\\",\\\"componentPath\\\":\\\"@/views/org-structure/org/index.vue\\\"}\",\"sortId\":\"2\",\"children\":[{\"displayType\":\"PERMISSION\",\"displayName\":\"\u6392\u5e8f\",\"resourceCode\":\"sort\",\"displayNameI18n\":\"operation.sort\",\"permissionCode\":\"IamOrg:write\",\"sortId\":\"106\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u5220\u9664\",\"resourceCode\":\"delete\",\"displayNameI18n\":\"operation.delete\",\"permissionCode\":\"IamOrg:write\",\"sortId\":\"105\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u66f4\u65b0\",\"resourceCode\":\"update\",\"displayNameI18n\":\"operation.update\",\"permissionCode\":\"IamOrg:write,IamOrg:read\",\"sortId\":\"104\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u65b0\u5efa\",\"resourceCode\":\"create\",\"displayNameI18n\":\"operation.create\",\"permissionCode\":\"IamOrg:write\",\"sortId\":\"103\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u8be6\u60c5\",\"resourceCode\":\"detail\",\"displayNameI18n\":\"operation.detail\",\"permissionCode\":\"IamOrg:read\",\"sortId\":\"102\"}]},{\"displayType\":\"MENU\",\"displayName\":\"\u5c97\u4f4d\u7ba1\u7406\",\"displayNameI18n\":\"Resource.Position\",\"routePath\":\"position\",\"resourceCode\":\"Position\",\"permissionCode\":\"IamPosition:read\",\"meta\":\"{\\\"icon\\\":\\\"Element:Postcard\\\",\\\"componentPath\\\":\\\"@/views/org-structure/position/List.vue\\\"}\",\"sortId\":\"3\",\"children\":[{\"displayType\":\"PERMISSION\",\"displayName\":\"\u5220\u9664\",\"resourceCode\":\"delete\",\"displayNameI18n\":\"operation.delete\",\"permissionCode\":\"IamPosition:write\",\"sortId\":\"112\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u8be6\u60c5\",\"resourceCode\":\"detail\",\"displayNameI18n\":\"operation.detail\",\"permissionCode\":\"IamPosition:read\",\"sortId\":\"111\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u66f4\u65b0\",\"resourceCode\":\"update\",\"displayNameI18n\":\"operation.update\",\"permissionCode\":\"IamPosition:write,IamPosition:read\",\"sortId\":\"110\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u65b0\u5efa\",\"resourceCode\":\"create\",\"displayNameI18n\":\"operation.create\",\"permissionCode\":\"IamPosition:write\",\"sortId\":\"108\"}]}]}", "{\"displayType\":\"CATALOGUE\",\"displayName\":\"\u7cfb\u7edf\u7ba1\u7406\",\"displayNameI18n\":\"Resource.System\",\"routePath\":\"system\",\"resourceCode\":\"System\",\"meta\":\"{\\\"icon\\\":\\\"Element:Tools\\\"}\",\"sortId\":\"95\",\"children\":[{\"displayType\":\"MENU\",\"displayName\":\"\u6570\u636e\u5b57\u5178\",\"displayNameI18n\":\"Resource.Dictionary\",\"routePath\":\"dictionary\",\"resourceCode\":\"Dictionary\",\"permissionCode\":\"Dictionary:read\",\"meta\":\"{\\\"icon\\\":\\\"Element:Collection\\\",\\\"componentPath\\\":\\\"@/views/system/dictionary/List.vue\\\"}\",\"sortId\":\"10\",\"children\":[{\"displayType\":\"PERMISSION\",\"displayName\":\"\u8be6\u60c5\",\"resourceCode\":\"detail\",\"displayNameI18n\":\"operation.detail\",\"permissionCode\":\"Dictionary:read\",\"sortId\":\"6\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u65b0\u5efa\",\"resourceCode\":\"create\",\"displayNameI18n\":\"operation.create\",\"permissionCode\":\"Dictionary:write\",\"sortId\":\"5\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u66f4\u65b0\",\"resourceCode\":\"update\",\"displayNameI18n\":\"operation.update\",\"permissionCode\":\"Dictionary:write,Dictionary:read\",\"sortId\":\"4\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u5220\u9664\",\"resourceCode\":\"delete\",\"displayNameI18n\":\"operation.delete\",\"permissionCode\":\"Dictionary:write\",\"sortId\":\"3\"}]},{\"displayType\":\"MENU\",\"displayName\":\"\u83dc\u5355\u8d44\u6e90\",\"displayNameI18n\":\"Resource.Resource\",\"routePath\":\"resource\",\"resourceCode\":\"Resource\",\"permissionCode\":\"IamResource:read\",\"meta\":\"{\\\"icon\\\":\\\"Element:Menu\\\",\\\"componentPath\\\":\\\"@/views/system/resource/index.vue\\\"}\",\"sortId\":\"20\",\"children\":[{\"displayType\":\"PERMISSION\",\"displayName\":\"\u8be6\u60c5\",\"resourceCode\":\"detail\",\"displayNameI18n\":\"operation.detail\",\"permissionCode\":\"IamResource:read\",\"sortId\":\"23\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u65b0\u5efa\",\"resourceCode\":\"create\",\"displayNameI18n\":\"operation.create\",\"permissionCode\":\"IamResource:write\",\"sortId\":\"21\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u66f4\u65b0\",\"resourceCode\":\"update\",\"displayNameI18n\":\"operation.update\",\"permissionCode\":\"IamResource:write,IamResource:read\",\"sortId\":\"20\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u5220\u9664\",\"resourceCode\":\"delete\",\"displayNameI18n\":\"operation.delete\",\"permissionCode\":\"IamResource:write\",\"sortId\":\"19\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u6392\u5e8f\",\"resourceCode\":\"sort\",\"displayNameI18n\":\"operation.sort\",\"permissionCode\":\"IamResource:write\",\"sortId\":\"18\"}]},{\"displayType\":\"MENU\",\"displayName\":\"\u89d2\u8272\u6743\u9650\",\"displayNameI18n\":\"Resource.Role\",\"routePath\":\"role\",\"resourceCode\":\"Role\",\"permissionCode\":\"IamRole:read\",\"meta\":\"{\\\"icon\\\":\\\"Element:Avatar\\\",\\\"componentPath\\\":\\\"@/views/system/role/List.vue\\\"}\",\"sortId\":\"30\",\"children\":[{\"displayType\":\"PERMISSION\",\"displayName\":\"\u8be6\u60c5\",\"resourceCode\":\"detail\",\"displayNameI18n\":\"operation.detail\",\"permissionCode\":\"IamRole:read\",\"sortId\":\"18\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u89d2\u8272\u7528\u6237\",\"resourceCode\":\"roleUser\",\"displayNameI18n\":\"Resource.Role.roleUser\",\"permissionCode\":\"IamRole:write\",\"sortId\":\"16\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u65b0\u5efa\",\"resourceCode\":\"create\",\"displayNameI18n\":\"operation.create\",\"permissionCode\":\"IamRole:write\",\"sortId\":\"15\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u66f4\u65b0\",\"resourceCode\":\"update\",\"displayNameI18n\":\"operation.update\",\"permissionCode\":\"IamRole:write,IamRole:read,IamResource:read\",\"sortId\":\"14\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u5220\u9664\",\"resourceCode\":\"delete\",\"displayNameI18n\":\"operation.delete\",\"permissionCode\":\"IamRole:write\",\"sortId\":\"13\"}]},{\"displayType\":\"MENU\",\"displayName\":\"\u63a5\u53e3\u670d\u52a1\",\"displayNameI18n\":\"Resource.Client\",\"routePath\":\"client\",\"resourceCode\":\"Client\",\"permissionCode\":\"Client:read\",\"meta\":\"{\\\"icon\\\":\\\"Element:TakeawayBox\\\",\\\"componentPath\\\":\\\"@/views/system/client/List.vue\\\"}\",\"sortId\":\"35\",\"children\":[{\"displayType\":\"PERMISSION\",\"displayName\":\"\u8be6\u60c5\",\"resourceCode\":\"detail\",\"displayNameI18n\":\"operation.detail\",\"permissionCode\":\"Client:read\",\"sortId\":\"10\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u65b0\u5efa\",\"resourceCode\":\"create\",\"displayNameI18n\":\"operation.create\",\"permissionCode\":\"Client:write\",\"sortId\":\"11\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u66f4\u65b0\",\"resourceCode\":\"update\",\"displayNameI18n\":\"operation.update\",\"permissionCode\":\"Client:write,Client:read\",\"sortId\":\"12\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u5220\u9664\",\"resourceCode\":\"delete\",\"displayNameI18n\":\"operation.delete\",\"permissionCode\":\"Client:write\",\"sortId\":\"13\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u8bbf\u95ee\u65e5\u5fd7\",\"resourceCode\":\"viewLogs\",\"displayNameI18n\":\"client.viewLogs\",\"permissionCode\":\"IamOperationLog:read\",\"sortId\":\"15\"}]},{\"displayType\":\"MENU\",\"displayName\":\"\u5b9a\u65f6\u4efb\u52a1\",\"displayNameI18n\":\"Resource.ScheduledJob\",\"routePath\":\"schedule-job\",\"resourceCode\":\"ScheduleJob\",\"permissionCode\":\"ScheduleJob:read\",\"meta\":\"{\\\"icon\\\":\\\"Element:AlarmClock\\\",\\\"componentPath\\\":\\\"@/views/system/schedule-job/List.vue\\\"}\",\"sortId\":\"40\",\"children\":[{\"displayType\":\"PERMISSION\",\"displayName\":\"\u5220\u9664\",\"resourceCode\":\"delete\",\"displayNameI18n\":\"operation.delete\",\"permissionCode\":\"ScheduleJob:write\",\"sortId\":\"7\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u66f4\u65b0\",\"resourceCode\":\"update\",\"displayNameI18n\":\"operation.update\",\"permissionCode\":\"ScheduleJob:write,ScheduleJob:read\",\"sortId\":\"6\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u65b0\u5efa\",\"resourceCode\":\"create\",\"displayNameI18n\":\"operation.create\",\"permissionCode\":\"ScheduleJob:write\",\"sortId\":\"5\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u8be6\u60c5\",\"resourceCode\":\"detail\",\"displayNameI18n\":\"operation.detail\",\"permissionCode\":\"ScheduleJob:read\",\"sortId\":\"4\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u8fd0\u884c\u4e00\u6b21\",\"resourceCode\":\"executeOnce\",\"displayNameI18n\":\"Resource.ScheduledJob.ExecuteOnce\",\"permissionCode\":\"ScheduleJob:write\",\"sortId\":\"3\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u65e5\u5fd7\u8bb0\u5f55\",\"resourceCode\":\"logList\",\"displayNameI18n\":\"Resource.ScheduledJob.LogList\",\"permissionCode\":\"ScheduleJob:read\",\"sortId\":\"2\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u65e5\u5fd7\u5220\u9664\",\"resourceCode\":\"logDelete\",\"displayNameI18n\":\"Resource.ScheduledJob.LogDelete\",\"permissionCode\":\"ScheduleJob:write\",\"sortId\":\"1\"}]},{\"displayType\":\"MENU\",\"displayName\":\"\u6d88\u606f\u6a21\u677f\",\"displayNameI18n\":\"Resource.MessageTemplate\",\"routePath\":\"message-template\",\"resourceCode\":\"MessageTemplate\",\"permissionCode\":\"MessageTemplate:read\",\"meta\":\"{\\\"icon\\\":\\\"Element:ChatLineSquare\\\",\\\"componentPath\\\":\\\"@/views/system/message-template/List.vue\\\"}\",\"sortId\":\"50\",\"children\":[{\"displayType\":\"PERMISSION\",\"displayName\":\"\u8be6\u60c5\",\"resourceCode\":\"detail\",\"displayNameI18n\":\"operation.detail\",\"permissionCode\":\"MessageTemplate:read\",\"sortId\":\"16\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u65b0\u5efa\",\"resourceCode\":\"create\",\"displayNameI18n\":\"operation.create\",\"permissionCode\":\"MessageTemplate:write\",\"sortId\":\"15\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u66f4\u65b0\",\"resourceCode\":\"update\",\"displayNameI18n\":\"operation.update\",\"permissionCode\":\"MessageTemplate:write,MessageTemplate:read\",\"sortId\":\"14\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u5220\u9664\",\"resourceCode\":\"delete\",\"displayNameI18n\":\"operation.delete\",\"permissionCode\":\"MessageTemplate:write\",\"sortId\":\"13\"}]},{\"displayType\":\"MENU\",\"displayName\":\"\u6d88\u606f\u8bb0\u5f55\",\"displayNameI18n\":\"Resource.Message\",\"routePath\":\"message\",\"resourceCode\":\"Message\",\"permissionCode\":\"Message:read\",\"meta\":\"{\\\"icon\\\":\\\"Element:ChatDotRound\\\",\\\"componentPath\\\":\\\"@/views/system/message/List.vue\\\"}\",\"sortId\":\"60\",\"children\":[{\"displayType\":\"PERMISSION\",\"displayName\":\"\u8be6\u60c5\",\"resourceCode\":\"detail\",\"displayNameI18n\":\"operation.detail\",\"permissionCode\":\"Message:read\",\"sortId\":\"16\"}]},{\"displayType\":\"MENU\",\"displayName\":\"\u6587\u4ef6\u8bb0\u5f55\",\"displayNameI18n\":\"Resource.FileRecord\",\"routePath\":\"file-record\",\"resourceCode\":\"FileRecord\",\"permissionCode\":\"FileRecord:read\",\"meta\":\"{\\\"icon\\\":\\\"Element:FolderOpened\\\",\\\"componentPath\\\":\\\"@/views/system/file-record/List.vue\\\"}\",\"sortId\":\"70\",\"children\":[{\"displayType\":\"PERMISSION\",\"displayName\":\"\u8be6\u60c5\",\"resourceCode\":\"detail\",\"displayNameI18n\":\"operation.detail\",\"permissionCode\":\"FileRecord:read\",\"sortId\":\"16\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u66f4\u65b0\",\"resourceCode\":\"update\",\"displayNameI18n\":\"operation.update\",\"permissionCode\":\"FileRecord:write,FileRecord:read\",\"sortId\":\"14\"}]},{\"displayType\":\"MENU\",\"displayName\":\"\u56fd\u9645\u5316\u7ba1\u7406\",\"displayNameI18n\":\"Resource.I18n\",\"routePath\":\"i18n-config\",\"resourceCode\":\"I18nConfig\",\"permissionCode\":\"\",\"meta\":\"{\\\"icon\\\":\\\"Local:Language\\\",\\\"componentPath\\\":\\\"@/views/system/i18n-config/index.vue\\\"}\",\"sortId\":\"85\",\"children\":[{\"displayType\":\"PERMISSION\",\"displayName\":\"\u65b0\u5efa\",\"resourceCode\":\"create\",\"displayNameI18n\":\"operation.create\",\"permissionCode\":\"I18nConfig:write\",\"sortId\":\"1\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u66f4\u65b0\",\"resourceCode\":\"update\",\"displayNameI18n\":\"operation.update\",\"permissionCode\":\"I18nConfig:write\",\"sortId\":\"2\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u5220\u9664\",\"resourceCode\":\"delete\",\"displayNameI18n\":\"operation.delete\",\"permissionCode\":\"I18nConfig:write\",\"sortId\":\"3\"}]},{\"displayType\":\"MENU\",\"displayName\":\"\u7cfb\u7edf\u914d\u7f6e\",\"displayNameI18n\":\"Resource.Configuration\",\"routePath\":\"config\",\"resourceCode\":\"SystemConfig\",\"permissionCode\":\"SystemConfig:read\",\"meta\":\"{\\\"icon\\\":\\\"Element:Setting\\\",\\\"componentPath\\\":\\\"@/views/system/config/index.vue\\\"}\",\"sortId\":\"80\",\"children\":[{\"displayType\":\"PERMISSION\",\"displayName\":\"\u65b0\u5efa\",\"resourceCode\":\"create\",\"displayNameI18n\":\"operation.create\",\"permissionCode\":\"SystemConfig:write\",\"sortId\":\"1\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u66f4\u65b0\",\"resourceCode\":\"update\",\"displayNameI18n\":\"operation.update\",\"permissionCode\":\"SystemConfig:write\",\"sortId\":\"2\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u5220\u9664\",\"resourceCode\":\"delete\",\"displayNameI18n\":\"operation.delete\",\"permissionCode\":\"SystemConfig:write\",\"sortId\":\"3\"}]},{\"displayType\":\"MENU\",\"displayName\":\"\u64cd\u4f5c\u65e5\u5fd7\",\"displayNameI18n\":\"Resource.OperationLog\",\"routePath\":\"operation-log\",\"resourceCode\":\"OperationLog\",\"permissionCode\":\"IamOperationLog:read\",\"meta\":\"{\\\"icon\\\":\\\"Element:Pointer\\\",\\\"componentPath\\\":\\\"@/views/system/operation-log/List.vue\\\"}\",\"sortId\":\"90\",\"children\":[{\"displayType\":\"PERMISSION\",\"displayName\":\"\u8be6\u60c5\",\"resourceCode\":\"detail\",\"displayNameI18n\":\"operation.detail\",\"permissionCode\":\"IamOperationLog:read\",\"sortId\":\"1\"}]},{\"displayType\":\"MENU\",\"displayName\":\"\u767b\u5f55\u65e5\u5fd7\",\"displayNameI18n\":\"Resource.LoginLog\",\"routePath\":\"login-trace\",\"resourceCode\":\"LoginTrace\",\"permissionCode\":\"IamLoginTrace:read\",\"meta\":\"{\\\"icon\\\":\\\"Element:Finished\\\",\\\"componentPath\\\":\\\"@/views/system/login-trace/List.vue\\\"}\",\"sortId\":\"100\",\"children\":[]}]}"};
            try {
                for (String resourcePermissionJson : RESOURCE_PERMISSION_DATA) {
                    IamResourceListVO permissionListVO = (IamResourceListVO)((Object)JSON.toJavaObject((String)resourcePermissionJson, IamResourceListVO.class));
                    resourcePermissionService.deepCreateResourceAndChildren(permissionListVO);
                }
            }
            catch (BusinessException e) {
                log.error("\u521d\u59cb\u5316\u8d44\u6e90\u6743\u9650\u6570\u636e\u51fa\u9519: {}\uff0c\u8bf7\u624b\u52a8\u914d\u7f6e\u524d\u7aef\u8d44\u6e90\u521d\u59cb\u7684\u6743\u9650\u6570\u636e", (Object)e.getMessage());
            }
        }
        if (!(i18nConfigMapper = (I18nConfigMapper)ContextHolder.getBean(I18nConfigMapper.class)).exists((Wrapper)Wrappers.lambdaQuery().select(new SFunction[]{I18nConfig::getType}).eq(I18nConfig::getType, (Object)"SYSTEM"))) {
            String i18nData = "[{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.I18N_TYPE.System\",\"content\":\"\u7cfb\u7edf\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.I18N_TYPE.System\",\"content\":\"System\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.I18N_TYPE.Custom\",\"content\":\"\u81ea\u5b9a\u4e49\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.I18N_TYPE.Custom\",\"content\":\"Custom\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.AUTH_TYPE.PWD\",\"content\":\"\u7528\u6237\u540d\u5bc6\u7801\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.AUTH_TYPE.PWD\",\"content\":\"Password\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.AUTH_TYPE.SSO\",\"content\":\"\u5355\u70b9\u767b\u5f55\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.AUTH_TYPE.SSO\",\"content\":\"Single Sign-On\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.AUTH_TYPE.WX_MP\",\"content\":\"\u516c\u4f17\u53f7\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.AUTH_TYPE.WX_MP\",\"content\":\"WeChat\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.AUTH_TYPE.WX_CP\",\"content\":\"\u4f01\u4e1a\u5fae\u4fe1\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.AUTH_TYPE.WX_CP\",\"content\":\"Enterprise WeChat\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.AUTH_TYPE.Other\",\"content\":\"\u5176\u4ed6\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.AUTH_TYPE.Other\",\"content\":\"Other\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.ACCOUNT_STATUS.A\",\"content\":\"\u6709\u6548\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.ACCOUNT_STATUS.A\",\"content\":\"Active\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.ACCOUNT_STATUS.I\",\"content\":\"\u65e0\u6548\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.ACCOUNT_STATUS.I\",\"content\":\"Invalid\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.ACCOUNT_STATUS.L\",\"content\":\"\u9501\u5b9a\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.ACCOUNT_STATUS.L\",\"content\":\"Locked\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.USER_STATUS.A\",\"content\":\"\u5728\u804c\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.USER_STATUS.A\",\"content\":\"Active\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.MEMBER_STATUS.A\",\"content\":\"\u6709\u6548\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.MEMBER_STATUS.A\",\"content\":\"Active\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.TENANT_STATUS.A\",\"content\":\"\u6709\u6548\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.TENANT_STATUS.A\",\"content\":\"Active\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.MEMBER_STATUS.I\",\"content\":\"\u65e0\u6548\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.USER_STATUS.I\",\"content\":\"\u79bb\u804c\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.TENANT_STATUS.I\",\"content\":\"\u65e0\u6548\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.MEMBER_STATUS.I\",\"content\":\"Invalid\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.USER_STATUS.I\",\"content\":\"Invalid\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.TENANT_STATUS.I\",\"content\":\"Invalid\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.GENDER.F\",\"content\":\"\u5973\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.GENDER.F\",\"content\":\"Female\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.GENDER.M\",\"content\":\"\u7537\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.GENDER.M\",\"content\":\"Male\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.RESOURCE_TYPE.MENU\",\"content\":\"\u83dc\u5355\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.RESOURCE_TYPE.MENU\",\"content\":\"Menu\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.RESOURCE_TYPE.OPERATION\",\"content\":\"\u6309\u94ae/\u64cd\u4f5c\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.RESOURCE_TYPE.OPERATION\",\"content\":\"Operation\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.RESOURCE_CODE.detail\",\"content\":\"\u8be6\u60c5\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.RESOURCE_CODE.detail\",\"content\":\"Detail\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.RESOURCE_CODE.import\",\"content\":\"\u5bfc\u5165\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.RESOURCE_CODE.import\",\"content\":\"Import\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.RESOURCE_CODE.create\",\"content\":\"\u65b0\u5efa\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.RESOURCE_CODE.create\",\"content\":\"Create\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.RESOURCE_CODE.update\",\"content\":\"\u65b0\u5efa\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.RESOURCE_CODE.update\",\"content\":\"Update\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.RESOURCE_CODE.delete\",\"content\":\"\u5220\u9664\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.RESOURCE_CODE.delete\",\"content\":\"Delete\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.RESOURCE_CODE.export\",\"content\":\"\u5bfc\u51fa\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.RESOURCE_CODE.export\",\"content\":\"Export\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.ORG_TYPE.DEPT\",\"content\":\"\u90e8\u95e8\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.ORG_TYPE.DEPT\",\"content\":\"Department\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.ORG_TYPE.COMP\",\"content\":\"\u516c\u53f8\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.ORG_TYPE.COMP\",\"content\":\"Company\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.DATA_PERMISSION_TYPE.SELF\",\"content\":\"\u672c\u4eba\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.DATA_PERMISSION_TYPE.SELF\",\"content\":\"Self\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.DATA_PERMISSION_TYPE.SELF_AND_SUB\",\"content\":\"\u672c\u4eba\u53ca\u4e0b\u5c5e\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.DATA_PERMISSION_TYPE.SELF_AND_SUB\",\"content\":\"Self And Sub\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.DATA_PERMISSION_TYPE.DEPT\",\"content\":\"\u672c\u90e8\u95e8\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.DATA_PERMISSION_TYPE.DEPT\",\"content\":\"Current Department\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.DATA_PERMISSION_TYPE.DEPT_AND_SUB\",\"content\":\"\u672c\u90e8\u95e8\u53ca\u4e0b\u5c5e\u90e8\u95e8\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.DATA_PERMISSION_TYPE.DEPT_AND_SUB\",\"content\":\"Current Department and Sub-departments\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.DATA_PERMISSION_TYPE.ALL\",\"content\":\"\u5168\u90e8\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.DATA_PERMISSION_TYPE.ALL\",\"content\":\"All\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.POSITION_GRADE.E1\",\"content\":\"\u521d\u7ea7\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.POSITION_GRADE.E1\",\"content\":\"E1\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.POSITION_GRADE.E2\",\"content\":\"\u4e2d\u7ea7\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.POSITION_GRADE.E2\",\"content\":\"E2\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.POSITION_GRADE.E3\",\"content\":\"\u9ad8\u7ea7\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.POSITION_GRADE.E3\",\"content\":\"E3\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.POSITION_GRADE.E4\",\"content\":\"\u4e13\u5bb6\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.POSITION_GRADE.E4\",\"content\":\"E4\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.MESSAGE_STATUS.PENDING\",\"content\":\"\u53d1\u9001\u4e2d\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.MESSAGE_STATUS.PENDING\",\"content\":\"Pening\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.MESSAGE_STATUS.FAILED\",\"content\":\"\u53d1\u9001\u5931\u8d25\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.MESSAGE_STATUS.FAILED\",\"content\":\"Failed\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.MESSAGE_STATUS.DELIVERY\",\"content\":\"\u5df2\u9001\u8fbe\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.MESSAGE_STATUS.DELIVERY\",\"content\":\"Delivery\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.MESSAGE_STATUS.READ\",\"content\":\"\u5df2\u8bfb\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.MESSAGE_STATUS.READ\",\"content\":\"Read\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.MESSAGE_CHANNEL.SMS\",\"content\":\"\u77ed\u4fe1\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.MESSAGE_CHANNEL.SMS\",\"content\":\"SMS\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.MESSAGE_CHANNEL.SYS_MSG\",\"content\":\"\u7cfb\u7edf\u6d88\u606f\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.MESSAGE_CHANNEL.SYS_MSG\",\"content\":\"System Message\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.MESSAGE_CHANNEL.WEBSOCKET\",\"content\":\"\u7ad9\u5185\u4fe1\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.MESSAGE_CHANNEL.WEBSOCKET\",\"content\":\"Websocket\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.MESSAGE_CHANNEL.EMAIL\",\"content\":\"\u90ae\u4ef6\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.MESSAGE_CHANNEL.EMAIL\",\"content\":\"Email\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.INIT_STRATEGY.DO_NOTHING\",\"content\":\"\u5468\u671f\u6267\u884c\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.INIT_STRATEGY.DO_NOTHING\",\"content\":\"Cycle Execution\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.INIT_STRATEGY.FIRE_AND_PROCEED\",\"content\":\"\u7acb\u5373\u6267\u884c\u4e00\u6b21\uff0c\u5e76\u5468\u671f\u6267\u884c\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.INIT_STRATEGY.FIRE_AND_PROCEED\",\"content\":\"Execute Once Immediately and Cycle\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Dictionary.INIT_STRATEGY.IGNORE_MISFIRES\",\"content\":\"\u8d85\u671f\u7acb\u5373\u6267\u884c\uff0c\u5e76\u5468\u671f\u6267\u884c\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Dictionary.INIT_STRATEGY.IGNORE_MISFIRES\",\"content\":\"Execute Immediately on Overdue and Cycle\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Resource.OrgStructure\",\"content\":\"\u7ec4\u7ec7\u4eba\u5458\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Resource.OrgStructure\",\"content\":\"Org Structure\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Resource.User\",\"content\":\"\u4eba\u5458\u7ba1\u7406\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Resource.User\",\"content\":\"User\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Resource.Org\",\"content\":\"\u7ec4\u7ec7\u90e8\u95e8\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Resource.Org\",\"content\":\"Department\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Resource.Position\",\"content\":\"\u5c97\u4f4d\u7ba1\u7406\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Resource.Position\",\"content\":\"Position\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Resource.System\",\"content\":\"\u7cfb\u7edf\u7ba1\u7406\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Resource.System\",\"content\":\"System\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Resource.Dictionary\",\"content\":\"\u6570\u636e\u5b57\u5178\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Resource.Dictionary\",\"content\":\"Dictionary\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Resource.Resource\",\"content\":\"\u83dc\u5355\u8d44\u6e90\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Resource.Resource\",\"content\":\"Menu Resource\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Resource.Role\",\"content\":\"\u89d2\u8272\u6743\u9650\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Resource.Role\",\"content\":\"Role\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Resource.Role.roleUser\",\"content\":\"\u89d2\u8272\u7528\u6237\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Resource.Role.roleUser\",\"content\":\"Role Users\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Resource.Client\",\"content\":\"\u63a5\u53e3\u670d\u52a1\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Resource.Client\",\"content\":\"Open API\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Resource.ScheduledJob\",\"content\":\"\u5b9a\u65f6\u4efb\u52a1\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Resource.ScheduledJob\",\"content\":\"Scheduled Job\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Resource.MessageTemplate\",\"content\":\"\u6d88\u606f\u6a21\u677f\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Resource.MessageTemplate\",\"content\":\"Message Template\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Resource.Message\",\"content\":\"\u6d88\u606f\u8bb0\u5f55\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Resource.Message\",\"content\":\"Message\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Resource.FileRecord\",\"content\":\"\u6587\u4ef6\u8bb0\u5f55\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Resource.FileRecord\",\"content\":\"File Record\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Resource.I18n\",\"content\":\"\u56fd\u9645\u5316\u7ba1\u7406\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Resource.I18n\",\"content\":\"International\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Resource.Configuration\",\"content\":\"\u7cfb\u7edf\u914d\u7f6e\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Resource.Configuration\",\"content\":\"System Config\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Resource.OperationLog\",\"content\":\"\u64cd\u4f5c\u65e5\u5fd7\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Resource.OperationLog\",\"content\":\"Operation Log\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Resource.LoginLog\",\"content\":\"\u767b\u5f55\u65e5\u5fd7\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Resource.LoginLog\",\"content\":\"Login Log\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Resource.ChatAI\",\"content\":\"Chat AI\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Resource.ChatAI\",\"content\":\"Chat AI\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Resource.Tenant\",\"content\":\"\u79df\u6237\u7ba1\u7406\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Resource.Tenant\",\"content\":\"Tenant\"},{\"type\":\"SYSTEM\",\"language\":\"zh_CN\",\"code\":\"Resource.TenantInformation\",\"content\":\"\u79df\u6237\u4fe1\u606f\u7ba1\u7406\"},{\"type\":\"SYSTEM\",\"language\":\"en\",\"code\":\"Resource.TenantInformation\",\"content\":\"Tenant Info\"},{\"type\":\"CUSTOM\",\"language\":\"zh_CN\",\"code\":\"operation.create\",\"content\":\"\u65b0\u5efa\"},{\"type\":\"CUSTOM\",\"language\":\"en\",\"code\":\"operation.create\",\"content\":\"Create\"},{\"type\":\"CUSTOM\",\"language\":\"zh_CN\",\"code\":\"operation.update\",\"content\":\"\u66f4\u65b0\"},{\"type\":\"CUSTOM\",\"language\":\"en\",\"code\":\"operation.update\",\"content\":\"Update\"},{\"type\":\"CUSTOM\",\"language\":\"zh_CN\",\"code\":\"operation.detail\",\"content\":\"\u8be6\u60c5\"},{\"type\":\"CUSTOM\",\"language\":\"en\",\"code\":\"operation.detail\",\"content\":\"Detail\"},{\"type\":\"CUSTOM\",\"language\":\"zh_CN\",\"code\":\"operation.delete\",\"content\":\"\u5220\u9664\"},{\"type\":\"CUSTOM\",\"language\":\"en\",\"code\":\"operation.delete\",\"content\":\"Delete\"},{\"type\":\"CUSTOM\",\"language\":\"zh_CN\",\"code\":\"operation.batchDelete\",\"content\":\"\u6279\u91cf\u5220\u9664\"},{\"type\":\"CUSTOM\",\"language\":\"en\",\"code\":\"operation.batchDelete\",\"content\":\"Batch Delete\"},{\"type\":\"CUSTOM\",\"language\":\"zh_CN\",\"code\":\"operation.import\",\"content\":\"\u5bfc\u5165\"},{\"type\":\"CUSTOM\",\"language\":\"en\",\"code\":\"operation.import\",\"content\":\"Import\"},{\"type\":\"CUSTOM\",\"language\":\"zh_CN\",\"code\":\"operation.export\",\"content\":\"\u5bfc\u51fa\"},{\"type\":\"CUSTOM\",\"language\":\"en\",\"code\":\"operation.export\",\"content\":\"Export\"},{\"type\":\"CUSTOM\",\"language\":\"zh_CN\",\"code\":\"operation.batchPrint\",\"content\":\"\u6279\u91cf\u6253\u5370\"},{\"type\":\"CUSTOM\",\"language\":\"en\",\"code\":\"operation.batchPrint\",\"content\":\"Batch Print\"},{\"type\":\"CUSTOM\",\"language\":\"zh_CN\",\"code\":\"operation.flowchart\",\"content\":\"\u6d41\u7a0b\u56fe\"},{\"type\":\"CUSTOM\",\"language\":\"en\",\"code\":\"operation.flowchart\",\"content\":\"Flow Chart\"},{\"type\":\"CUSTOM\",\"language\":\"zh_CN\",\"code\":\"Resource.User.AddPosition\",\"content\":\"\u6dfb\u52a0\u5c97\u4f4d\"},{\"type\":\"CUSTOM\",\"language\":\"en\",\"code\":\"Resource.User.AddPosition\",\"content\":\"Add Position\"},{\"type\":\"CUSTOM\",\"language\":\"zh_CN\",\"code\":\"Resource.User.PositionSetting\",\"content\":\"\u4eba\u5458\u5c97\u4f4d\u8bbe\u7f6e\"},{\"type\":\"CUSTOM\",\"language\":\"en\",\"code\":\"Resource.User.PositionSetting\",\"content\":\"Position Setting\"},{\"type\":\"CUSTOM\",\"language\":\"zh_CN\",\"code\":\"operation.sort\",\"content\":\"\u6392\u5e8f\"},{\"type\":\"CUSTOM\",\"language\":\"en\",\"code\":\"operation.sort\",\"content\":\"Sort\"},{\"type\":\"CUSTOM\",\"language\":\"zh_CN\",\"code\":\"Resource.ScheduledJob.ExecuteOnce\",\"content\":\"\u8fd0\u884c\u4e00\u6b21\"},{\"type\":\"CUSTOM\",\"language\":\"en\",\"code\":\"Resource.ScheduledJob.ExecuteOnce\",\"content\":\"Execute Once\"},{\"type\":\"CUSTOM\",\"language\":\"zh_CN\",\"code\":\"Resource.ScheduledJob.LogList\",\"content\":\"\u65e5\u5fd7\u8bb0\u5f55\"},{\"type\":\"CUSTOM\",\"language\":\"en\",\"code\":\"Resource.ScheduledJob.LogList\",\"content\":\"Log Records\"},{\"type\":\"CUSTOM\",\"language\":\"zh_CN\",\"code\":\"Resource.ScheduledJob.LogDelete\",\"content\":\"\u65e5\u5fd7\u5220\u9664\"},{\"type\":\"CUSTOM\",\"language\":\"en\",\"code\":\"Resource.ScheduledJob.LogDelete\",\"content\":\"Delete Log\"}]";
            try {
                List i18nConfigs = JSON.parseArray((String)i18nData, I18nConfig.class);
                i18nConfigMapper.insert((Collection)i18nConfigs);
            }
            catch (BusinessException e) {
                log.error("\u521d\u59cb\u5316\u56fd\u9645\u5316\u914d\u7f6e\u6570\u636e\u51fa\u9519: {}\uff0c\u8bf7\u624b\u52a8\u914d\u7f6e\u56fd\u9645\u5316\u914d\u7f6e\u6570\u636e", (Object)e.getMessage());
            }
        }
        IamOrgService iamOrgService = (IamOrgService)ContextHolder.getBean(IamOrgService.class);
        IamOrg iamOrg = new IamOrg();
        if (iamOrgService != null && iamOrgService.getEntityListCount(null) == 0L) {
            iamOrg.setParentId((Serializable)((Object)"0"));
            iamOrg.setCode("ROOT").setRootOrgId("1").setName("\u6211\u7684\u516c\u53f8").setType(Cons.DICTCODE_ORG_TYPE.COMP.name()).setOrgComment("\u521d\u59cb\u6839\u8282\u70b9\uff0c\u8bf7\u6309\u9700\u4fee\u6539").setId((Serializable)((Object)"1"));
            iamOrgService.createEntity((Object)iamOrg);
        }
        if ((iamRoleService = (IamRoleService)ContextHolder.getBean(IamRoleService.class)) != null && iamRoleService.getEntityListCount(null) == 0L) {
            IamRole iamRole = new IamRole();
            iamRole.setName("\u8d85\u7ea7\u7ba1\u7406\u5458").setCode("SUPER_ADMIN");
            iamRoleService.createEntity((Object)iamRole);
            IamUser iamUser = new IamUser();
            iamUser.setOrgId((String)((Object)iamOrg.getId())).setRealname("DIBOOT").setUserNum("0000").setGender("M").setMobilePhone("10000000000");
            ((IamUserService)ContextHolder.getBean(IamUserService.class)).createEntity((Object)iamUser);
            IamUserRole iamUserRole = new IamUserRole(IamUser.class.getSimpleName(), (String)((Object)iamUser.getId()), (String)((Object)iamRole.getId()));
            ((IamUserRoleService)ContextHolder.getBean(IamUserRoleService.class)).getMapper().insert((Object)iamUserRole);
            IamAccount iamAccount = new IamAccount();
            iamAccount.setUserType(IamUser.class.getSimpleName()).setUserId((String)((Object)iamUser.getId())).setAuthType(Cons.DICTCODE_AUTH_TYPE.PWD.name()).setAuthAccount("admin").setAuthSecret("123456");
            ((IamAccountService)ContextHolder.getBean(IamAccountService.class)).createEntity(iamAccount);
        }
    }
}

