/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.dto;

import com.diboot.core.exception.BusinessException;
import com.diboot.core.util.JSON;
import com.diboot.core.util.V;
import com.diboot.core.vo.Status;
import com.diboot.iam.dto.AuthCredential;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptCredential
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptCredential.class);
    private static final long serialVersionUID = 8178800708883555475L;
    @NotNull(message="{validation.encryptCredential.ciphertext.NotNull.message}")
    private @NotNull(message="{validation.encryptCredential.ciphertext.NotNull.message}") String ciphertext;

    public <T extends AuthCredential> T getAuthCredential(Function<String, String> decrypt, Class<T> authCredentialCls) {
        try {
            String decryptContent = decrypt.apply(this.ciphertext);
            AuthCredential result = (AuthCredential)JSON.parseObject((String)decryptContent, authCredentialCls);
            String errMsg = V.validateBeanErrMsg((Object)result, (Class[])new Class[0]);
            if (V.notEmpty((String)errMsg)) {
                throw new BusinessException(Status.FAIL_INVALID_PARAM, errMsg, new Object[0]);
            }
            return (T)result;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25\uff01", (Throwable)e);
            throw new BusinessException(e.getMessage(), new Object[0]);
        }
    }

    @Generated
    public String getCiphertext() {
        return this.ciphertext;
    }

    @Generated
    public EncryptCredential setCiphertext(String ciphertext) {
        this.ciphertext = ciphertext;
        return this;
    }
}

