/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.data;

import com.diboot.core.config.Cons;
import com.diboot.core.data.access.DataScopeManager;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.V;
import com.diboot.core.vo.LabelValue;
import com.diboot.iam.config.Cons;
import com.diboot.iam.entity.IamUser;
import com.diboot.iam.service.IamOrgService;
import com.diboot.iam.util.IamSecurityUtils;
import com.diboot.iam.vo.PositionDataScope;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UserOrgDataAccessScopeManager
implements DataScopeManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserOrgDataAccessScopeManager.class);
    private static final List<String> USER_FIELD_NAMES = Arrays.asList(Cons.FieldName.userId.name(), Cons.FieldName.createBy.name(), "user");
    private static final List<String> ORG_FIELD_NAMES = Arrays.asList(Cons.FieldName.orgId.name(), "org", "department");

    public String getTitle() {
        return "\u57fa\u4e8e\u7528\u6237\u7ec4\u7ec7\u7684\u6570\u636e\u6743\u9650\u63a7\u5236";
    }

    public abstract List<Class<?>> getEntityClasses();

    public List<? extends Serializable> getAccessibleIds(String fieldName) {
        IamUser currentUser;
        try {
            currentUser = (IamUser)((Object)IamSecurityUtils.getCurrentUser());
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u6570\u636e\u6743\u9650\u53ef\u8bbf\u95eeids\u5f02\u5e38: ", (Throwable)e);
            return Collections.emptyList();
        }
        if (currentUser == null) {
            log.warn("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237");
            return Collections.emptyList();
        }
        LabelValue extensionObj = currentUser.getExtensionObj();
        if (extensionObj == null || extensionObj.getExt() == null) {
            if (this.isOrgFieldName(fieldName)) {
                return this.buildOrgIdsScope(currentUser);
            }
            if (this.isUserFieldName(fieldName)) {
                return this.buildUserIdsScope(currentUser);
            }
            throw new InvalidUsageException("\u9ed8\u8ba4\u6570\u636e\u6743\u9650: UserOrgDataAccessScopeManager \u672a\u80fd\u8bc6\u522b\u8be5\u5b57\u6bb5\u7c7b\u578b: {}\uff0c\u68c0\u67e5\u662f\u5426\u9700\u8981\u91cd\u5199isUserFieldName()/isOrgFieldName()", new Object[]{fieldName});
        }
        PositionDataScope positionDataScope = (PositionDataScope)extensionObj.getExt();
        if (Cons.DICTCODE_DATA_PERMISSION_TYPE.ALL.name().equalsIgnoreCase(positionDataScope.getDataPermissionType())) {
            return null;
        }
        if (Cons.DICTCODE_DATA_PERMISSION_TYPE.SELF.name().equalsIgnoreCase(positionDataScope.getDataPermissionType())) {
            if (this.isUserFieldName(fieldName)) {
                return this.buildUserIdsScope(currentUser);
            }
            return null;
        }
        if (Cons.DICTCODE_DATA_PERMISSION_TYPE.SELF_AND_SUB.name().equalsIgnoreCase(positionDataScope.getDataPermissionType())) {
            if (this.isUserFieldName(fieldName)) {
                return positionDataScope.getAccessibleUserIds();
            }
            return null;
        }
        if (Cons.DICTCODE_DATA_PERMISSION_TYPE.DEPT.name().equalsIgnoreCase(positionDataScope.getDataPermissionType())) {
            if (this.isOrgFieldName(fieldName)) {
                return Collections.singletonList(positionDataScope.getOrgId());
            }
            return null;
        }
        if (Cons.DICTCODE_DATA_PERMISSION_TYPE.DEPT_AND_SUB.name().equalsIgnoreCase(positionDataScope.getDataPermissionType())) {
            if (this.isOrgFieldName(fieldName)) {
                return positionDataScope.getAccessibleOrgIds();
            }
            return null;
        }
        log.warn("\u672a\u77e5\u7684\u6570\u636e\u6743\u9650\u7c7b\u578b: {}", (Object)positionDataScope.getDataPermissionType());
        return Collections.emptyList();
    }

    protected List<? extends Serializable> buildUserIdsScope(IamUser currentUser) {
        ArrayList<Serializable> accessibleIds = new ArrayList<Serializable>(1);
        accessibleIds.add(currentUser.getId());
        return accessibleIds;
    }

    protected List<? extends Serializable> buildOrgIdsScope(IamUser currentUser) {
        ArrayList<String> accessibleIds = new ArrayList<String>();
        accessibleIds.add(currentUser.getOrgId());
        List<String> childOrgIds = ((IamOrgService)ContextHolder.getBean(IamOrgService.class)).getChildOrgIds(currentUser.getOrgId());
        if (V.notEmpty(childOrgIds)) {
            accessibleIds.addAll(childOrgIds);
        }
        return accessibleIds;
    }

    protected boolean isUserFieldName(String fieldName) {
        return USER_FIELD_NAMES.contains(fieldName);
    }

    protected boolean isOrgFieldName(String fieldName) {
        return ORG_FIELD_NAMES.contains(fieldName);
    }
}

