/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.cache;

import com.diboot.core.cache.BaseCacheManager;
import com.diboot.core.config.Cons;
import com.diboot.core.util.V;
import com.diboot.iam.entity.SystemConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemConfigCacheManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemConfigCacheManager.class);
    private BaseCacheManager cacheManager;

    public SystemConfigCacheManager(BaseCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void removeCachedItems(String category) {
        if (this.cacheManager == null) {
            return;
        }
        this.cacheManager.removeCacheObj(Cons.CACHE_NAME_SYSTEM_CONFIG, (Object)this.handle(category));
    }

    public Map<String, SystemConfig> getCachedConfig(String category) {
        if (this.cacheManager == null) {
            return null;
        }
        return (Map)this.cacheManager.getCacheObj(Cons.CACHE_NAME_SYSTEM_CONFIG, (Object)this.handle(category), Map.class);
    }

    public void cacheConfig(String category, Collection<SystemConfig> configList) {
        if (this.cacheManager == null) {
            return;
        }
        HashMap<String, SystemConfig> cachedConfig = new HashMap<String, SystemConfig>(configList.size());
        for (SystemConfig config : configList) {
            cachedConfig.put(config.getPropKey(), config);
        }
        this.cacheManager.putCacheObj(Cons.CACHE_NAME_SYSTEM_CONFIG, (Object)this.handle(category), cachedConfig);
        log.debug("\u7cfb\u7edf\u914d\u7f6e\u7ec4 {} \u7684 {} \u6761\u6570\u636e\u5df2\u7f13\u5b58", (Object)category, (Object)configList.size());
    }

    private String handle(String category) {
        return V.isEmpty((String)category) ? "__null__" : category;
    }
}

