/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.cache;

import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.util.AnnotationUtils;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.ApiUri;
import com.diboot.iam.annotation.BindPermission;
import com.diboot.iam.annotation.process.ApiPermission;
import com.diboot.iam.annotation.process.ApiPermissionExtractor;
import com.diboot.iam.annotation.process.ApiPermissionWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IamPermissionCacheManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamPermissionCacheManager.class);
    private static Map<String, ApiPermissionWrapper> CLASS_PERMISSIONCODE_CACHE = new ConcurrentHashMap<String, ApiPermissionWrapper>();

    public static List<ApiPermissionWrapper> getApiPermissionVoList(boolean openApi) {
        List<ApiPermissionWrapper> list = ApiPermissionExtractor.extractAllApiPermissions();
        if (!openApi) {
            return list;
        }
        ArrayList<ApiPermissionWrapper> apiPermissionWrapperList = new ArrayList<ApiPermissionWrapper>();
        for (ApiPermissionWrapper apiPermissionWrapper : list) {
            if (apiPermissionWrapper.isOpenApi()) {
                apiPermissionWrapperList.add(apiPermissionWrapper);
                continue;
            }
            ArrayList<ApiPermission> permissions = new ArrayList<ApiPermission>();
            for (ApiPermission permission : apiPermissionWrapper.getApiPermissionList()) {
                ArrayList<ApiUri> apiUriList = new ArrayList<ApiUri>();
                for (ApiUri apiUri : permission.getApiUriList()) {
                    if (!apiUri.isOpenApi()) continue;
                    apiUriList.add(apiUri);
                }
                if (apiUriList.isEmpty()) continue;
                permissions.add(new ApiPermission(permission.getCode()).setApiUriList(apiUriList));
            }
            if (permissions.isEmpty()) continue;
            apiPermissionWrapperList.add(((ApiPermissionWrapper)BeanUtils.cloneBean((Object)apiPermissionWrapper)).setApiPermissionList(permissions));
        }
        return apiPermissionWrapperList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApiPermissionWrapper getPermissionCodeWrapper(Class<?> controllerClass) {
        String name;
        ApiPermissionWrapper wrapper = CLASS_PERMISSIONCODE_CACHE.get(controllerClass.getName());
        if (wrapper != null) {
            return wrapper;
        }
        String codePrefix = null;
        boolean openApi = false;
        BindPermission bindPermission = (BindPermission)AnnotationUtils.findAnnotation(controllerClass, BindPermission.class);
        if (bindPermission != null) {
            name = bindPermission.name();
            codePrefix = bindPermission.code();
            openApi = bindPermission.openApi();
            if (V.isEmpty((String)codePrefix)) {
                Class entityClazz = BeanUtils.getGenericityClass(controllerClass, (int)0);
                if (entityClazz == null) throw new InvalidUsageException("\u6ce8\u89e3@BindPermission\u6ce8\u89e3\u65e0\u6cd5\u81ea\u52a8\u63d0\u53d6code\uff1a{} \u7c7b\u65e0\u6cdb\u578bEntity\u53c2\u6570\uff0c\u8bf7\u624b\u52a8\u6307\u5b9acode\u503c\uff01", new Object[]{controllerClass.getName()});
                codePrefix = entityClazz.getSimpleName();
            }
        } else {
            name = S.substringBeforeLast((String)controllerClass.getSimpleName(), (String)"Controller");
        }
        wrapper = new ApiPermissionWrapper(name, codePrefix).setOpenApi(openApi);
        CLASS_PERMISSIONCODE_CACHE.put(controllerClass.getName(), wrapper);
        return wrapper;
    }
}

