/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.auth.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.diboot.core.entity.AbstractEntity;
import com.diboot.core.util.V;
import com.diboot.iam.auth.impl.BaseAuthServiceImpl;
import com.diboot.iam.config.Cons;
import com.diboot.iam.entity.IamAccount;
import com.diboot.iam.shiro.IamAuthToken;
import com.diboot.iam.util.IamSecurityUtils;
import lombok.Generated;
import org.apache.shiro.authc.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PwdAuthServiceImpl
extends BaseAuthServiceImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PwdAuthServiceImpl.class);

    @Override
    public String getAuthType() {
        return Cons.DICTCODE_AUTH_TYPE.PWD.name();
    }

    @Override
    protected Wrapper buildQueryWrapper(IamAuthToken iamAuthToken) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{AbstractEntity::getId, IamAccount::getAuthAccount, IamAccount::getAuthSecret, IamAccount::getSecretSalt, IamAccount::getUserType, IamAccount::getUserId, IamAccount::getStatus}).eq(IamAccount::getUserType, (Object)iamAuthToken.getUserType())).eq(IamAccount::getAuthType, (Object)iamAuthToken.getAuthType())).eq(IamAccount::getAuthAccount, (Object)iamAuthToken.getAuthAccount())).eq(V.notEmpty((String)iamAuthToken.getTenantId()), IamAccount::getTenantId, (Object)iamAuthToken.getTenantId())).orderByDesc(AbstractEntity::getId);
        return queryWrapper;
    }

    @Override
    public IamAccount getAccount(IamAuthToken iamAuthToken) throws AuthenticationException {
        IamAccount latestAccount = super.getAccount(iamAuthToken);
        if (latestAccount == null) {
            throw new AuthenticationException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef!");
        }
        if (iamAuthToken.isValidPassword() && !PwdAuthServiceImpl.isPasswordMatched(latestAccount, iamAuthToken)) {
            super.lockAccountIfRequired(latestAccount);
            throw new AuthenticationException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef!");
        }
        return latestAccount;
    }

    private static boolean isPasswordMatched(IamAccount account, IamAuthToken authToken) {
        String encryptedStr = IamSecurityUtils.encryptPwd(authToken.getAuthSecret(), account.getSecretSalt());
        return encryptedStr.equals(account.getAuthSecret());
    }
}

