/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.auth.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.diboot.core.entity.AbstractEntity;
import com.diboot.core.exception.BusinessException;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.Status;
import com.diboot.iam.auth.impl.BaseAuthServiceImpl;
import com.diboot.iam.config.Cons;
import com.diboot.iam.config.IamProperties;
import com.diboot.iam.dto.AuthCredential;
import com.diboot.iam.dto.OAuth2SSOCredential;
import com.diboot.iam.entity.IamAccount;
import com.diboot.iam.shiro.IamAuthToken;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
@ConditionalOnProperty(prefix="diboot.iam.oauth2-client", name={"client-id", "client-secret", "redirect-uri", "access-token-uri"})
public class OAuth2SSOServiceImpl
extends BaseAuthServiceImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuth2SSOServiceImpl.class);
    @Autowired(required=false)
    private RestTemplate restTemplate;
    @Autowired
    private IamProperties iamProperties;

    @Override
    public String getAuthType() {
        return Cons.DICTCODE_AUTH_TYPE.SSO.name();
    }

    @Override
    protected Wrapper buildQueryWrapper(IamAuthToken iamAuthToken) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{IamAccount::getAuthAccount, IamAccount::getUserType, IamAccount::getUserId, IamAccount::getStatus}).eq(IamAccount::getUserType, (Object)iamAuthToken.getUserType())).eq(V.notEmpty((String)iamAuthToken.getTenantId()), IamAccount::getTenantId, (Object)iamAuthToken.getTenantId())).eq(IamAccount::getAuthAccount, (Object)iamAuthToken.getAuthAccount())).orderByDesc(AbstractEntity::getId);
        return queryWrapper;
    }

    @Override
    public String applyToken(AuthCredential credential) {
        this.parseCode(credential);
        OAuth2SSOCredential ssoCredential = (OAuth2SSOCredential)credential;
        if (V.isEmpty((String)ssoCredential.getAuthAccount())) {
            throw new BusinessException(Status.FAIL_OPERATION, "exception.business.oauth2SSOService.authCenterValidFailed", new Object[0]);
        }
        return super.applyToken(credential);
    }

    @Override
    protected IamAuthToken initAuthToken(AuthCredential credential) {
        IamAuthToken token = new IamAuthToken(this.getAuthType(), credential.getUserTypeClass());
        token.setAuthAccount(credential.getAuthAccount());
        token.setTenantId(credential.getTenantId());
        token.setRememberMe(credential.isRememberMe());
        token.setExpiresInMinutes(this.getExpiresInMinutes());
        return token.generateAuthtoken();
    }

    protected void parseCode(AuthCredential credential) {
        if (this.restTemplate == null) {
            throw new InvalidUsageException("\u8bf7\u521d\u59cb\u5316 RestTemplate", new Object[0]);
        }
        OAuth2SSOCredential ssoCredential = (OAuth2SSOCredential)credential;
        IamProperties.Oauth2ClientProperties oauth2Client = this.iamProperties.getOauth2Client();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        byte[] authorization = (oauth2Client.getClientId() + ":" + oauth2Client.getClientSecret()).getBytes(StandardCharsets.UTF_8);
        String base64Auth = Base64.getEncoder().encodeToString(authorization);
        headers.add("Authorization", "Basic " + base64Auth);
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"grant_type", (Object)"authorization_code");
        param.add((Object)"code", (Object)ssoCredential.getCode());
        param.add((Object)"redirect_uri", (Object)oauth2Client.getRedirectUri());
        HttpEntity request = new HttpEntity((Object)param, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(oauth2Client.getAccessTokenUri(), (Object)request, Map.class, new Object[0]);
        Map tokenMap = (Map)response.getBody();
        if (V.notEmpty((Map)tokenMap)) {
            ssoCredential.setUserType(S.valueOf(tokenMap.get("userType")));
            ssoCredential.setAuthAccount(S.valueOf(tokenMap.get("username")));
        }
    }
}

