/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.auth.impl;

import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.V;
import com.diboot.core.vo.LabelValue;
import com.diboot.iam.auth.IamExtensible;
import com.diboot.iam.entity.IamPosition;
import com.diboot.iam.entity.IamRole;
import com.diboot.iam.entity.IamUser;
import com.diboot.iam.entity.IamUserPosition;
import com.diboot.iam.service.IamOrgService;
import com.diboot.iam.service.IamPositionService;
import com.diboot.iam.service.IamUserPositionService;
import com.diboot.iam.service.IamUserService;
import com.diboot.iam.vo.PositionDataScope;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IamExtensibleImpl
implements IamExtensible {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamExtensibleImpl.class);

    @Override
    public LabelValue getUserExtensionObj(String userType, String userId, Map<String, Object> extObj) {
        if (!IamUser.class.getSimpleName().equals(userType)) {
            log.warn("\u6269\u5c55\u7684\u7528\u6237\u7c7b\u578b: {} \u9700\u81ea\u884c\u5b9e\u73b0\u9644\u52a0\u6269\u5c55\u5bf9\u8c61\u903b\u8f91", (Object)userType);
            return null;
        }
        IamUserPositionService iamPositionService = (IamUserPositionService)ContextHolder.getBean(IamUserPositionService.class);
        IamUserPosition userPosition = iamPositionService.getUserPrimaryPosition(userType, userId);
        if (userPosition != null) {
            String orgId = userPosition.getOrgId();
            IamPosition position = (IamPosition)((Object)((IamPositionService)ContextHolder.getBean(IamPositionService.class)).getEntity((Serializable)((Object)userPosition.getPositionId())));
            PositionDataScope positionDataScope = new PositionDataScope((String)((Object)position.getId()), position.getDataPermissionType(), userId, orgId);
            ArrayList<String> accessibleUserIds = new ArrayList<String>();
            ArrayList<String> accessibleOrgIds = new ArrayList<String>();
            accessibleUserIds.add(userId);
            List<String> userIds = ((IamUserService)ContextHolder.getBean(IamUserService.class)).getUserIdsByManagerId(userId);
            if (V.notEmpty(userIds)) {
                userIds.forEach(uid -> {
                    if (!accessibleUserIds.contains(uid)) {
                        accessibleUserIds.add((String)uid);
                    }
                });
            }
            positionDataScope.setAccessibleUserIds(accessibleUserIds);
            accessibleOrgIds.add(orgId);
            List<String> childOrgIds = ((IamOrgService)ContextHolder.getBean(IamOrgService.class)).getChildOrgIds(orgId);
            if (V.notEmpty(childOrgIds)) {
                childOrgIds.forEach(oid -> {
                    if (!accessibleOrgIds.contains(oid)) {
                        accessibleOrgIds.add((String)oid);
                    }
                });
            }
            positionDataScope.setAccessibleOrgIds(accessibleOrgIds);
            return new LabelValue(position.getName(), (Object)position.getCode()).setExt((Object)positionDataScope);
        }
        return null;
    }

    @Override
    public List<IamRole> getExtensionRoles(String userType, String userId, String extensionObjId) {
        return null;
    }
}

