/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.auth.impl;

import com.diboot.core.vo.Status;
import com.diboot.iam.auth.IamCustomize;
import com.diboot.iam.entity.BaseLoginUser;
import com.diboot.iam.entity.IamAccount;
import com.diboot.iam.exception.PermissionException;
import com.diboot.iam.util.IamSecurityUtils;
import org.apache.shiro.authz.UnauthenticatedException;
import org.springframework.stereotype.Service;

@Service
public class IamCustomizeImpl
implements IamCustomize {
    @Override
    public BaseLoginUser getCurrentUser() {
        return (BaseLoginUser)((Object)IamSecurityUtils.getCurrentUser());
    }

    @Override
    public void encryptPwd(IamAccount iamAccount) {
        IamSecurityUtils.encryptPwd(iamAccount);
    }

    @Override
    public String encryptPwd(String password, String salt) {
        return IamSecurityUtils.encryptPwd(password, salt);
    }

    @Override
    public void checkPermission(String permissionCode) throws PermissionException {
        try {
            IamSecurityUtils.getSubject().checkPermission(permissionCode);
        }
        catch (UnauthenticatedException e) {
            throw new PermissionException(Status.FAIL_INVALID_TOKEN, e);
        }
        catch (Exception e) {
            throw new PermissionException(e);
        }
    }

    @Override
    public boolean checkCurrentUserHasRole(String role) {
        return IamSecurityUtils.getSubject().hasRole(role);
    }

    @Override
    public void clearAuthorizationCache(String userType, String userId) {
        IamSecurityUtils.clearAuthorizationCache(userType, userId);
    }
}

