/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.auth.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.diboot.core.config.BaseConfig;
import com.diboot.core.entity.BaseEntity;
import com.diboot.core.exception.BusinessException;
import com.diboot.core.util.Encryptor;
import com.diboot.core.util.I18n;
import com.diboot.core.util.V;
import com.diboot.core.vo.Status;
import com.diboot.iam.annotation.process.IamAsyncWorker;
import com.diboot.iam.auth.AuthService;
import com.diboot.iam.config.Cons;
import com.diboot.iam.config.IamProperties;
import com.diboot.iam.dto.AuthCredential;
import com.diboot.iam.entity.BaseLoginUser;
import com.diboot.iam.entity.IamAccount;
import com.diboot.iam.entity.IamLoginTrace;
import com.diboot.iam.mapper.IamAccountMapper;
import com.diboot.iam.service.IamAccountService;
import com.diboot.iam.service.IamLoginTraceService;
import com.diboot.iam.shiro.IamAuthToken;
import com.diboot.iam.util.HttpHelper;
import com.diboot.iam.util.IamSecurityUtils;
import com.diboot.iam.util.TokenUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseAuthServiceImpl
implements AuthService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseAuthServiceImpl.class);
    @Autowired
    private IamAccountService accountService;
    @Autowired
    private IamAsyncWorker iamAsyncWorker;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private IamLoginTraceService loginTraceService;
    @Autowired
    private IamProperties iamProperties;
    @Autowired
    private IamAccountMapper iamAccountMapper;

    @Override
    public String getAuthType() {
        return Cons.DICTCODE_AUTH_TYPE.PWD.name();
    }

    protected abstract Wrapper buildQueryWrapper(IamAuthToken var1);

    @Override
    public IamAccount getAccount(IamAuthToken iamAuthToken) throws AuthenticationException {
        List<IamAccount> latestAccounts = this.iamAccountMapper.findLoginAccount((Wrapper<IamAccount>)this.buildQueryWrapper(iamAuthToken), BaseConfig.getActiveFlagValue());
        if (V.isEmpty(latestAccounts)) {
            return null;
        }
        IamAccount latestAccount = latestAccounts.get(0);
        if (Cons.DICTCODE_ACCOUNT_STATUS.I.name().equals(latestAccount.getStatus())) {
            throw new AuthenticationException(I18n.message((String)"exception.authentication.authService.accountForbidden", (Object[])new Object[]{iamAuthToken.getAuthAccount()}));
        }
        if (Cons.DICTCODE_ACCOUNT_STATUS.L.name().equals(latestAccount.getStatus())) {
            throw new AuthenticationException(I18n.message((String)"exception.authentication.authService.accountLocked", (Object[])new Object[]{iamAuthToken.getAuthAccount()}));
        }
        return latestAccount;
    }

    @Override
    public String applyToken(AuthCredential credential) {
        IamAuthToken authToken = this.initAuthToken(credential);
        try {
            Subject subject = SecurityUtils.getSubject();
            subject.login((AuthenticationToken)authToken);
            if (subject.isAuthenticated()) {
                String accessToken = (String)authToken.getCredentials();
                TokenUtils.cacheAccessToken(accessToken, authToken.buildUserInfoStr());
                log.debug("\u7533\u8bf7token\u6210\u529f\uff01{}: {}", (Object)credential.getAuthAccount(), authToken.getCredentials());
                this.saveLoginTrace(authToken, true);
                return accessToken;
            }
            log.error("\u8ba4\u8bc1\u5931\u8d25");
            this.saveLoginTrace(authToken, false);
            throw new BusinessException(Status.FAIL_OPERATION, "exception.business.authService.authFailed", new Object[0]);
        }
        catch (Exception e) {
            log.error("\u767b\u5f55\u5f02\u5e38", (Throwable)e);
            this.saveLoginTrace(authToken, false);
            throw new BusinessException(Status.FAIL_OPERATION, e.getMessage(), new Object[0]);
        }
    }

    protected IamAuthToken initAuthToken(AuthCredential credential) {
        IamAuthToken token = new IamAuthToken(this.getAuthType(), credential.getUserTypeClass());
        token.setAuthAccount(credential.getAuthAccount());
        token.setAuthSecret(credential.getAuthSecret());
        token.setRememberMe(credential.isRememberMe());
        token.setTenantId(credential.getTenantId());
        token.setExtObj(credential.getExtObj());
        token.setExpiresInMinutes(this.getExpiresInMinutes());
        return token.generateAuthtoken();
    }

    protected void saveLoginTrace(IamAuthToken authToken, boolean isSuccess) {
        IamLoginTrace loginTrace = new IamLoginTrace();
        loginTrace.setAuthType(this.getAuthType()).setAuthAccount(authToken.getAuthAccount()).setUserType(authToken.getUserType()).setIsSuccess(isSuccess);
        BaseLoginUser currentUser = (BaseLoginUser)((Object)IamSecurityUtils.getCurrentUser());
        String currentUserId = currentUser == null ? "0" : (String)((Object)currentUser.getId());
        loginTrace.setUserId(currentUserId);
        String userAgent = HttpHelper.getUserAgent((HttpServletRequest)this.request);
        String ipAddress = HttpHelper.getRequestIp((HttpServletRequest)this.request);
        loginTrace.setUserAgent(userAgent).setIpAddress(ipAddress);
        String signature = Encryptor.encrypt((String)authToken.getAuthtoken(), (String[])new String[0]);
        loginTrace.setSignature(signature).setSignType(IamLoginTrace.SIGN_TYPE.LOGIN.name());
        this.iamAsyncWorker.saveLoginTraceLog(loginTrace);
    }

    protected void lockAccountIfRequired(IamAccount latestAccount) {
        int maxLoginAttempts;
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{IamLoginTrace::getIsSuccess}).eq(IamLoginTrace::getUserType, (Object)latestAccount.getUserType())).eq(IamLoginTrace::getAuthType, (Object)latestAccount.getAuthType())).eq(IamLoginTrace::getAuthAccount, (Object)latestAccount.getAuthAccount())).gt(BaseEntity::getCreateTime, (Object)LocalDateTime.now().minusDays(1L))).eq(V.notEmpty((String)latestAccount.getTenantId()), IamLoginTrace::getTenantId, (Object)latestAccount.getTenantId());
        List loginList = this.loginTraceService.getEntityListLimit((Wrapper)queryWrapper, maxLoginAttempts = this.iamProperties.getMaxLoginAttempts());
        if (V.notEmpty((Collection)loginList) && loginList.size() >= maxLoginAttempts) {
            IamLoginTrace loginTrace;
            int failCount = 0;
            Iterator iterator = loginList.iterator();
            while (iterator.hasNext() && !(loginTrace = (IamLoginTrace)((Object)iterator.next())).getIsSuccess().booleanValue()) {
                ++failCount;
            }
            if (failCount >= maxLoginAttempts) {
                latestAccount.setStatus(Cons.DICTCODE_ACCOUNT_STATUS.L.name());
                log.warn("\u7528\u6237\u767b\u5f55\u5931\u8d25\u6b21\u6570\u8d85\u8fc7\u6700\u5927\u9650\u503c\uff0c\u8d26\u53f7 {} \u5df2\u88ab\u9501\u5b9a\uff01", (Object)latestAccount.getAuthAccount());
                this.accountService.updateAccountStatus((String)((Object)latestAccount.getId()), Cons.DICTCODE_ACCOUNT_STATUS.L.name());
            }
        }
    }
}

