/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.annotation.process;

import com.diboot.core.util.AnnotationUtils;
import com.diboot.core.util.JSON;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.JsonResult;
import com.diboot.core.vo.Status;
import com.diboot.iam.annotation.Log;
import com.diboot.iam.annotation.process.IamAsyncWorker;
import com.diboot.iam.entity.BaseLoginUser;
import com.diboot.iam.entity.IamOperationLog;
import com.diboot.iam.util.HttpHelper;
import com.diboot.iam.util.IamSecurityUtils;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamSource;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class LogAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    @Autowired
    private IamAsyncWorker iamAsyncWorker;
    private static int maxLength = 1000;
    private ThreadLocal<BaseLoginUser> threadLocal = new ThreadLocal();

    @Pointcut(value="@annotation(com.diboot.iam.annotation.Log)")
    public void pointCut() {
    }

    @Before(value="pointCut()")
    public void beforeHandler(JoinPoint joinPoint) {
        BaseLoginUser currentUser = (BaseLoginUser)((Object)IamSecurityUtils.getCurrentUser());
        this.threadLocal.set(currentUser);
    }

    @AfterReturning(value="pointCut()", returning="returnObj")
    public void afterReturningHandler(JoinPoint proceedingJoinPoint, Object returnObj) {
        JsonResult jsonResult;
        IamOperationLog operationLog = this.buildOperationLog(proceedingJoinPoint);
        BaseLoginUser currentUser = (BaseLoginUser)((Object)IamSecurityUtils.getCurrentUser());
        if (currentUser == null) {
            currentUser = this.threadLocal.get();
        }
        int statusCode = 0;
        String errorMsg = null;
        if (returnObj instanceof JsonResult && (statusCode = (jsonResult = (JsonResult)returnObj).getCode()) > 0) {
            errorMsg = jsonResult.getMsg();
        }
        operationLog.setStatusCode(statusCode).setErrorMsg(errorMsg);
        this.iamAsyncWorker.saveOperationLog(operationLog, currentUser);
        this.threadLocal.remove();
    }

    @AfterThrowing(value="pointCut()", throwing="throwable")
    public void afterThrowingHandler(JoinPoint joinPoint, Throwable throwable) {
        IamOperationLog operationLog = this.buildOperationLog(joinPoint);
        int statusCode = Status.FAIL_EXCEPTION.code();
        Object errorMsg = null;
        if (throwable != null) {
            errorMsg = throwable.toString();
            Object[] stackTraceElements = throwable.getStackTrace();
            if (V.notEmpty((Object[])stackTraceElements)) {
                errorMsg = (String)errorMsg + " : " + ((StackTraceElement)stackTraceElements[0]).toString();
            }
            errorMsg = S.cut((String)errorMsg, (int)maxLength);
        }
        operationLog.setStatusCode(statusCode).setErrorMsg((String)errorMsg);
        this.iamAsyncWorker.saveOperationLog(operationLog, (BaseLoginUser)((Object)IamSecurityUtils.getCurrentUser()));
    }

    private IamOperationLog buildOperationLog(JoinPoint joinPoint) {
        Object[] bodyParams;
        MethodSignature signature;
        Method method;
        Log logAnno;
        IamOperationLog operationLog = new IamOperationLog();
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = ((ServletRequestAttributes)ra).getRequest();
        operationLog.setRequestMethod(request.getMethod()).setRequestUri(request.getRequestURI()).setRequestIp(HttpHelper.getRequestIp((HttpServletRequest)request));
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        if (V.notEmpty((String)request.getQueryString())) {
            paramsMap.put("query", request.getQueryString());
        }
        if ((logAnno = (Log)AnnotationUtils.getAnnotation((Method)(method = (signature = (MethodSignature)joinPoint.getSignature()).getMethod()), Log.class)).saveRequestData() && V.notEmpty((Object[])(bodyParams = joinPoint.getArgs()))) {
            for (Object arg : bodyParams) {
                if (arg == null || !this.isSimpleDataType(arg)) continue;
                paramsMap.put(arg.getClass().getSimpleName(), arg);
            }
        }
        String paramsJson = null;
        if (V.notEmpty(paramsMap)) {
            paramsJson = JSON.stringify(paramsMap);
        }
        operationLog.setRequestParams(paramsJson);
        String businessObj = logAnno.businessObj();
        if (V.isEmpty((String)businessObj)) {
            Class<?> clazz = method.getDeclaringClass();
            Class entityClazz = com.diboot.core.util.BeanUtils.getGenericityClass(clazz, (int)0);
            if (entityClazz != null) {
                businessObj = entityClazz.getSimpleName();
            } else {
                log.warn("@Log(operation='{}') \u6ce8\u89e3\u672a\u8bc6\u522b\u5230class\u6cdb\u578b\u53c2\u6570\uff0c\u8bf7\u6307\u5b9a businessObj", (Object)logAnno.operation());
            }
        }
        operationLog.setBusinessObj(businessObj).setOperation(logAnno.operation());
        return operationLog;
    }

    private boolean isSimpleDataType(Object arg) {
        Class<?> clazz = arg.getClass();
        if (arg instanceof Collection) {
            Collection collection = (Collection)arg;
            Object firstElement = collection.stream().findFirst().orElse(null);
            return this.isSimpleClassType(firstElement);
        }
        if (clazz.isArray()) {
            return this.isSimpleClassType(clazz.getComponentType());
        }
        if (arg instanceof Map) {
            Map map = (Map)arg;
            for (Map.Entry entry : map.entrySet()) {
                boolean isSimple = this.isSimpleClassType(entry.getValue().getClass());
                if (isSimple) continue;
                return false;
            }
            return true;
        }
        return this.isSimpleClassType(arg);
    }

    private boolean isSimpleClassType(Object arg) {
        if (arg == null) {
            return false;
        }
        Class<?> clazz = arg.getClass();
        boolean isSimple = BeanUtils.isSimpleProperty(clazz);
        if (isSimple) {
            return true;
        }
        return !(arg instanceof InputStreamSource) && !S.containsIgnoreCase((CharSequence)arg.getClass().getName(), (CharSequence)"multipart") && !(arg instanceof ServletRequest) && !(arg instanceof ServletResponse) && !(arg instanceof Errors);
    }
}

