/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.annotation.process;

import com.diboot.core.util.AnnotationUtils;
import com.diboot.core.util.V;
import com.diboot.core.vo.Status;
import com.diboot.iam.annotation.BindPermission;
import com.diboot.iam.annotation.process.ApiPermissionWrapper;
import com.diboot.iam.cache.IamPermissionCacheManager;
import com.diboot.iam.config.IamProperties;
import com.diboot.iam.entity.BaseLoginUser;
import com.diboot.iam.exception.PermissionException;
import com.diboot.iam.util.IamSecurityUtils;
import java.lang.reflect.Method;
import lombok.Generated;
import org.apache.shiro.authz.UnauthenticatedException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class BindPermissionAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BindPermissionAspect.class);
    @Autowired
    private IamProperties iamProperties;

    @Pointcut(value="@annotation(com.diboot.iam.annotation.BindPermission)")
    public void pointCut() {
    }

    @Before(value="pointCut()")
    public void before(JoinPoint joinPoint) {
        if (!this.iamProperties.isEnablePermissionCheck()) {
            log.debug("BindPermission\u6743\u9650\u68c0\u67e5\u5df2\u505c\u7528\uff0c\u5982\u9700\u542f\u7528\u8bf7\u5220\u9664\u914d\u7f6e\u9879: diboot.iam.enable-permission-check=false");
            return;
        }
        if (IamSecurityUtils.isSuperAdmin()) {
            return;
        }
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        BindPermission methodAnno = (BindPermission)AnnotationUtils.getAnnotation((Method)method, BindPermission.class);
        Object permissionCode = methodAnno.code();
        Class<?> controllerClass = joinPoint.getTarget().getClass();
        ApiPermissionWrapper classAnno = IamPermissionCacheManager.getPermissionCodeWrapper(controllerClass);
        if (V.notEmpty((String)classAnno.getCode())) {
            permissionCode = classAnno.getCode() + ":" + (String)permissionCode;
        }
        try {
            IamSecurityUtils.getSubject().checkPermission((String)permissionCode);
        }
        catch (UnauthenticatedException e) {
            throw new PermissionException(Status.FAIL_INVALID_TOKEN, e);
        }
        catch (Exception e) {
            BaseLoginUser currentUser = (BaseLoginUser)((Object)IamSecurityUtils.getCurrentUser());
            String loginUser = currentUser != null ? currentUser.getDisplayName() : null;
            log.warn("\u7528\u6237 {} \u65e0 {} \u7684\u8bbf\u95ee\u6743\u9650", (Object)loginUser, permissionCode);
            throw new PermissionException(Status.FAIL_NO_PERMISSION, e);
        }
    }
}

