/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.annotation.process;

import com.diboot.core.util.AnnotationUtils;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.V;
import com.diboot.core.vo.ApiUri;
import com.diboot.iam.annotation.BindPermission;
import com.diboot.iam.annotation.process.ApiPermission;
import com.diboot.iam.annotation.process.ApiPermissionWrapper;
import com.diboot.iam.cache.IamPermissionCacheManager;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

public class ApiPermissionExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiPermissionExtractor.class);
    private static List<ApiPermissionWrapper> API_PERMISSION_CACHE = null;
    private static Set<String> UNIQUE_KEY_SET = null;

    public static List<ApiPermissionWrapper> extractAllApiPermissions() {
        if (API_PERMISSION_CACHE == null) {
            API_PERMISSION_CACHE = new ArrayList<ApiPermissionWrapper>();
            UNIQUE_KEY_SET = new HashSet<String>();
            List controllerList = ContextHolder.getBeansByAnnotation(RestController.class);
            ApiPermissionExtractor.extractApiPermissions(controllerList);
            controllerList = ContextHolder.getBeansByAnnotation(Controller.class);
            ApiPermissionExtractor.extractApiPermissions(controllerList);
        }
        return API_PERMISSION_CACHE;
    }

    private static void extractApiPermissions(List<Object> controllerList) {
        if (V.isEmpty(controllerList)) {
            return;
        }
        for (Object obj : controllerList) {
            Class controllerClass = BeanUtils.getTargetClass((Object)obj);
            if (UNIQUE_KEY_SET.contains(controllerClass.getName())) continue;
            UNIQUE_KEY_SET.add(controllerClass.getName());
            ApiPermissionWrapper wrapper = IamPermissionCacheManager.getPermissionCodeWrapper(controllerClass);
            ApiPermissionExtractor.buildApiPermissionsInClass(wrapper, controllerClass);
            if (!wrapper.notEmpty()) continue;
            API_PERMISSION_CACHE.add(wrapper);
        }
    }

    private static void buildApiPermissionsInClass(ApiPermissionWrapper wrapper, Class controllerClass) {
        List annoMethods = AnnotationUtils.extractAnnotationMethods((Class)controllerClass, BindPermission.class);
        if (V.isEmpty((Collection)annoMethods)) {
            return;
        }
        String urlPrefix = "";
        RequestMapping requestMapping = (RequestMapping)AnnotationUtils.findAnnotation((Class)controllerClass, RequestMapping.class);
        if (requestMapping != null) {
            urlPrefix = AnnotationUtils.getNotEmptyStr((String[])requestMapping.value(), (String[])requestMapping.path());
        }
        ArrayList<ApiPermission> apiPermissions = new ArrayList<ApiPermission>();
        HashMap<String, ApiPermission> tempCode2ObjMap = new HashMap<String, ApiPermission>();
        for (Method method : annoMethods) {
            ApiUri apiUriCombo;
            BindPermission bindPermission;
            if (Modifier.isPrivate(method.getModifiers()) || (bindPermission = (BindPermission)AnnotationUtils.getAnnotation((Method)method, BindPermission.class)) == null || (apiUriCombo = AnnotationUtils.extractRequestMethodAndMappingUrl((Method)method)).isEmpty()) continue;
            if (V.isEmpty((String)bindPermission.code())) {
                log.warn("\u5ffd\u7565\u65e0\u6548\u7684\u6743\u9650\u914d\u7f6e(\u672a\u6307\u5b9acode): {}.{}", (Object)controllerClass.getSimpleName(), (Object)method.getName());
                continue;
            }
            String name = bindPermission.name();
            Object code = wrapper.getCode() != null ? wrapper.getCode() + ":" + bindPermission.code() : bindPermission.code();
            ApiPermission apiPermission = (ApiPermission)tempCode2ObjMap.get(code);
            if (apiPermission == null) {
                apiPermission = new ApiPermission((String)code);
                tempCode2ObjMap.put((String)code, apiPermission);
                apiPermissions.add(apiPermission);
            }
            apiUriCombo.setLabel(name);
            apiUriCombo.setOpenApi(bindPermission.openApi());
            ApiPermissionExtractor.buildApiPermission(apiPermission, urlPrefix, apiUriCombo);
        }
        if (apiPermissions.size() > 0) {
            wrapper.setApiPermissionList(apiPermissions);
        }
    }

    private static void buildApiPermission(ApiPermission apiPermission, String urlPrefix, ApiUri apiUriCombo) {
        String requestMethod = apiUriCombo.getMethod();
        String url = apiUriCombo.getUri();
        boolean openApi = apiUriCombo.isOpenApi();
        List<ApiUri> apiUriList = apiPermission.getApiUriList();
        for (String m : requestMethod.split(",")) {
            for (String u : url.split(",")) {
                Object uri = u;
                if (V.notEmpty((String)urlPrefix)) {
                    uri = urlPrefix + u;
                }
                ApiUri apiUri = new ApiUri(m, (String)uri, apiUriCombo.getLabel());
                apiUri.setOpenApi(openApi);
                apiUriList.add(apiUri);
            }
        }
    }
}

