/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.starter;

import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.diboot.core.cache.BaseCacheManager;
import com.diboot.core.cache.DictionaryCacheManager;
import com.diboot.core.cache.DynamicMemoryCacheManager;
import com.diboot.core.cache.I18nCacheManager;
import com.diboot.core.config.Cons;
import com.diboot.core.config.CoreProperties;
import com.diboot.core.config.GlobalProperties;
import com.diboot.core.data.protect.DataEncryptHandler;
import com.diboot.core.data.protect.DataMaskHandler;
import com.diboot.core.data.protect.DefaultDataEncryptHandler;
import com.diboot.core.data.protect.DefaultDataMaskHandler;
import com.diboot.core.extension.sequence.counter.MemoryCacheSeqCounter;
import com.diboot.core.extension.sequence.counter.SeqCounter;
import com.diboot.core.init.CoreRedisAutoConfig;
import com.diboot.core.serial.deserializer.LocalDateTimeDeserializer;
import com.diboot.core.serial.serializer.BigDecimal2StringSerializer;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.D;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.LocalDateTypeHandler;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.filter.OrderedRequestContextFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.web.filter.RequestContextFilter;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;

@Order(value=902)
@EnableAsync
@Configuration
@AutoConfigureAfter(value={CoreRedisAutoConfig.class})
@EnableConfigurationProperties(value={CoreProperties.class, GlobalProperties.class})
@ComponentScan(basePackages={"com.diboot.core"})
@MapperScan(basePackages={"com.diboot.core.mapper"})
public class CoreAutoConfig
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(CoreAutoConfig.class);
    @Value(value="${spring.jackson.date-format:yyyy-MM-dd HH:mm:ss}")
    private String defaultDatePattern;
    @Value(value="${spring.jackson.time-zone:GMT+8}")
    private String defaultTimeZone;
    @Value(value="${spring.jackson.default-property-inclusion:NON_NULL}")
    private JsonInclude.Include defaultPropertyInclusion;

    public CoreAutoConfig() {
        log.info("\u521d\u59cb\u5316 core \u5185\u6838 \u81ea\u52a8\u914d\u7f6e");
    }

    @Bean
    @ConditionalOnMissingBean
    public Jackson2ObjectMapperBuilderCustomizer jsonCustomizer() {
        return builder -> {
            builder.serializerByType(Long.class, (JsonSerializer)ToStringSerializer.instance);
            builder.serializerByType(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
            builder.serializerByType(BigInteger.class, (JsonSerializer)ToStringSerializer.instance);
            builder.serializerByType(BigDecimal.class, (JsonSerializer)BigDecimal2StringSerializer.instance);
            DateTimeFormatter localDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            builder.serializerByType(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(localDateTimeFormatter));
            builder.deserializerByType(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer());
            DateTimeFormatter localDateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            builder.serializerByType(LocalDate.class, (JsonSerializer)new LocalDateSerializer(localDateFormatter));
            builder.deserializerByType(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(localDateFormatter));
            DateTimeFormatter localTimeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
            builder.serializerByType(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(localTimeFormatter));
            builder.deserializerByType(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(localTimeFormatter));
            builder.serializationInclusion(this.defaultPropertyInclusion);
            builder.failOnUnknownProperties(false);
            builder.timeZone(TimeZone.getTimeZone(this.defaultTimeZone));
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.defaultDatePattern){

                @Override
                public java.util.Date parse(String dateStr) {
                    return D.fuzzyConvert((String)dateStr);
                }
            };
            builder.dateFormat((DateFormat)dateFormat);
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public Jackson2ObjectMapperBuilder jackson2ObjectMapperBuilder() {
        Jackson2ObjectMapperBuilder objectMapperBuilder = new Jackson2ObjectMapperBuilder();
        this.jsonCustomizer().customize(objectMapperBuilder);
        log.info("\u542f\u7528\u9ed8\u8ba4\u7684Jackson\u81ea\u5b9a\u4e49\u914d\u7f6e");
        return objectMapperBuilder;
    }

    @Bean
    @ConditionalOnMissingBean
    public MappingJackson2HttpMessageConverter jacksonMessageConverter() {
        return new MappingJackson2HttpMessageConverter(this.jackson2ObjectMapperBuilder().build());
    }

    @Bean
    @ConditionalOnMissingBean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor());
        return interceptor;
    }

    @Bean
    @ConditionalOnMissingBean(value={DataEncryptHandler.class})
    public DataEncryptHandler dataEncryptHandler() {
        log.debug("\u521d\u59cb\u5316\u9ed8\u8ba4\u7684\u52a0\u5bc6\u5b9e\u73b0\uff1aDataEncryptHandler");
        return new DefaultDataEncryptHandler();
    }

    @Bean
    @ConditionalOnMissingBean(value={DataMaskHandler.class})
    public DataMaskHandler dataMaskHandler() {
        log.debug("\u521d\u59cb\u5316\u9ed8\u8ba4\u7684\u8131\u654f\u5b9e\u73b0\uff1aDataMaskHandler");
        return new DefaultDataMaskHandler();
    }

    public void addFormatters(FormatterRegistry registry) {
        List converterList = ContextHolder.getBeans(Converter.class);
        if (converterList != null && !converterList.isEmpty()) {
            converterList.forEach(arg_0 -> ((FormatterRegistry)registry).addConverter(arg_0));
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public ConfigurationCustomizer typeHandlerRegistry() {
        return configuration -> configuration.getTypeHandlerRegistry().register(Date.class, JdbcType.DATE, LocalDateTypeHandler.class);
    }

    @Bean
    @ConditionalOnMissingBean
    public DictionaryCacheManager dictionaryCacheManager() {
        log.info("\u521d\u59cb\u5316 Dictionary \u5185\u5b58\u7f13\u5b58: DynamicMemoryCacheManager");
        HashMap<String, Integer> cacheName2ExpireMap = new HashMap<String, Integer>(){
            {
                this.put(Cons.CACHE_NAME_DICTIONARY, 1440);
            }
        };
        DynamicMemoryCacheManager memoryCacheManager = new DynamicMemoryCacheManager((Map)cacheName2ExpireMap);
        return new DictionaryCacheManager((BaseCacheManager)memoryCacheManager);
    }

    @Bean
    @ConditionalOnMissingBean
    public I18nCacheManager i18nCacheManager() {
        log.info("\u521d\u59cb\u5316 I18n \u5185\u5b58\u7f13\u5b58: DynamicMemoryCacheManager");
        HashMap<String, Integer> cacheName2ExpireMap = new HashMap<String, Integer>(){
            {
                this.put(Cons.CACHE_NAME_I18N, 1440);
            }
        };
        DynamicMemoryCacheManager memoryCacheManager = new DynamicMemoryCacheManager((Map)cacheName2ExpireMap);
        return new I18nCacheManager((BaseCacheManager)memoryCacheManager);
    }

    @Bean
    public LocaleResolver localeResolver() {
        AcceptHeaderLocaleResolver localeResolver = new AcceptHeaderLocaleResolver();
        localeResolver.setDefaultLocale(Locale.SIMPLIFIED_CHINESE);
        return localeResolver;
    }

    @Bean
    public static RequestContextFilter requestContextFilter() {
        OrderedRequestContextFilter orderedRequestContextFilter = new OrderedRequestContextFilter();
        orderedRequestContextFilter.setThreadContextInheritable(true);
        return orderedRequestContextFilter;
    }

    @Bean
    @ConditionalOnMissingBean(value={SeqCounter.class})
    public SeqCounter memoryCacheSeqCounter() {
        log.info("\u521d\u59cb\u5316 \u6d41\u6c34\u53f7\u8ba1\u6570\u5668 \u5185\u5b58\u7f13\u5b58: MemoryCacheSeqCounter");
        return new MemoryCacheSeqCounter();
    }
}

