/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.diboot.core.cache.I18nCacheManager;
import com.diboot.core.entity.I18nConfig;
import com.diboot.core.mapper.I18nConfigMapper;
import com.diboot.core.service.I18nConfigService;
import com.diboot.core.service.impl.BaseServiceImpl;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.I18nConfigVO;
import com.diboot.core.vo.Pagination;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnProperty(prefix="diboot", name={"i18n"}, havingValue="true")
public class I18nConfigServiceImpl
extends BaseServiceImpl<I18nConfigMapper, I18nConfig>
implements I18nConfigService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(I18nConfigServiceImpl.class);
    @Autowired
    private I18nCacheManager i18nCacheManager;

    @Transactional(rollbackFor={Exception.class})
    public boolean createOrUpdateEntities(Collection entityList) {
        if (V.isEmpty((Collection)entityList)) {
            return false;
        }
        for (Object entity : entityList) {
            I18nConfig i18nConfig = (I18nConfig)entity;
            Map<String, String> languageCached = this.i18nCacheManager.getLanguageCached(i18nConfig.getLanguage());
            if (!V.notEmpty(languageCached)) continue;
            languageCached.remove(i18nConfig.getCode());
            log.debug("I18N {}:{} \u7684\u7f13\u5b58\u5df2\u88ab\u79fb\u9664", (Object)i18nConfig.getLanguage(), (Object)i18nConfig.getCode());
        }
        return super.createOrUpdateEntities(entityList);
    }

    protected void beforeCreate(I18nConfig entity) {
        Map<String, String> languageCached = this.i18nCacheManager.getLanguageCached(entity.getLanguage());
        if (V.notEmpty(languageCached)) {
            languageCached.remove(entity.getCode());
            log.debug("I18N {}:{} \u7684\u7f13\u5b58\u5df2\u88ab\u79fb\u9664", (Object)entity.getLanguage(), (Object)entity.getCode());
        }
    }

    protected void beforeUpdate(I18nConfig entity) {
        this.beforeCreate(entity);
    }

    protected void beforeDelete(String fieldKey, Object fieldVal) {
        QueryWrapper queryWrapper = this.buildQueryWrapperByFieldValue(fieldKey, fieldVal);
        queryWrapper.lambda().select(new SFunction[]{I18nConfig::getLanguage, I18nConfig::getCode});
        List i18nConfigList = this.getEntityList((Wrapper)queryWrapper);
        if (V.isEmpty((Collection)i18nConfigList)) {
            return;
        }
        i18nConfigList.forEach(this::beforeCreate);
    }

    public Collection<List<I18nConfigVO>> getI18nList(I18nConfig entity, Pagination pagination) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery().select(new SFunction[]{I18nConfig::getCode});
        queryWrapper.eq(V.notEmpty((String)entity.getType()), I18nConfig::getType, (Object)entity.getType());
        queryWrapper.like(V.notEmpty((String)entity.getCode()), I18nConfig::getCode, (Object)entity.getCode());
        queryWrapper.like(V.notEmpty((String)entity.getContent()), I18nConfig::getContent, (Object)entity.getContent());
        queryWrapper.groupBy(I18nConfig::getCode);
        List codes = this.getEntityList((Wrapper)queryWrapper, pagination).stream().map(I18nConfig::getCode).collect(Collectors.toList());
        if (V.isEmpty(codes)) {
            return Collections.emptyList();
        }
        QueryWrapper query = Wrappers.query();
        for (OrderItem order : pagination.toPage(I18nConfig.class).orders()) {
            query.orderBy(true, order.isAsc(), (Object)order.getColumn());
        }
        List entityList = this.getViewObjectList((Wrapper)query.lambda().in(I18nConfig::getCode, codes), null, I18nConfigVO.class);
        return entityList.stream().collect(Collectors.groupingBy(I18nConfig::getCode, LinkedHashMap::new, Collectors.toList())).values();
    }

    public void bindI18nContent(List<?> voList, String getI18nCodeField, String setI18nContentField) {
        if (V.isEmpty(voList)) {
            return;
        }
        Locale locale = LocaleContextHolder.getLocale();
        String language = locale.toString();
        Map<String, String> languageCached = this.i18nCacheManager.getLanguageCached(language);
        HashSet<String> codes = new HashSet<String>();
        for (Object item : voList) {
            Object i18nCode = BeanUtils.getProperty(item, (String)getI18nCodeField);
            if (!V.notEmpty((Object)i18nCode)) continue;
            if (V.notEmpty(languageCached) && V.notEmpty((String)languageCached.get(i18nCode))) {
                BeanUtils.setProperty(item, (String)setI18nContentField, (Object)languageCached.get(i18nCode));
                log.trace("\u8bed\u8a00\u73af\u5883 {} \u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6 {} \u7684\u9009\u9879\u6570\u636e", (Object)language, i18nCode);
                continue;
            }
            codes.add(S.valueOf((Object)i18nCode));
        }
        if (V.isEmpty(codes)) {
            return;
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.select(new SFunction[]{I18nConfig::getLanguage, I18nConfig::getCode, I18nConfig::getContent});
        queryWrapper.in(I18nConfig::getCode, codes);
        queryWrapper.eq(I18nConfig::getLanguage, (Object)language);
        List i18nConfigList = this.getEntityList((Wrapper)queryWrapper);
        if (V.isEmpty((Collection)i18nConfigList)) {
            log.warn("\u672a\u83b7\u53d6\u5230\u56fd\u9645\u5316\u7ffb\u8bd1 {}: {}\uff0c\u8bf7\u68c0\u67e5\u56fd\u9645\u5316\u7ffb\u8bd1\u914d\u7f6e", (Object)language, codes);
            return;
        }
        Map<String, String> i18nMap = i18nConfigList.stream().collect(Collectors.toMap(I18nConfig::getCode, I18nConfig::getContent));
        this.i18nCacheManager.cacheLanguage(language, i18nMap);
        for (Object item : voList) {
            String content;
            Object i18nCode = BeanUtils.getProperty(item, (String)getI18nCodeField);
            if (!V.notEmpty((Object)i18nCode) || !codes.contains(i18nCode) || !V.notEmpty((String)(content = i18nMap.get(S.valueOf((Object)i18nCode))))) continue;
            BeanUtils.setProperty(item, (String)setI18nContentField, (Object)content);
        }
    }

    public Map<String, String> translate(List<String> i18nKeys) {
        if (V.isEmpty(i18nKeys)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> i18nTranslateMap = new HashMap<String, String>(i18nKeys.size());
        Locale locale = LocaleContextHolder.getLocale();
        String language = locale.toString();
        Map<String, String> languageCached = this.i18nCacheManager.getLanguageCached(language);
        HashSet<String> noCachedCodes = new HashSet<String>();
        for (String i18nCode : i18nKeys) {
            if (V.notEmpty(languageCached) && V.notEmpty((String)languageCached.get(i18nCode))) {
                i18nTranslateMap.put(i18nCode, languageCached.get(i18nCode));
                log.trace("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u56fd\u9645\u5316\u7ffb\u8bd1 {}: {} ", (Object)language, (Object)i18nCode);
                continue;
            }
            noCachedCodes.add(i18nCode);
        }
        if (V.isEmpty(noCachedCodes)) {
            return i18nTranslateMap;
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.select(new SFunction[]{I18nConfig::getLanguage, I18nConfig::getCode, I18nConfig::getContent});
        queryWrapper.eq(I18nConfig::getLanguage, (Object)language);
        queryWrapper.in(I18nConfig::getCode, noCachedCodes);
        List i18nConfigList = this.getEntityList((Wrapper)queryWrapper);
        if (V.isEmpty((Collection)i18nConfigList)) {
            log.warn("\u672a\u83b7\u53d6\u5230\u56fd\u9645\u5316\u7ffb\u8bd1 {}: {}\uff0c\u8bf7\u68c0\u67e5\u56fd\u9645\u5316\u7ffb\u8bd1\u914d\u7f6e", (Object)language, noCachedCodes);
            return i18nTranslateMap;
        }
        Map<String, String> i18nMap = i18nConfigList.stream().collect(Collectors.toMap(I18nConfig::getCode, I18nConfig::getContent));
        this.i18nCacheManager.cacheLanguage(language, i18nMap);
        i18nTranslateMap.putAll(i18nMap);
        return i18nTranslateMap;
    }

    public void updateI18nContent(String language, String code, String newContent) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(I18nConfig::getContent, (Object)newContent)).eq(I18nConfig::getLanguage, (Object)language)).eq(I18nConfig::getCode, (Object)code);
        this.updateEntity((Wrapper)updateWrapper);
        HashMap<String, String> i18nItemCache = new HashMap<String, String>();
        i18nItemCache.put(code, newContent);
        this.i18nCacheManager.cacheLanguage(language, i18nItemCache);
        log.debug("I18N {}:{} \u7684\u7f13\u5b58\u5df2\u88ab\u66f4\u65b0\u4e3a: {}", new Object[]{language, code, newContent});
    }
}

