/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.diboot.core.cache.DictionaryCacheManager;
import com.diboot.core.entity.AbstractEntity;
import com.diboot.core.entity.Dictionary;
import com.diboot.core.exception.BusinessException;
import com.diboot.core.mapper.DictionaryMapper;
import com.diboot.core.service.DictionaryService;
import com.diboot.core.service.DictionaryServiceExtProvider;
import com.diboot.core.service.I18nConfigService;
import com.diboot.core.service.impl.BaseServiceImpl;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.IGetter;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.DictionaryVO;
import com.diboot.core.vo.LabelValue;
import com.diboot.core.vo.Status;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Primary
@Service(value="dictionaryService")
public class DictionaryServiceExtImpl
extends BaseServiceImpl<DictionaryMapper, Dictionary>
implements DictionaryService,
DictionaryServiceExtProvider {
    private static final Logger log = LoggerFactory.getLogger(DictionaryServiceExtImpl.class);
    @Autowired
    private DictionaryCacheManager dictionaryCacheManager;
    @Autowired(required=false)
    private I18nConfigService i18nConfigService;

    protected void beforeCreate(Dictionary entity) {
        this.dictionaryCacheManager.removeCachedItems(entity.getType());
        log.debug("\u5b57\u5178 {}:{} \u7684\u7f13\u5b58\u5df2\u88ab\u79fb\u9664", (Object)entity.getItemName(), (Object)entity.getType());
    }

    protected void beforeUpdate(Dictionary entity) {
        this.dictionaryCacheManager.removeCachedItems(entity.getType());
        log.debug("\u5b57\u5178 {}:{} \u7684\u7f13\u5b58\u5df2\u88ab\u79fb\u9664", (Object)entity.getItemName(), (Object)entity.getType());
    }

    protected void beforeDelete(String fieldKey, Object fieldVal) {
        List types = this.getValuesOfField(fieldKey, fieldVal, Dictionary::getType);
        if (V.isEmpty((Collection)types)) {
            return;
        }
        types.forEach(type -> {
            this.dictionaryCacheManager.removeCachedItems((String)type);
            log.debug("\u5b57\u5178 {} \u7684\u7f13\u5b58\u5df2\u88ab\u79fb\u9664", type);
        });
    }

    public List<Dictionary> getEntityListByType(String type) {
        List dictList = this.dictionaryCacheManager.getCachedItems(type);
        if (dictList == null) {
            LambdaQueryWrapper queryDictionary = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().select(new SFunction[]{Dictionary::getItemName, Dictionary::getItemValue, Dictionary::getItemNameI18n, Dictionary::getExtension}).eq(Dictionary::getType, (Object)type)).isNotNull(Dictionary::getParentId)).ne(Dictionary::getParentId, (Object)"0")).orderByAsc(Arrays.asList(Dictionary::getSortId, AbstractEntity::getId));
            dictList = super.getEntityList((Wrapper)queryDictionary);
            log.debug("\u67e5\u8be2\u5230\u5b57\u5178 {} \u7684\u9009\u9879\u6570\u636e", (Object)type);
            this.dictionaryCacheManager.cacheItems(type, dictList);
        } else {
            log.debug("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6 {} \u7684\u9009\u9879\u6570\u636e", (Object)type);
        }
        return dictList;
    }

    public List<LabelValue> getLabelValueList(String type) {
        List<Dictionary> dictionaryList = this.getEntityListByType(type);
        if (V.isEmpty(dictionaryList)) {
            log.warn("\u5b57\u5178 {} \u65e0\u4efb\u4f55\u9009\u9879\u5b9a\u4e49\uff01", (Object)type);
            return Collections.emptyList();
        }
        return this.convertToLabelValueList(dictionaryList);
    }

    public Map<String, LabelValue> getLabel2ItemMap(String type) {
        List<Dictionary> dictionaryList = this.getEntityListByType(type);
        return dictionaryList.stream().collect(Collectors.toMap(Dictionary::getItemName, Dictionary::toLabelValue));
    }

    public Map<String, LabelValue> getValue2ItemMap(String type) {
        List<Dictionary> dictionaryList = this.getEntityListByType(type);
        return dictionaryList.stream().collect(Collectors.toMap(Dictionary::getItemValue, Dictionary::toLabelValue));
    }

    public boolean existsDictType(String dictType) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Dictionary::getType, (Object)dictType);
        return this.exists((Wrapper)queryWrapper);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean createDictAndChildren(DictionaryVO dictVO) {
        if (dictVO.getIsEditable() == null) {
            dictVO.setIsEditable(Boolean.valueOf(true));
        }
        if (dictVO.getIsDeletable() == null) {
            dictVO.setIsDeletable(Boolean.valueOf(true));
        }
        if (!super.createEntity((Object)dictVO)) {
            log.warn("\u65b0\u5efa\u6570\u636e\u5b57\u5178\u5b9a\u4e49\u5931\u8d25\uff0ctype={}", (Object)dictVO.getType());
            return false;
        }
        List children = dictVO.getChildren();
        this.buildSortId(children);
        if (V.notEmpty((Collection)children)) {
            this.checkDuplicate(children);
            for (Dictionary dict : children) {
                dict.setParentId((String)((Object)dictVO.getId())).setType(dictVO.getType()).setIsDeletable(dictVO.getIsDeletable()).setIsEditable(dictVO.getIsEditable());
            }
            boolean success = super.createEntities((Collection)children);
            if (!success) {
                log.warn("\u65b0\u5efa\u6570\u636e\u5b57\u5178\u5b50\u9879\u5931\u8d25\uff0c type= {}", (Object)dictVO.getType());
                throw new BusinessException(Status.FAIL_OPERATION, "exception.business.dictionaryService.createDictAndChildren.message", new Object[]{dictVO.getType()});
            }
        }
        return true;
    }

    public List<Dictionary> getDictDefinitionList() {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(Dictionary::getParentId)).or()).eq(Dictionary::getParentId, (Object)"0"))).orderByDesc(AbstractEntity::getId);
        return this.getEntityList((Wrapper)queryWrapper);
    }

    public List<DictionaryVO> getDictDefinitionVOList() {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(Dictionary::getParentId)).or()).eq(Dictionary::getParentId, (Object)"0"));
        return this.getViewObjectList((Wrapper)queryWrapper, null, DictionaryVO.class);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateDictAndChildren(DictionaryVO dictVO) {
        Dictionary oldDictionary = (Dictionary)super.getEntity(dictVO.getId());
        dictVO.setIsDeletable(oldDictionary.getIsDeletable()).setIsEditable(oldDictionary.getIsEditable());
        if (!this.updateEntity(oldDictionary.getItemName(), (Dictionary)dictVO)) {
            log.warn("\u66f4\u65b0\u6570\u636e\u5b57\u5178\u5b9a\u4e49\u5931\u8d25\uff0ctype={}", (Object)dictVO.getType());
            return false;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(Dictionary::getParentId, (Object)dictVO.getId());
        List oldDictList = super.getEntityList((Wrapper)queryWrapper);
        List newDictList = dictVO.getChildren();
        HashSet<String> dictItemIds = new HashSet<String>();
        this.buildSortId(newDictList);
        if (V.notEmpty((Collection)newDictList)) {
            this.checkDuplicate(newDictList);
            for (Dictionary dict : newDictList) {
                dict.setType(dictVO.getType()).setParentId((String)((Object)dictVO.getId())).setIsDeletable(dictVO.getIsDeletable()).setIsEditable(dictVO.getIsEditable());
                if (V.notEmpty((String)((String)((Object)dict.getId())))) {
                    dictItemIds.add((String)((Object)dict.getId()));
                    Optional<Dictionary> oldDictOpt = oldDictList.stream().filter(d -> ((String)((Object)d.getId())).equals(dict.getId())).findFirst();
                    if (!oldDictOpt.isPresent() || this.updateEntity(oldDictOpt.get().getItemName(), dict)) continue;
                    log.warn("\u66f4\u65b0\u5b57\u5178\u5b50\u9879\u5931\u8d25\uff0citemName={}", (Object)dict.getItemName());
                    throw new BusinessException(Status.FAIL_EXCEPTION, "exception.business.dictionaryService.updateItem", new Object[0]);
                }
                if (super.createEntity((Object)dict)) continue;
                log.warn("\u65b0\u5efa\u5b57\u5178\u5b50\u9879\u5931\u8d25\uff0citemName={}", (Object)dict.getItemName());
                throw new BusinessException(Status.FAIL_EXCEPTION, "exception.business.dictionaryService.createItem", new Object[0]);
            }
        }
        if (V.notEmpty((Collection)oldDictList)) {
            for (Dictionary dict : oldDictList) {
                if (dictItemIds.contains(dict.getId()) || super.deleteEntity(dict.getId())) continue;
                log.warn("\u5220\u9664\u5b50\u6570\u636e\u5b57\u5178\u5931\u8d25\uff0citemName={}", (Object)dict.getItemName());
                throw new BusinessException(Status.FAIL_EXCEPTION, "exception.business.dictionaryService.deleteItem", new Object[0]);
            }
        }
        return true;
    }

    private boolean updateEntity(String oldDictItemName, Dictionary newDict) {
        if (this.i18nConfigService != null && V.notEquals((Object)oldDictItemName, (Object)newDict.getItemName())) {
            this.i18nConfigService.updateI18nContent("zh_CN", newDict.getItemNameI18n(), newDict.getItemName());
            log.debug("\u5b57\u5178 {} \u7684\u56fd\u9645\u5316\u4e2d\u6587\u5185\u5bb9\u5df2\u66f4\u6539\u4e3a {}", (Object)oldDictItemName, (Object)newDict.getItemName());
        }
        return super.updateEntity((Object)newDict);
    }

    private void checkDuplicate(List<Dictionary> dictList) {
        HashSet itemNames = new HashSet();
        HashSet itemValues = new HashSet();
        dictList.forEach(dict -> {
            if (itemValues.contains(dict.getItemValue())) {
                throw new BusinessException(Status.FAIL_OPERATION, "exception.business.dictionaryService.repeatItemValue", new Object[]{dict.getItemValue()});
            }
            if (itemNames.contains(dict.getItemName())) {
                throw new BusinessException(Status.FAIL_OPERATION, "exception.business.dictionaryService.repeatItemName", new Object[]{dict.getItemName()});
            }
            itemNames.add(dict.getItemName());
            itemValues.add(dict.getItemValue());
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean deleteDictAndChildren(Serializable id) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(AbstractEntity::getId, (Object)id)).or()).eq(Dictionary::getParentId, (Object)id);
        super.deleteEntities((Wrapper)queryWrapper);
        return true;
    }

    public void bindItemLabel(List voList, String setFieldName, String getFieldName, String type) {
        if (V.isEmpty((Collection)voList)) {
            return;
        }
        List<LabelValue> entityList = this.getLabelValueList(type);
        Map map = BeanUtils.convertToStringKeyObjectMap(entityList, (IGetter[])new IGetter[]{LabelValue::getValue});
        Class fieldType = BeanUtils.getFieldActualType(voList.get(0).getClass(), (String)setFieldName);
        boolean isLabelValueClass = LabelValue.class.equals((Object)fieldType);
        for (Object item : voList) {
            ArrayList<Object> labelList;
            Object value = BeanUtils.getProperty(item, (String)getFieldName);
            if (V.isEmpty((Object)value)) continue;
            if (value instanceof String) {
                LabelValue matchedItem = (LabelValue)map.get((String)value);
                if (matchedItem != null) {
                    if (isLabelValueClass) {
                        BeanUtils.setProperty(item, (String)setFieldName, (Object)matchedItem);
                        continue;
                    }
                    BeanUtils.setProperty(item, (String)setFieldName, (Object)matchedItem.getLabel());
                    continue;
                }
                if (((String)value).contains(",")) {
                    ArrayList<Object> labelList2 = new ArrayList<Object>();
                    String[] stringArray = ((String)value).split(",");
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String key = stringArray[i];
                        LabelValue labelValue = (LabelValue)map.get(key);
                        if (labelValue == null) continue;
                        if (isLabelValueClass) {
                            labelList2.add(labelValue);
                            continue;
                        }
                        labelList2.add(labelValue.getLabel());
                    }
                    if (!V.notEmpty(labelList2)) continue;
                    if (isLabelValueClass) {
                        BeanUtils.setProperty(item, (String)setFieldName, labelList2);
                        continue;
                    }
                    BeanUtils.setProperty(item, (String)setFieldName, (Object)S.join(labelList2));
                    continue;
                }
                log.warn("\u672a\u5339\u914d\u5230\u5b57\u5178\u9009\u9879: {}\uff0c\u5b58\u50a8\u503c: {}", (Object)type, value);
                continue;
            }
            if (value instanceof Collection) {
                labelList = new ArrayList<Object>();
                for (Object key : (Collection)value) {
                    LabelValue labelValue = (LabelValue)map.get((String)key);
                    if (labelValue == null) continue;
                    if (isLabelValueClass) {
                        labelList.add(labelValue);
                        continue;
                    }
                    labelList.add(labelValue.getLabel());
                }
                BeanUtils.setProperty(item, (String)setFieldName, labelList);
                continue;
            }
            if (value.getClass().isArray()) {
                labelList = new ArrayList();
                for (Object key : (Object[])value) {
                    LabelValue labelValue = (LabelValue)map.get((String)key);
                    if (labelValue == null) continue;
                    if (isLabelValueClass) {
                        labelList.add(labelValue);
                        continue;
                    }
                    labelList.add(labelValue.getLabel());
                }
                BeanUtils.setProperty(item, (String)setFieldName, labelList);
                continue;
            }
            log.warn("\u4e0d\u652f\u6301\u7684\u5c5e\u6027\u7c7b\u578b: {}\uff0c\u5b58\u50a8\u503c: {}", (Object)value.getClass().getSimpleName(), value);
        }
    }

    private void buildSortId(List<Dictionary> dictList) {
        if (V.isEmpty(dictList)) {
            return;
        }
        for (int i = 0; i < dictList.size(); ++i) {
            Dictionary dict = dictList.get(i);
            dict.setSortId(Integer.valueOf(i));
        }
    }

    private List<LabelValue> convertToLabelValueList(List<Dictionary> dictList) {
        if (this.i18nConfigService == null) {
            return dictList.stream().map(Dictionary::toLabelValue).collect(Collectors.toList());
        }
        List itemI18nMap = dictList.stream().map(Dictionary::getItemNameI18n).filter(V::notEmpty).collect(Collectors.toList());
        Map i18nKeyValMap = this.i18nConfigService.translate(itemI18nMap);
        ArrayList<LabelValue> items = new ArrayList<LabelValue>(dictList.size());
        for (Dictionary dictionary : dictList) {
            LabelValue item = dictionary.toLabelValue();
            if (i18nKeyValMap.containsKey(dictionary.getItemNameI18n())) {
                item.setLabel((String)i18nKeyValMap.get(dictionary.getItemNameI18n()));
            }
            items.add(item);
        }
        return items;
    }
}

