/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.init;

import com.diboot.core.cache.BaseCacheManager;
import com.diboot.core.cache.DictionaryCacheManager;
import com.diboot.core.cache.DynamicRedisCacheManager;
import com.diboot.core.cache.I18nCacheManager;
import com.diboot.core.config.Cons;
import com.diboot.core.extension.sequence.counter.RedisCacheSeqCounter;
import com.diboot.core.extension.sequence.counter.SeqCounter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Order(value=901)
@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RedisOperations.class})
@ConditionalOnResource(resources={"org/springframework/data/redis"})
public class CoreRedisAutoConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CoreRedisAutoConfig.class);

    public CoreRedisAutoConfig() {
        log.info("\u521d\u59cb\u5316 core \u5185\u6838 Redis \u81ea\u52a8\u914d\u7f6e");
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory connectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        redisTemplate.setKeySerializer((RedisSerializer)stringRedisSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        redisTemplate.setValueSerializer(this.jackson2JsonRedisSerializer());
        redisTemplate.setHashValueSerializer(this.jackson2JsonRedisSerializer());
        redisTemplate.setConnectionFactory(connectionFactory);
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    private Jackson2JsonRedisSerializer<Object> jackson2JsonRedisSerializer() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.activateDefaultTyping(objectMapper.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.NON_FINAL);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.registerModule((Module)new JavaTimeModule());
        SimpleFilterProvider filterProvider = new SimpleFilterProvider().addFilter("rewrite-bean", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"realmNames"}));
        objectMapper.setFilterProvider((FilterProvider)filterProvider);
        return new Jackson2JsonRedisSerializer(objectMapper, Object.class);
    }

    @Bean
    @ConditionalOnMissingBean
    public DictionaryCacheManager dictionaryCacheManager(RedisTemplate redisTemplate) {
        log.info("\u521d\u59cb\u5316 Dictionary Redis\u7f13\u5b58: DynamicRedisCacheManager");
        HashMap<String, Integer> cacheName2ExpireMap = new HashMap<String, Integer>(){
            {
                this.put(Cons.CACHE_NAME_DICTIONARY, 1440);
            }
        };
        DynamicRedisCacheManager redisCacheManager = new DynamicRedisCacheManager(redisTemplate, (Map)cacheName2ExpireMap);
        return new DictionaryCacheManager((BaseCacheManager)redisCacheManager);
    }

    @Bean
    @ConditionalOnMissingBean
    public I18nCacheManager i18nCacheManager(RedisTemplate redisTemplate) {
        log.info("\u521d\u59cb\u5316 I18n Redis\u7f13\u5b58: DynamicRedisCacheManager");
        HashMap<String, Integer> cacheName2ExpireMap = new HashMap<String, Integer>(){
            {
                this.put(Cons.CACHE_NAME_I18N, 1440);
            }
        };
        DynamicRedisCacheManager memoryCacheManager = new DynamicRedisCacheManager(redisTemplate, (Map)cacheName2ExpireMap);
        return new I18nCacheManager((BaseCacheManager)memoryCacheManager);
    }

    @Bean
    @ConditionalOnMissingBean(value={SeqCounter.class})
    public SeqCounter redisCacheSeqCounter(RedisTemplate<String, Object> redisTemplate) {
        log.info("\u521d\u59cb\u5316 \u6d41\u6c34\u53f7\u8ba1\u6570\u5668 Redis\u7f13\u5b58: RedisCacheSeqCounter");
        return new RedisCacheSeqCounter(redisTemplate);
    }
}

