/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.init;

import com.diboot.core.entity.Dictionary;
import com.diboot.core.service.DictionaryService;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.JSON;
import com.diboot.core.util.SqlFileInitializer;
import com.diboot.core.vo.DictionaryVO;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=901)
@Component
@ConditionalOnProperty(prefix="diboot", name={"init-sql"}, havingValue="true")
public class CorePluginInitializer
implements ApplicationRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CorePluginInitializer.class);

    public void run(ApplicationArguments args) throws Exception {
        String initDetectSql = "SELECT id FROM dbt_dictionary WHERE id='0'";
        if (!SqlFileInitializer.checkSqlExecutable((String)initDetectSql)) {
            SqlFileInitializer.initBootstrapSql(this.getClass(), (String)"core");
            this.insertInitData();
            log.info("diboot-core \u521d\u59cb\u5316SQL\u5b8c\u6210.");
        }
    }

    private void insertInitData() {
        DictionaryService dictionaryService = (DictionaryService)ContextHolder.getBean(DictionaryService.class);
        if (dictionaryService != null && !dictionaryService.exists(Dictionary::getType, (Object)"I18N_TYPE")) {
            String[] DICT_INIT_DATA;
            for (String dictJson : DICT_INIT_DATA = new String[]{"{\"type\":\"I18N_TYPE\",\"itemName\":\"\u56fd\u9645\u5316\u914d\u7f6e\u7c7b\u578b\",\"description\":\"\u56fd\u9645\u5316\u914d\u7f6e\u5206\u7c7b\",\"isEditable\":false,\"children\":[{\"itemName\":\"\u7cfb\u7edf\",\"itemNameI18n\":\"Dictionary.I18N_TYPE.System\",\"itemValue\":\"SYSTEM\",\"sortId\":1},{\"itemName\":\"\u81ea\u5b9a\u4e49\",\"itemNameI18n\":\"Dictionary.I18N_TYPE.Custom\",\"itemValue\":\"CUSTOM\",\"sortId\":2}]}"}) {
                DictionaryVO dictVo = (DictionaryVO)JSON.toJavaObject((String)dictJson, DictionaryVO.class);
                dictionaryService.createDictAndChildren(dictVo);
            }
        }
    }
}

