/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.cache;

import com.diboot.core.cache.BaseCacheManager;
import com.diboot.core.config.Cons;
import com.diboot.core.util.V;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nCacheManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(I18nCacheManager.class);
    private BaseCacheManager cacheManager;

    public I18nCacheManager(BaseCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void removeCachedItems(String language) {
        if (this.cacheManager == null) {
            return;
        }
        this.cacheManager.removeCacheObj(Cons.CACHE_NAME_I18N, (Object)language);
    }

    public Map<String, String> getLanguageCached(String language) {
        if (this.cacheManager == null) {
            return null;
        }
        return (Map)this.cacheManager.getCacheObj(Cons.CACHE_NAME_I18N, (Object)language, Map.class);
    }

    public void cacheLanguage(String language, Map<String, String> languageValue) {
        if (this.cacheManager == null) {
            return;
        }
        Map<String, String> languageCached = this.getLanguageCached(language);
        if (V.isEmpty(languageCached)) {
            languageCached = new HashMap<String, String>(255);
        }
        languageCached.putAll(languageValue);
        this.cacheManager.putCacheObj(Cons.CACHE_NAME_I18N, (Object)language, languageCached);
        log.debug("\u8bed\u8a00\u73af\u5883 {} \u7684 {} \u6761\u6570\u636e\u5df2\u7f13\u5b58", (Object)language, (Object)languageValue.size());
    }
}

