/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.icc.oauth.model.v202010.SDK;

import com.dahuatech.hutool.log.Log;
import com.dahuatech.hutool.log.LogFactory;
import com.dahuatech.icc.oauth.exception.BusinessException;
import com.dahuatech.icc.oauth.http.IccClient;
import com.dahuatech.icc.oauth.model.v202010.OauthPublicKeyRequest;
import com.dahuatech.icc.oauth.model.v202010.OauthPublicKeyResponse;
import com.dahuatech.icc.oauth.model.v202010.oSDK.OauthParamConstant;

public class OauthPublicKeySDK {
    private static final Log logger = LogFactory.get();

    public OauthPublicKeyResponse brmKeepAlive(OauthPublicKeyRequest request) {
        OauthPublicKeyResponse response = null;
        try {
            request.valid();
            request.businessValid();
            request.setUrl(request.getOauthConfigBaseInfo().getHttpConfigInfo().getPrefixUrl() + request.getUrl().substring(8));
            response = new IccClient().doAction(request, request.getResponseClass());
        }
        catch (BusinessException businessException) {
            logger.error("\u9274\u6743\u516c\u94a5\uff1a{}", (Throwable)businessException, businessException.getMessage(), new Object[0]);
            response = new OauthPublicKeyResponse();
            response.setCode(businessException.getCode());
            response.setErrMsg(businessException.getErrorMsg());
            response.setArgs(businessException.getArgs());
            response.setSuccess(false);
        }
        catch (Exception e) {
            logger.error("\u9274\u6743\u516c\u94a5\uff1a{}", (Throwable)e, e.getMessage(), new Object[0]);
            response = new OauthPublicKeyResponse();
            response.setErrMsg(OauthParamConstant.SYSTEME_RROR.getErrMsg());
            response.setCode(OauthParamConstant.SYSTEME_RROR.getCode());
            response.setSuccess(false);
        }
        return response;
    }
}

