/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.hutool.json;

import com.dahuatech.hutool.core.convert.ConvertException;
import com.dahuatech.hutool.core.getter.OptNullBasicTypeFromObjectGetter;
import com.dahuatech.hutool.json.JSONArray;
import com.dahuatech.hutool.json.JSONConverter;
import com.dahuatech.hutool.json.JSONNull;
import com.dahuatech.hutool.json.JSONObject;
import com.dahuatech.hutool.json.JSONUtil;

public abstract class JSONGetter<K>
extends OptNullBasicTypeFromObjectGetter<K> {
    public boolean isNull(K key) {
        return JSONNull.NULL.equals(this.getObj(key));
    }

    public String getStrEscaped(K key) {
        return this.getStrEscaped(key, null);
    }

    public String getStrEscaped(K key, String defaultValue) {
        return JSONUtil.escape(this.getStr(key, defaultValue));
    }

    public JSONArray getJSONArray(K key) {
        Object object = this.getObj(key);
        if (null == object) {
            return null;
        }
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        return new JSONArray(object);
    }

    public JSONObject getJSONObject(K key) {
        Object object = this.getObj(key);
        if (null == object) {
            return null;
        }
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        return new JSONObject(object);
    }

    public <T> T getBean(K key, Class<T> beanType) {
        JSONObject obj = this.getJSONObject(key);
        return null == obj ? null : (T)obj.toBean(beanType);
    }

    public <T> T get(K key, Class<T> type) throws ConvertException {
        return this.get(key, type, false);
    }

    public <T> T get(K key, Class<T> type, boolean ignoreError) throws ConvertException {
        Object value = this.getObj(key);
        if (null == value) {
            return null;
        }
        return JSONConverter.jsonConvert(type, value, ignoreError);
    }
}

