/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.hutool.core.lang;

import com.dahuatech.hutool.core.lang.func.Func0;
import java.io.Serializable;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SimpleCache<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<K, V> cache = new WeakHashMap();
    private final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.cacheLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.cacheLock.writeLock();

    public V get(K key) {
        V value;
        this.readLock.lock();
        try {
            value = this.cache.get(key);
        }
        finally {
            this.readLock.unlock();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, Func0<V> supplier) {
        V v;
        block6: {
            v = this.get(key);
            if (null == v && null != supplier) {
                this.writeLock.lock();
                try {
                    v = this.cache.get(key);
                    if (null != v) break block6;
                    try {
                        v = supplier.call();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    this.cache.put(key, v);
                }
                finally {
                    this.writeLock.unlock();
                }
            }
        }
        return v;
    }

    public V put(K key, V value) {
        this.writeLock.lock();
        try {
            this.cache.put(key, value);
        }
        finally {
            this.writeLock.unlock();
        }
        return value;
    }

    public V remove(K key) {
        this.writeLock.lock();
        try {
            V v = this.cache.remove(key);
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void clear() {
        this.writeLock.lock();
        try {
            this.cache.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

