/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.hutool.core.bean.copier;

import com.dahuatech.hutool.core.bean.BeanDesc;
import com.dahuatech.hutool.core.bean.BeanUtil;
import com.dahuatech.hutool.core.bean.copier.CopyOptions;
import com.dahuatech.hutool.core.bean.copier.ValueProvider;
import com.dahuatech.hutool.core.bean.copier.provider.BeanValueProvider;
import com.dahuatech.hutool.core.bean.copier.provider.MapValueProvider;
import com.dahuatech.hutool.core.collection.CollUtil;
import com.dahuatech.hutool.core.convert.Convert;
import com.dahuatech.hutool.core.exceptions.UtilException;
import com.dahuatech.hutool.core.lang.ParameterizedTypeImpl;
import com.dahuatech.hutool.core.lang.copier.Copier;
import com.dahuatech.hutool.core.map.MapUtil;
import com.dahuatech.hutool.core.util.ArrayUtil;
import com.dahuatech.hutool.core.util.ObjectUtil;
import com.dahuatech.hutool.core.util.StrUtil;
import com.dahuatech.hutool.core.util.TypeUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class BeanCopier<T>
implements Copier<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Object source;
    private T dest;
    private Type destType;
    private CopyOptions copyOptions;

    public BeanCopier(Object source, T dest, Type destType, CopyOptions copyOptions) {
        this.source = source;
        this.dest = dest;
        this.destType = destType;
        this.copyOptions = copyOptions;
    }

    public static <T> BeanCopier<T> create(Object source, T dest, CopyOptions copyOptions) {
        return BeanCopier.create(source, dest, dest.getClass(), copyOptions);
    }

    public static <T> BeanCopier<T> create(Object source, T dest, Type destType, CopyOptions copyOptions) {
        return new BeanCopier<T>(source, dest, destType, copyOptions);
    }

    private static String mappingKey(Map<String, String> mapping, String fieldName) {
        if (MapUtil.isEmpty(mapping)) {
            return fieldName;
        }
        return ObjectUtil.defaultIfNull(mapping.get(fieldName), fieldName);
    }

    @Override
    public T copy() {
        if (null != this.source) {
            if (this.source instanceof ValueProvider) {
                this.valueProviderToBean((ValueProvider)this.source, this.dest);
            } else if (this.source instanceof Map) {
                if (this.dest instanceof Map) {
                    this.mapToMap((Map)this.source, (Map)this.dest);
                } else {
                    this.mapToBean((Map)this.source, this.dest);
                }
            } else if (this.dest instanceof Map) {
                this.beanToMap(this.source, (Map)this.dest);
            } else {
                this.beanToBean(this.source, this.dest);
            }
        }
        return this.dest;
    }

    private void beanToBean(Object providerBean, Object destBean) {
        this.valueProviderToBean(new BeanValueProvider(providerBean, this.copyOptions.ignoreCase, this.copyOptions.ignoreError), destBean);
    }

    private void mapToBean(Map<?, ?> map, Object bean) {
        this.valueProviderToBean(new MapValueProvider(map, this.copyOptions.ignoreCase), bean);
    }

    private void mapToMap(Map source, Map dest) {
        if (null != dest && null != source) {
            dest.putAll(source);
        }
    }

    private void beanToMap(Object bean, Map targetMap) {
        Collection<BeanDesc.PropDesc> props = BeanUtil.getBeanDesc(bean.getClass()).getProps();
        HashSet<String> ignoreSet = null != this.copyOptions.ignoreProperties ? CollUtil.newHashSet(this.copyOptions.ignoreProperties) : null;
        CopyOptions copyOptions = this.copyOptions;
        for (BeanDesc.PropDesc prop : props) {
            Object value;
            String key = prop.getFieldName();
            Method getter = prop.getGetter();
            if (null == getter) continue;
            try {
                value = getter.invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                if (copyOptions.ignoreError) continue;
                throw new UtilException(e, "Get value of [{}] error!", prop.getFieldName());
            }
            if (CollUtil.contains(ignoreSet, key) || null == value && copyOptions.ignoreNullValue || bean.equals(value)) continue;
            targetMap.put(BeanCopier.mappingKey(copyOptions.fieldMapping, key), value);
        }
    }

    private void valueProviderToBean(ValueProvider<String> valueProvider, Object bean) {
        if (null == valueProvider) {
            return;
        }
        CopyOptions copyOptions = this.copyOptions;
        Class<?> actualEditable = bean.getClass();
        if (null != copyOptions.editable) {
            if (!copyOptions.editable.isInstance(bean)) {
                throw new IllegalArgumentException(StrUtil.format((CharSequence)"Target class [{}] not assignable to Editable class [{}]", bean.getClass().getName(), copyOptions.editable.getName()));
            }
            actualEditable = copyOptions.editable;
        }
        HashSet<String> ignoreSet = null != copyOptions.ignoreProperties ? CollUtil.newHashSet(copyOptions.ignoreProperties) : null;
        Map<String, String> fieldReverseMapping = copyOptions.getReversedMapping();
        Collection<BeanDesc.PropDesc> props = BeanUtil.getBeanDesc(actualEditable).getProps();
        for (BeanDesc.PropDesc prop : props) {
            Method setterMethod;
            String providerKey;
            String fieldName = prop.getFieldName();
            if (CollUtil.contains(ignoreSet, fieldName) || !valueProvider.containsKey(providerKey = BeanCopier.mappingKey(fieldReverseMapping, fieldName)) || null == (setterMethod = prop.getSetter())) continue;
            Type firstParamType = TypeUtil.getFirstParamType(setterMethod);
            if (firstParamType instanceof ParameterizedType) {
                ParameterizedType tmp = (ParameterizedType)firstParamType;
                Type[] actualTypeArguments = tmp.getActualTypeArguments();
                if (TypeUtil.hasTypeVeriable(actualTypeArguments) && ArrayUtil.isNotEmpty(actualTypeArguments = TypeUtil.getActualTypes(this.destType, setterMethod.getDeclaringClass(), tmp.getActualTypeArguments()))) {
                    firstParamType = new ParameterizedTypeImpl(actualTypeArguments, tmp.getOwnerType(), tmp.getRawType());
                }
            } else if (firstParamType instanceof TypeVariable) {
                firstParamType = TypeUtil.getActualType(this.destType, setterMethod.getDeclaringClass(), firstParamType);
            }
            Object value = valueProvider.value(providerKey, firstParamType);
            if (null == value && copyOptions.ignoreNullValue || bean.equals(value)) continue;
            try {
                Class<?> propClass = prop.getFieldClass();
                if (!propClass.isInstance(value) && null == (value = Convert.convert(propClass, value)) && copyOptions.ignoreNullValue) continue;
                setterMethod.invoke(bean, value);
            }
            catch (Exception e) {
                if (copyOptions.ignoreError) continue;
                throw new UtilException(e, "Inject [{}] error!", prop.getFieldName());
            }
        }
    }
}

