/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.internals;

import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.core.utils.PropertiesUtil;
import com.ctrip.framework.apollo.exceptions.ApolloConfigException;
import com.ctrip.framework.apollo.internals.AbstractConfigFile;
import com.ctrip.framework.apollo.internals.ConfigRepository;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.ctrip.framework.apollo.util.ExceptionUtil;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesConfigFile
extends AbstractConfigFile {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesConfigFile.class);
    protected AtomicReference<String> m_contentCache = new AtomicReference();

    public PropertiesConfigFile(String namespace, ConfigRepository configRepository) {
        super(namespace, configRepository);
    }

    @Override
    protected void update(Properties newProperties) {
        this.m_configProperties.set(newProperties);
        this.m_contentCache.set(null);
    }

    @Override
    public String getContent() {
        if (this.m_contentCache.get() == null) {
            this.m_contentCache.set(this.doGetContent());
        }
        return this.m_contentCache.get();
    }

    String doGetContent() {
        if (!this.hasContent()) {
            return null;
        }
        try {
            return PropertiesUtil.toString((Properties)((Properties)this.m_configProperties.get()));
        }
        catch (Throwable ex) {
            ApolloConfigException exception = new ApolloConfigException(String.format("Parse properties file content failed for namespace: %s, cause: %s", this.m_namespace, ExceptionUtil.getDetailMessage(ex)));
            Tracer.logError((Throwable)exception);
            throw exception;
        }
    }

    @Override
    public boolean hasContent() {
        return this.m_configProperties.get() != null && !((Properties)this.m_configProperties.get()).isEmpty();
    }

    @Override
    public ConfigFileFormat getConfigFileFormat() {
        return ConfigFileFormat.Properties;
    }
}

