/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd.internal.impl;

import com.coreos.jetcd.Maintenance;
import com.coreos.jetcd.api.AlarmRequest;
import com.coreos.jetcd.api.DefragmentRequest;
import com.coreos.jetcd.api.HashKVRequest;
import com.coreos.jetcd.api.MaintenanceGrpc;
import com.coreos.jetcd.api.MoveLeaderRequest;
import com.coreos.jetcd.api.SnapshotRequest;
import com.coreos.jetcd.api.SnapshotResponse;
import com.coreos.jetcd.api.StatusRequest;
import com.coreos.jetcd.common.exception.ErrorCode;
import com.coreos.jetcd.common.exception.EtcdExceptionFactory;
import com.coreos.jetcd.internal.impl.ClientConnectionManager;
import com.coreos.jetcd.internal.impl.Util;
import com.coreos.jetcd.maintenance.AlarmMember;
import com.coreos.jetcd.maintenance.AlarmResponse;
import com.coreos.jetcd.maintenance.AlarmType;
import com.coreos.jetcd.maintenance.DefragmentResponse;
import com.coreos.jetcd.maintenance.HashKVResponse;
import com.coreos.jetcd.maintenance.MoveLeaderResponse;
import com.coreos.jetcd.maintenance.SnapshotReaderResponseWithError;
import com.coreos.jetcd.maintenance.StatusResponse;
import com.google.common.base.Preconditions;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

class MaintenanceImpl
implements Maintenance {
    private final ClientConnectionManager connectionManager;
    private final MaintenanceGrpc.MaintenanceFutureStub stub;
    private final MaintenanceGrpc.MaintenanceStub streamStub;

    MaintenanceImpl(ClientConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.stub = connectionManager.newStub(MaintenanceGrpc::newFutureStub);
        this.streamStub = connectionManager.newStub(MaintenanceGrpc::newStub);
    }

    @Override
    public CompletableFuture<AlarmResponse> listAlarms() {
        AlarmRequest alarmRequest = AlarmRequest.newBuilder().setAlarm(com.coreos.jetcd.api.AlarmType.NONE).setAction(AlarmRequest.AlarmAction.GET).setMemberID(0L).build();
        return Util.toCompletableFuture(this.stub.alarm(alarmRequest), AlarmResponse::new, this.connectionManager.getExecutorService());
    }

    @Override
    public CompletableFuture<AlarmResponse> alarmDisarm(AlarmMember member) {
        Preconditions.checkArgument((member.getMemberId() != 0L ? 1 : 0) != 0, (Object)"the member id can not be 0");
        Preconditions.checkArgument((member.getAlarmType() != AlarmType.NONE ? 1 : 0) != 0, (Object)"alarm type can not be NONE");
        AlarmRequest alarmRequest = AlarmRequest.newBuilder().setAlarm(com.coreos.jetcd.api.AlarmType.NOSPACE).setAction(AlarmRequest.AlarmAction.DEACTIVATE).setMemberID(member.getMemberId()).build();
        return Util.toCompletableFuture(this.stub.alarm(alarmRequest), AlarmResponse::new, this.connectionManager.getExecutorService());
    }

    @Override
    public CompletableFuture<DefragmentResponse> defragmentMember(String endpoint) {
        return this.connectionManager.withNewChannel(endpoint, MaintenanceGrpc::newFutureStub, stub -> Util.toCompletableFuture(stub.defragment(DefragmentRequest.getDefaultInstance()), DefragmentResponse::new, this.connectionManager.getExecutorService()));
    }

    @Override
    public CompletableFuture<StatusResponse> statusMember(String endpoint) {
        return this.connectionManager.withNewChannel(endpoint, MaintenanceGrpc::newFutureStub, stub -> Util.toCompletableFuture(stub.status(StatusRequest.getDefaultInstance()), StatusResponse::new, this.connectionManager.getExecutorService()));
    }

    @Override
    public CompletableFuture<HashKVResponse> hashKV(String endpoint, long rev) {
        return this.connectionManager.withNewChannel(endpoint, MaintenanceGrpc::newFutureStub, stub -> Util.toCompletableFuture(stub.hashKV(HashKVRequest.newBuilder().setRevision(rev).build()), HashKVResponse::new, this.connectionManager.getExecutorService()));
    }

    @Override
    public Maintenance.Snapshot snapshot() {
        SnapshotImpl snapshot = new SnapshotImpl();
        this.streamStub.snapshot(SnapshotRequest.getDefaultInstance(), (StreamObserver<SnapshotResponse>)snapshot.getSnapshotObserver());
        return snapshot;
    }

    @Override
    public CompletableFuture<MoveLeaderResponse> moveLeader(long transfereeID) {
        return Util.toCompletableFuture(this.stub.moveLeader(MoveLeaderRequest.newBuilder().setTargetID(transfereeID).build()), MoveLeaderResponse::new, this.connectionManager.getExecutorService());
    }

    static class SnapshotImpl
    implements Maintenance.Snapshot {
        private final SnapshotResponse endOfStreamResponse = SnapshotResponse.newBuilder().setRemainingBytes(-1L).build();
        private final Object closeLock = new Object();
        private StreamObserver<SnapshotResponse> snapshotObserver;
        private ExecutorService executorService = Executors.newFixedThreadPool(2);
        private BlockingQueue<SnapshotReaderResponseWithError> snapshotResponseBlockingQueue = new LinkedBlockingQueue<SnapshotReaderResponseWithError>();
        private boolean closed = false;
        private boolean writeOnce = false;

        SnapshotImpl() {
            this.snapshotObserver = this.createSnapshotObserver();
        }

        private StreamObserver<SnapshotResponse> getSnapshotObserver() {
            return this.snapshotObserver;
        }

        private StreamObserver<SnapshotResponse> createSnapshotObserver() {
            return new StreamObserver<SnapshotResponse>(){

                public void onNext(SnapshotResponse snapshotResponse) {
                    snapshotResponseBlockingQueue.add(new SnapshotReaderResponseWithError(snapshotResponse));
                }

                public void onError(Throwable throwable) {
                    snapshotResponseBlockingQueue.add(new SnapshotReaderResponseWithError(EtcdExceptionFactory.toEtcdException(throwable)));
                }

                public void onCompleted() {
                    snapshotResponseBlockingQueue.add(new SnapshotReaderResponseWithError(endOfStreamResponse));
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isClosed() {
            Object object = this.closeLock;
            synchronized (object) {
                return this.closed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.closeLock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            this.snapshotObserver.onCompleted();
            this.snapshotObserver = null;
            this.snapshotResponseBlockingQueue.clear();
            this.executorService.shutdownNow();
            try {
                this.executorService.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void write(OutputStream os) throws IOException, InterruptedException {
            Preconditions.checkNotNull((Object)os);
            if (this.isClosed()) {
                throw EtcdExceptionFactory.newClosedSnapshotException();
            }
            if (this.writeOnce) {
                throw new IOException(EtcdExceptionFactory.newEtcdException(ErrorCode.INTERNAL, "write is called more than once"));
            }
            this.writeOnce = true;
            Future<Integer> done = this.executorService.submit(() -> {
                while (true) {
                    SnapshotReaderResponseWithError snapshotReaderResponseWithError = this.snapshotResponseBlockingQueue.take();
                    if (snapshotReaderResponseWithError.error != null) {
                        throw snapshotReaderResponseWithError.error;
                    }
                    SnapshotResponse snapshotResponse = snapshotReaderResponseWithError.snapshotResponse;
                    if (snapshotResponse.getRemainingBytes() == -1L) {
                        return -1;
                    }
                    os.write(snapshotResponse.getBlob().toByteArray());
                }
            });
            try {
                done.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw e;
            }
            catch (ExecutionException e) {
                Object object = this.closeLock;
                synchronized (object) {
                    if (this.isClosed()) {
                        throw EtcdExceptionFactory.newClosedSnapshotException();
                    }
                }
                throw new IOException(EtcdExceptionFactory.toEtcdException(e));
            }
            catch (RejectedExecutionException e) {
                throw EtcdExceptionFactory.newClosedSnapshotException();
            }
        }
    }
}

