/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd.internal.impl;

import com.coreos.jetcd.KV;
import com.coreos.jetcd.Txn;
import com.coreos.jetcd.api.CompactionRequest;
import com.coreos.jetcd.api.DeleteRangeRequest;
import com.coreos.jetcd.api.KVGrpc;
import com.coreos.jetcd.api.PutRequest;
import com.coreos.jetcd.api.RangeRequest;
import com.coreos.jetcd.api.TxnRequest;
import com.coreos.jetcd.data.ByteSequence;
import com.coreos.jetcd.internal.impl.ClientConnectionManager;
import com.coreos.jetcd.internal.impl.Util;
import com.coreos.jetcd.kv.CompactResponse;
import com.coreos.jetcd.kv.DeleteResponse;
import com.coreos.jetcd.kv.GetResponse;
import com.coreos.jetcd.kv.PutResponse;
import com.coreos.jetcd.kv.TxnResponse;
import com.coreos.jetcd.op.TxnImpl;
import com.coreos.jetcd.options.CompactOption;
import com.coreos.jetcd.options.DeleteOption;
import com.coreos.jetcd.options.GetOption;
import com.coreos.jetcd.options.OptionsUtil;
import com.coreos.jetcd.options.PutOption;
import com.google.common.base.Preconditions;
import java.util.concurrent.CompletableFuture;

class KVImpl
implements KV {
    private final ClientConnectionManager connectionManager;
    private final KVGrpc.KVFutureStub stub;

    KVImpl(ClientConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.stub = connectionManager.newStub(KVGrpc::newFutureStub);
    }

    @Override
    public CompletableFuture<PutResponse> put(ByteSequence key, ByteSequence value) {
        return this.put(key, value, PutOption.DEFAULT);
    }

    @Override
    public CompletableFuture<PutResponse> put(ByteSequence key, ByteSequence value, PutOption option) {
        Preconditions.checkNotNull((Object)key, (Object)"key should not be null");
        Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
        Preconditions.checkNotNull((Object)option, (Object)"option should not be null");
        PutRequest request = PutRequest.newBuilder().setKey(Util.byteStringFromByteSequence(key)).setValue(Util.byteStringFromByteSequence(value)).setLease(option.getLeaseId()).setPrevKv(option.getPrevKV()).build();
        return Util.toCompletableFutureWithRetry(() -> this.stub.put(request), PutResponse::new, Util::isRetriable, this.connectionManager.getExecutorService());
    }

    @Override
    public CompletableFuture<GetResponse> get(ByteSequence key) {
        return this.get(key, GetOption.DEFAULT);
    }

    @Override
    public CompletableFuture<GetResponse> get(ByteSequence key, GetOption option) {
        Preconditions.checkNotNull((Object)key, (Object)"key should not be null");
        Preconditions.checkNotNull((Object)option, (Object)"option should not be null");
        RangeRequest.Builder builder = RangeRequest.newBuilder().setKey(Util.byteStringFromByteSequence(key)).setCountOnly(option.isCountOnly()).setLimit(option.getLimit()).setRevision(option.getRevision()).setKeysOnly(option.isKeysOnly()).setSerializable(option.isSerializable()).setSortOrder(OptionsUtil.toRangeRequestSortOrder(option.getSortOrder())).setSortTarget(OptionsUtil.toRangeRequestSortTarget(option.getSortField()));
        option.getEndKey().ifPresent(endKey -> builder.setRangeEnd(Util.byteStringFromByteSequence(endKey)));
        RangeRequest request = builder.build();
        return Util.toCompletableFutureWithRetry(() -> this.stub.range(request), GetResponse::new, Util::isRetriable, this.connectionManager.getExecutorService());
    }

    @Override
    public CompletableFuture<DeleteResponse> delete(ByteSequence key) {
        return this.delete(key, DeleteOption.DEFAULT);
    }

    @Override
    public CompletableFuture<DeleteResponse> delete(ByteSequence key, DeleteOption option) {
        Preconditions.checkNotNull((Object)key, (Object)"key should not be null");
        Preconditions.checkNotNull((Object)option, (Object)"option should not be null");
        DeleteRangeRequest.Builder builder = DeleteRangeRequest.newBuilder().setKey(Util.byteStringFromByteSequence(key)).setPrevKv(option.isPrevKV());
        option.getEndKey().ifPresent(endKey -> builder.setRangeEnd(Util.byteStringFromByteSequence(endKey)));
        DeleteRangeRequest request = builder.build();
        return Util.toCompletableFutureWithRetry(() -> this.stub.deleteRange(request), DeleteResponse::new, Util::isRetriable, this.connectionManager.getExecutorService());
    }

    @Override
    public CompletableFuture<CompactResponse> compact(long rev) {
        return this.compact(rev, CompactOption.DEFAULT);
    }

    @Override
    public CompletableFuture<CompactResponse> compact(long rev, CompactOption option) {
        Preconditions.checkNotNull((Object)option, (Object)"option should not be null");
        CompactionRequest request = CompactionRequest.newBuilder().setRevision(rev).setPhysical(option.isPhysical()).build();
        return Util.toCompletableFutureWithRetry(() -> this.stub.compact(request), CompactResponse::new, Util::isRetriable, this.connectionManager.getExecutorService());
    }

    @Override
    public Txn txn() {
        return TxnImpl.newTxn(request -> Util.toCompletableFutureWithRetry(() -> this.stub.txn((TxnRequest)request), TxnResponse::new, Util::isRetriable, this.connectionManager.getExecutorService()));
    }
}

