/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd.internal.impl;

import com.coreos.jetcd.ClientBuilder;
import com.coreos.jetcd.api.AuthGrpc;
import com.coreos.jetcd.api.AuthenticateRequest;
import com.coreos.jetcd.api.AuthenticateResponse;
import com.coreos.jetcd.common.exception.EtcdExceptionFactory;
import com.coreos.jetcd.data.ByteSequence;
import com.coreos.jetcd.internal.impl.Util;
import com.coreos.jetcd.resolver.SmartNameResolverFactory;
import com.coreos.jetcd.resolver.URIResolverLoader;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.AbstractStub;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

final class ClientConnectionManager {
    private static final Metadata.Key<String> TOKEN = Metadata.Key.of((String)"token", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final ClientBuilder builder;
    private final AtomicReference<ManagedChannel> channelRef;
    private final AtomicReference<Optional<String>> tokenRef;
    private final ExecutorService executorService;

    ClientConnectionManager(ClientBuilder builder) {
        this(builder, Executors.newCachedThreadPool(), null);
    }

    ClientConnectionManager(ClientBuilder builder, ExecutorService executorService) {
        this(builder, executorService, null);
    }

    ClientConnectionManager(ClientBuilder builder, ManagedChannel channel) {
        this(builder, Executors.newCachedThreadPool(), channel);
    }

    ClientConnectionManager(ClientBuilder builder, ExecutorService executorService, ManagedChannel channel) {
        this.builder = builder;
        this.channelRef = new AtomicReference<ManagedChannel>(channel);
        this.tokenRef = new AtomicReference();
        this.executorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManagedChannel getChannel() {
        ManagedChannel managedChannel = this.channelRef.get();
        if (managedChannel == null) {
            AtomicReference<ManagedChannel> atomicReference = this.channelRef;
            synchronized (atomicReference) {
                managedChannel = this.channelRef.get();
                if (managedChannel == null) {
                    managedChannel = this.defaultChannelBuilder().build();
                    this.channelRef.lazySet(managedChannel);
                }
            }
        }
        return managedChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<String> getToken(Channel channel) {
        Optional<String> tk = this.tokenRef.get();
        if (tk == null) {
            AtomicReference<Optional<String>> atomicReference = this.tokenRef;
            synchronized (atomicReference) {
                tk = this.tokenRef.get();
                if (tk == null) {
                    tk = this.generateToken(channel);
                    this.tokenRef.lazySet(tk);
                }
            }
        }
        return tk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshToken(Channel channel) {
        AtomicReference<Optional<String>> atomicReference = this.tokenRef;
        synchronized (atomicReference) {
            Optional<String> tk = this.generateToken(channel);
            this.tokenRef.lazySet(tk);
        }
    }

    ExecutorService getExecutorService() {
        return this.executorService;
    }

    <T extends AbstractStub<T>> T newStub(Function<ManagedChannel, T> supplier) {
        return (T)((AbstractStub)supplier.apply(this.getChannel()));
    }

    synchronized void close() {
        ManagedChannel channel = this.channelRef.get();
        if (channel != null) {
            channel.shutdown();
        }
        this.executorService.shutdownNow();
    }

    <T extends AbstractStub<T>, R> CompletableFuture<R> withNewChannel(String endpoint, Function<ManagedChannel, T> stubCustomizer, Function<T, CompletableFuture<R>> stubConsumer) {
        ManagedChannel channel = this.defaultChannelBuilder().nameResolverFactory(SmartNameResolverFactory.forEndpoints(Optional.ofNullable(this.builder.authority()).orElse("etcd"), Collections.singleton(endpoint), Optional.ofNullable(this.builder.uriResolverLoader()).orElseGet(URIResolverLoader::defaultLoader))).build();
        try {
            AbstractStub stub = (AbstractStub)stubCustomizer.apply(channel);
            return stubConsumer.apply(stub).whenComplete((r, t) -> channel.shutdown());
        }
        catch (Exception e) {
            channel.shutdown();
            throw EtcdExceptionFactory.toEtcdException(e);
        }
    }

    private ManagedChannelBuilder<?> defaultChannelBuilder() {
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forTarget((String)"etcd");
        if (this.builder.sslContext() != null) {
            channelBuilder.sslContext(this.builder.sslContext());
        } else {
            channelBuilder.usePlaintext(true);
        }
        channelBuilder.nameResolverFactory(SmartNameResolverFactory.forEndpoints(Optional.ofNullable(this.builder.authority()).orElse("etcd"), this.builder.endpoints(), Optional.ofNullable(this.builder.uriResolverLoader()).orElseGet(URIResolverLoader::defaultLoader)));
        if (this.builder.loadBalancerFactory() != null) {
            channelBuilder.loadBalancerFactory(this.builder.loadBalancerFactory());
        }
        channelBuilder.intercept(new ClientInterceptor[]{new AuthTokenInterceptor()});
        return channelBuilder;
    }

    private ListenableFuture<AuthenticateResponse> authenticate(Channel channel, ByteSequence username, ByteSequence password) {
        ByteString user = Util.byteStringFromByteSequence(username);
        ByteString pass = Util.byteStringFromByteSequence(password);
        Preconditions.checkArgument((!user.isEmpty() ? 1 : 0) != 0, (Object)"username can not be empty.");
        Preconditions.checkArgument((!pass.isEmpty() ? 1 : 0) != 0, (Object)"password can not be empty.");
        return AuthGrpc.newFutureStub(channel).authenticate(AuthenticateRequest.newBuilder().setNameBytes(user).setPasswordBytes(pass).build());
    }

    private Optional<String> generateToken(Channel channel) {
        if (this.builder.user() != null && this.builder.password() != null) {
            try {
                return Optional.of(((AuthenticateResponse)this.authenticate(channel, this.builder.user(), this.builder.password()).get()).getToken());
            }
            catch (InterruptedException ite) {
                throw EtcdExceptionFactory.handleInterrupt(ite);
            }
            catch (ExecutionException exee) {
                throw EtcdExceptionFactory.toEtcdException(exee);
            }
        }
        return Optional.empty();
    }

    private class AuthTokenInterceptor
    implements ClientInterceptor {
        private AuthTokenInterceptor() {
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, final Channel next) {
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    ClientConnectionManager.this.getToken(next).ifPresent(t -> headers.put(TOKEN, t));
                    super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        public void onClose(Status status, Metadata trailers) {
                            if (Util.isInvalidTokenError(status)) {
                                try {
                                    ClientConnectionManager.this.refreshToken(next);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }
            };
        }
    }
}

