/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd.data;

import com.google.protobuf.ByteString;
import java.io.UnsupportedEncodingException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class ByteSequence {
    private final int hashVal;
    private final ByteString byteString;

    public ByteSequence(byte[] source) {
        this.hashVal = this.calcHashCore(source);
        this.byteString = this.toByteString(source);
    }

    protected ByteSequence(ByteString byteString) {
        this(byteString.toByteArray());
    }

    public ByteSequence(String string) {
        this(string.getBytes());
    }

    public ByteSequence(CharBuffer charBuffer) {
        this(String.valueOf(charBuffer.array()));
    }

    public ByteSequence(CharSequence charSequence) {
        this(CharBuffer.wrap(charSequence));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ByteSequence) {
            ByteSequence other = (ByteSequence)obj;
            if (other.hashCode() != this.hashCode()) {
                return false;
            }
            return this.byteString.equals((Object)other.byteString);
        }
        return false;
    }

    public ByteString getByteString() {
        return this.byteString;
    }

    private ByteString toByteString(byte[] bytes) {
        return ByteString.copyFrom((byte[])bytes);
    }

    private int calcHashCore(byte[] bytes) {
        int result = 0;
        for (int i = 0; i < bytes.length; ++i) {
            result = 31 * result + bytes[i];
        }
        return result;
    }

    public int hashCode() {
        return this.hashVal;
    }

    public String toStringUtf8() {
        return this.byteString.toStringUtf8();
    }

    public String toString(Charset charset) {
        return this.byteString.toString(charset);
    }

    public String toString(String charsetName) throws UnsupportedEncodingException {
        return this.byteString.toString(charsetName);
    }

    public byte[] getBytes() {
        return this.byteString.toByteArray();
    }

    public static ByteSequence fromString(String string) {
        return new ByteSequence(string);
    }

    public static ByteSequence fromCharSequence(CharSequence charSequence) {
        return new ByteSequence(charSequence);
    }

    public static ByteSequence fromCharBuffer(CharBuffer charBuffer) {
        return new ByteSequence(charBuffer);
    }

    public static ByteSequence fromByteString(ByteString byteString) {
        return new ByteSequence(byteString);
    }

    public static ByteSequence fromBytes(byte[] bytes) {
        return new ByteSequence(bytes);
    }
}

