/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tm.core.storage.redis;

import com.codingapi.txlcn.common.exception.FastStorageException;
import com.codingapi.txlcn.common.util.ApplicationInformation;
import com.codingapi.txlcn.tm.cluster.TMProperties;
import com.codingapi.txlcn.tm.config.TxManagerConfig;
import com.codingapi.txlcn.tm.core.storage.FastStorage;
import com.codingapi.txlcn.tm.core.storage.LockValue;
import com.codingapi.txlcn.tm.core.storage.TransactionUnit;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisStorage
implements FastStorage {
    private static final Logger log = LoggerFactory.getLogger(RedisStorage.class);
    private static final String REDIS_GROUP_PREFIX = "tm:group:";
    private static final String REDIS_GROUP_STATE = "tm:group:transactionState:";
    private static final String REDIS_TOKEN_PREFIX = "tm.token";
    private static final String REDIS_TM_LIST = "tm.instances";
    private static final String REDIS_MACHINE_ID_MAP_PREFIX = "tm.machine.id.gen:";
    private RedisTemplate<String, Object> redisTemplate;
    private StringRedisTemplate stringRedisTemplate;
    private TxManagerConfig managerConfig;
    private static final String GLOBAL_CONTEXT = "root";
    private static final String GLOBAL_LOCK_ID = "global.lock";

    public RedisStorage() {
    }

    public RedisStorage(RedisTemplate<String, Object> redisTemplate, StringRedisTemplate stringRedisTemplate, TxManagerConfig managerConfig) {
        this.redisTemplate = redisTemplate;
        this.managerConfig = managerConfig;
        this.stringRedisTemplate = stringRedisTemplate;
    }

    @Override
    public void initGroup(String groupId) {
        this.redisTemplate.opsForHash().put((Object)(REDIS_GROUP_PREFIX + groupId), (Object)GLOBAL_CONTEXT, (Object)"");
        this.redisTemplate.expire((Object)(REDIS_GROUP_PREFIX + groupId), this.managerConfig.getDtxTime() + 10000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean containsGroup(String groupId) {
        return Optional.ofNullable(this.redisTemplate.hasKey((Object)(REDIS_GROUP_PREFIX + groupId))).orElse(false);
    }

    @Override
    public List<TransactionUnit> findTransactionUnitsFromGroup(String groupId) throws FastStorageException {
        Map units = this.redisTemplate.opsForHash().entries((Object)(REDIS_GROUP_PREFIX + groupId));
        return units.entrySet().stream().filter(objectObjectEntry -> !objectObjectEntry.getKey().equals(GLOBAL_CONTEXT)).map(objectObjectEntry -> (TransactionUnit)objectObjectEntry.getValue()).collect(Collectors.toList());
    }

    @Override
    public void saveTransactionUnitToGroup(String groupId, TransactionUnit transactionUnit) throws FastStorageException {
        if (Optional.ofNullable(this.redisTemplate.hasKey((Object)(REDIS_GROUP_PREFIX + groupId))).orElse(false).booleanValue()) {
            this.redisTemplate.opsForHash().put((Object)(REDIS_GROUP_PREFIX + groupId), (Object)transactionUnit.getUnitId(), (Object)transactionUnit);
            return;
        }
        throw new FastStorageException("attempts to the non-existent transaction group " + groupId, 101);
    }

    @Override
    public void clearGroup(String groupId) {
        log.debug("remove group:{} from redis.", (Object)groupId);
        this.redisTemplate.delete((Object)(REDIS_GROUP_PREFIX + groupId));
    }

    @Override
    public void saveTransactionState(String groupId, int state) throws FastStorageException {
        this.redisTemplate.opsForValue().set((Object)(REDIS_GROUP_STATE + groupId), (Object)String.valueOf(state));
        this.redisTemplate.expire((Object)(REDIS_GROUP_STATE + groupId), this.managerConfig.getDtxTime() + 10000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public int getTransactionState(String groupId) throws FastStorageException {
        Object state = this.redisTemplate.opsForValue().get((Object)(REDIS_GROUP_STATE + groupId));
        if (Objects.isNull(state)) {
            return -1;
        }
        try {
            return Integer.valueOf(state.toString());
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public void acquireLocks(String contextId, Set<String> locks, LockValue lockValue) throws FastStorageException {
        if (Objects.isNull(locks) || locks.isEmpty()) {
            return;
        }
        Map<String, LockValue> lockIds = locks.stream().collect(Collectors.toMap(lock -> contextId + lock, lock -> lockValue));
        String firstLockId = contextId + new ArrayList<String>(locks).get(0);
        Boolean result = this.redisTemplate.opsForValue().multiSetIfAbsent(lockIds);
        if (!Optional.ofNullable(result).orElse(false).booleanValue()) {
            LockValue hasLockValue = (LockValue)this.redisTemplate.opsForValue().get((Object)firstLockId);
            if (Objects.isNull(hasLockValue)) {
                throw new FastStorageException("acquire locks fail.", 201);
            }
            if (!(!Objects.isNull(lockValue.getGroupId()) && lockValue.getGroupId().equals(hasLockValue.getGroupId()) || hasLockValue.getLockType() != 1 && lockValue.getLockType() == 2)) {
                throw new FastStorageException("acquire locks fail.", 201);
            }
            this.redisTemplate.opsForValue().multiSet(lockIds);
        }
        lockIds.forEach((k, v) -> this.redisTemplate.expire(k, this.managerConfig.getDtxTime(), TimeUnit.MILLISECONDS));
    }

    @Override
    public void releaseLocks(String cate, Set<String> locks) {
        this.redisTemplate.delete((Collection)locks.stream().map(lock -> cate + lock).collect(Collectors.toSet()));
    }

    @Override
    public void saveToken(String token) {
        Objects.requireNonNull(token);
        this.redisTemplate.opsForList().leftPush((Object)REDIS_TOKEN_PREFIX, (Object)token);
        this.redisTemplate.expire((Object)REDIS_TOKEN_PREFIX, 20L, TimeUnit.MINUTES);
        Long size = this.redisTemplate.opsForList().size((Object)REDIS_TOKEN_PREFIX);
        if (Objects.nonNull(size) && size > 3L) {
            this.redisTemplate.opsForList().rightPop((Object)REDIS_TOKEN_PREFIX);
        }
    }

    @Override
    public List<String> findTokens() {
        Long size = this.redisTemplate.opsForList().size((Object)REDIS_TOKEN_PREFIX);
        if (Objects.isNull(size)) {
            return Collections.emptyList();
        }
        return Objects.requireNonNull(this.redisTemplate.opsForList().range((Object)REDIS_TOKEN_PREFIX, 0L, size.longValue())).stream().map(Object::toString).collect(Collectors.toList());
    }

    @Override
    public void removeToken(String token) {
        this.redisTemplate.delete((Object)REDIS_TOKEN_PREFIX);
    }

    @Override
    public void saveTMProperties(TMProperties tmProperties) {
        Objects.requireNonNull(tmProperties);
        this.stringRedisTemplate.opsForHash().put((Object)REDIS_TM_LIST, (Object)(tmProperties.getHost() + ":" + tmProperties.getTransactionPort()), (Object)String.valueOf(tmProperties.getHttpPort()));
    }

    @Override
    public List<TMProperties> findTMProperties() {
        return this.stringRedisTemplate.opsForHash().entries((Object)REDIS_TM_LIST).entrySet().stream().map(entry -> {
            String[] args = ApplicationInformation.splitAddress((String)entry.getKey().toString());
            TMProperties tmProperties = new TMProperties();
            tmProperties.setHost(args[0]);
            tmProperties.setTransactionPort(Integer.valueOf(args[1]));
            tmProperties.setHttpPort(Integer.parseInt(entry.getValue().toString()));
            return tmProperties;
        }).collect(Collectors.toList());
    }

    @Override
    public void removeTMProperties(String host, int transactionPort) {
        Objects.requireNonNull(host);
        this.redisTemplate.opsForHash().delete((Object)REDIS_TM_LIST, new Object[]{host + ":" + transactionPort});
        log.debug("removed TM {}:{}", (Object)host, (Object)transactionPort);
    }

    private void acquireGlobalXLock() {
        LockValue lockValue = new LockValue();
        lockValue.setLockType(1);
        while (true) {
            try {
                this.acquireLocks(GLOBAL_CONTEXT, Sets.newHashSet((Object[])new String[]{GLOBAL_LOCK_ID}), lockValue);
            }
            catch (FastStorageException fastStorageException) {
                continue;
            }
            break;
        }
    }

    private void releaseGlobalXLock() {
        this.releaseLocks(GLOBAL_CONTEXT, Sets.newHashSet((Object[])new String[]{GLOBAL_LOCK_ID}));
    }

    @Override
    public long acquireMachineId(long machineMaxSize, long timeout) throws FastStorageException {
        try {
            this.acquireGlobalXLock();
            this.stringRedisTemplate.opsForValue().setIfAbsent((Object)"tm.machine.id.gen:cur_id", (Object)"-1");
            int i = 0;
            while ((long)i < machineMaxSize) {
                long curId = Objects.requireNonNull(this.stringRedisTemplate.opsForValue().increment((Object)"tm.machine.id.gen:cur_id", 1L));
                if (curId > machineMaxSize) {
                    this.stringRedisTemplate.opsForValue().set((Object)"tm.machine.id.gen:cur_id", (Object)"0");
                    curId = 0L;
                }
                if (!Optional.ofNullable(this.stringRedisTemplate.hasKey((Object)(REDIS_MACHINE_ID_MAP_PREFIX + curId))).orElse(true).booleanValue()) {
                    this.stringRedisTemplate.opsForValue().set((Object)(REDIS_MACHINE_ID_MAP_PREFIX + curId), (Object)"", timeout, TimeUnit.MILLISECONDS);
                    long l = curId;
                    return l;
                }
                ++i;
            }
            throw new FastStorageException("non can used machine id", 301);
        }
        finally {
            this.releaseGlobalXLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshMachines(long timeout, long ... machines) {
        try {
            this.stringRedisTemplate.setEnableTransactionSupport(true);
            this.stringRedisTemplate.multi();
            for (long mac : machines) {
                this.stringRedisTemplate.opsForValue().set((Object)(REDIS_MACHINE_ID_MAP_PREFIX + mac), (Object)"", timeout, TimeUnit.MILLISECONDS);
            }
            this.stringRedisTemplate.exec();
        }
        catch (Throwable e) {
            this.stringRedisTemplate.discard();
        }
        finally {
            this.stringRedisTemplate.setEnableTransactionSupport(false);
        }
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }

    public TxManagerConfig getManagerConfig() {
        return this.managerConfig;
    }

    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setStringRedisTemplate(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    public void setManagerConfig(TxManagerConfig managerConfig) {
        this.managerConfig = managerConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisStorage)) {
            return false;
        }
        RedisStorage other = (RedisStorage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RedisTemplate<String, Object> this$redisTemplate = this.getRedisTemplate();
        RedisTemplate<String, Object> other$redisTemplate = other.getRedisTemplate();
        if (this$redisTemplate == null ? other$redisTemplate != null : !this$redisTemplate.equals(other$redisTemplate)) {
            return false;
        }
        StringRedisTemplate this$stringRedisTemplate = this.getStringRedisTemplate();
        StringRedisTemplate other$stringRedisTemplate = other.getStringRedisTemplate();
        if (this$stringRedisTemplate == null ? other$stringRedisTemplate != null : !this$stringRedisTemplate.equals(other$stringRedisTemplate)) {
            return false;
        }
        TxManagerConfig this$managerConfig = this.getManagerConfig();
        TxManagerConfig other$managerConfig = other.getManagerConfig();
        return !(this$managerConfig == null ? other$managerConfig != null : !((Object)this$managerConfig).equals(other$managerConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisStorage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RedisTemplate<String, Object> $redisTemplate = this.getRedisTemplate();
        result = result * 59 + ($redisTemplate == null ? 43 : $redisTemplate.hashCode());
        StringRedisTemplate $stringRedisTemplate = this.getStringRedisTemplate();
        result = result * 59 + ($stringRedisTemplate == null ? 43 : $stringRedisTemplate.hashCode());
        TxManagerConfig $managerConfig = this.getManagerConfig();
        result = result * 59 + ($managerConfig == null ? 43 : ((Object)$managerConfig).hashCode());
        return result;
    }

    public String toString() {
        return "RedisStorage(redisTemplate=" + this.getRedisTemplate() + ", stringRedisTemplate=" + this.getStringRedisTemplate() + ", managerConfig=" + this.getManagerConfig() + ")";
    }
}

