/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.data.ClickHouseObjectValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;

public class ClickHouseMapValue
extends ClickHouseObjectValue<Map<?, ?>> {
    private static final String DEFAULT_STRING_KEY = "1";
    private static final String DEFAULT_UUID_KEY = "00000000-0000-0000-0000-000000000000";
    private final Class<?> keyType;
    private final Class<?> valueType;

    public static ClickHouseMapValue ofEmpty(Class<?> keyType, Class<?> valueType) {
        return new ClickHouseMapValue(Collections.emptyMap(), keyType, valueType);
    }

    public static ClickHouseMapValue of(Map<?, ?> value, Class<?> keyType, Class<?> valueType) {
        return ClickHouseMapValue.of(null, value, keyType, valueType);
    }

    public static ClickHouseMapValue of(ClickHouseValue ref, Map<?, ?> value, Class<?> keyType, Class<?> valueType) {
        return ref instanceof ClickHouseMapValue ? ((ClickHouseMapValue)ref).set(value) : new ClickHouseMapValue(value, keyType, valueType);
    }

    protected ClickHouseMapValue(Map<?, ?> value, Class<?> keyType, Class<?> valueType) {
        super(value);
        this.keyType = ClickHouseChecker.nonNull(keyType, "keyType");
        this.valueType = ClickHouseChecker.nonNull(valueType, "valueType");
    }

    protected Object getDefaultKey() {
        Object key;
        if (this.keyType == String.class) {
            key = DEFAULT_STRING_KEY;
        } else if (this.keyType == UUID.class) {
            key = DEFAULT_UUID_KEY;
        } else if (this.keyType == Byte.class) {
            key = (byte)1;
        } else if (this.keyType == Short.class) {
            key = (short)1;
        } else if (this.keyType == Integer.class) {
            key = 1;
        } else if (this.keyType == Long.class) {
            key = 1L;
        } else if (this.keyType == Float.class) {
            key = Float.valueOf(1.0f);
        } else if (this.keyType == Double.class) {
            key = 1.0;
        } else if (this.keyType == BigInteger.class) {
            key = BigInteger.ONE;
        } else if (this.keyType == BigDecimal.class) {
            key = BigDecimal.ONE;
        } else {
            throw new IllegalArgumentException("Unsupported key type: " + this.keyType);
        }
        return key;
    }

    protected ClickHouseMapValue set(Map<?, ?> value) {
        super.set(ClickHouseChecker.nonNull(value, "value"));
        return this;
    }

    @Override
    public ClickHouseMapValue copy(boolean deep) {
        if (!deep) {
            return new ClickHouseMapValue((Map)this.getValue(), this.keyType, this.valueType);
        }
        Map value = (Map)this.getValue();
        LinkedHashMap newValue = new LinkedHashMap();
        newValue.putAll(value);
        return new ClickHouseMapValue(newValue, this.keyType, this.valueType);
    }

    @Override
    public Map<Object, Object> asMap() {
        return (Map)this.getValue();
    }

    @Override
    public <K, V> Map<K, V> asMap(Class<K> keyClass, Class<V> valueClass) {
        if (!this.keyType.isAssignableFrom(keyClass) || !this.valueType.isAssignableFrom(valueClass)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Incompatible types, expected (%s:%s) but got (%s:%s)", this.keyType.getName(), this.valueType.getName(), keyClass, valueClass));
        }
        return (Map)this.getValue();
    }

    @Override
    public String asString(int length, Charset charset) {
        Map value = (Map)this.getValue();
        if (value == null || value.isEmpty()) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder().append('{');
        for (Map.Entry e : value.entrySet()) {
            builder.append(String.valueOf(e.getKey())).append(':').append(String.valueOf(e.getValue())).append(',');
        }
        builder.setLength(builder.length() - 1);
        String str = builder.append('}').toString();
        return length > 0 ? ClickHouseChecker.notWithDifferentLength(str, length) : str;
    }

    @Override
    public boolean isNullOrEmpty() {
        return ((Map)this.getValue()).isEmpty();
    }

    @Override
    public ClickHouseMapValue resetToDefault() {
        this.set(Collections.emptyMap());
        return this;
    }

    @Override
    public ClickHouseMapValue resetToNullOrEmpty() {
        return this.resetToDefault();
    }

    @Override
    public String toSqlExpression() {
        Map value = (Map)this.getValue();
        if (value == null || value.isEmpty()) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder().append('{');
        Function<Object, String> keySerializer = String.class == this.keyType || UUID.class == this.keyType ? ClickHouseValues::convertToQuotedString : ClickHouseValues::convertToString;
        Function<Object, String> valueSerializer = ClickHouseValues::convertToSqlExpression;
        for (Map.Entry e : value.entrySet()) {
            builder.append(keySerializer.apply(e.getKey())).append(" : ").append(valueSerializer.apply(e.getValue())).append(',');
        }
        builder.setLength(builder.length() - 1);
        return builder.append('}').toString();
    }

    @Override
    public ClickHouseMapValue update(byte value) {
        this.set(Collections.singletonMap(this.getDefaultKey(), this.valueType.cast(value)));
        return this;
    }

    @Override
    public ClickHouseMapValue update(short value) {
        this.set(Collections.singletonMap(this.getDefaultKey(), this.valueType.cast(value)));
        return this;
    }

    @Override
    public ClickHouseMapValue update(int value) {
        this.set(Collections.singletonMap(this.getDefaultKey(), this.valueType.cast(value)));
        return this;
    }

    @Override
    public ClickHouseMapValue update(long value) {
        this.set(Collections.singletonMap(this.getDefaultKey(), this.valueType.cast(value)));
        return this;
    }

    @Override
    public ClickHouseMapValue update(float value) {
        this.set(Collections.singletonMap(this.getDefaultKey(), this.valueType.cast(Float.valueOf(value))));
        return this;
    }

    @Override
    public ClickHouseMapValue update(double value) {
        this.set(Collections.singletonMap(this.getDefaultKey(), this.valueType.cast(value)));
        return this;
    }

    @Override
    public ClickHouseMapValue update(BigInteger value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(Collections.singletonMap(this.getDefaultKey(), this.valueType.cast(value)));
    }

    @Override
    public ClickHouseMapValue update(BigDecimal value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(Collections.singletonMap(this.getDefaultKey(), this.valueType.cast(value)));
    }

    @Override
    public ClickHouseMapValue update(String value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(Collections.singletonMap(this.getDefaultKey(), this.valueType.cast(value)));
    }

    @Override
    public ClickHouseMapValue update(Enum<?> value) {
        Object v;
        if (value == null) {
            v = null;
        } else if (this.valueType == value.getClass()) {
            v = value;
        } else if (this.valueType == String.class) {
            v = value.name();
        } else if (this.keyType == Byte.class) {
            v = (byte)value.ordinal();
        } else if (this.keyType == Short.class) {
            v = (short)value.ordinal();
        } else if (this.keyType == Integer.class) {
            v = value.ordinal();
        } else if (this.keyType == Long.class) {
            v = (long)value.ordinal();
        } else if (this.keyType == Float.class) {
            v = Float.valueOf(value.ordinal());
        } else if (this.keyType == Double.class) {
            v = (double)value.ordinal();
        } else if (this.keyType == BigInteger.class) {
            v = BigInteger.valueOf(value.ordinal());
        } else if (this.keyType == BigDecimal.class) {
            v = BigDecimal.valueOf(value.ordinal());
        } else {
            throw this.newUnsupportedException(value.getClass().getName(), this.valueType.getName());
        }
        return this.set(Collections.singletonMap(this.getDefaultKey(), v));
    }

    @Override
    public ClickHouseMapValue update(Inet4Address value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(Collections.singletonMap(this.getDefaultKey(), this.valueType.cast(value)));
    }

    @Override
    public ClickHouseMapValue update(Inet6Address value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(Collections.singletonMap(this.getDefaultKey(), this.valueType.cast(value)));
    }

    @Override
    public ClickHouseMapValue update(LocalDate value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(Collections.singletonMap(this.getDefaultKey(), this.valueType.cast(value)));
    }

    @Override
    public ClickHouseMapValue update(LocalTime value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(Collections.singletonMap(this.getDefaultKey(), this.valueType.cast(value)));
    }

    @Override
    public ClickHouseMapValue update(LocalDateTime value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(Collections.singletonMap(this.getDefaultKey(), this.valueType.cast(value)));
    }

    @Override
    public ClickHouseMapValue update(Map<?, ?> value) {
        return this.set(value == null ? Collections.emptyMap() : value);
    }

    @Override
    public ClickHouseMapValue update(UUID value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(Collections.singletonMap(this.getDefaultKey(), this.valueType.cast(value)));
    }

    @Override
    public ClickHouseValue updateUnknown(Object value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }

    @Override
    public ClickHouseMapValue update(ClickHouseValue value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else if (value instanceof ClickHouseMapValue) {
            this.set((Map)((ClickHouseMapValue)value).getValue());
        } else {
            this.set(value.asMap());
        }
        return this;
    }

    @Override
    public ClickHouseValue update(Object value) {
        if (value instanceof Map) {
            this.set((Map)value);
        } else {
            super.update(value);
        }
        return this;
    }
}

