/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public final class ClickHouseDeferredValue<T>
implements Supplier<T> {
    private Supplier<T> supplier;
    private Optional<T> value;

    public static <T> ClickHouseDeferredValue<T> of(CompletableFuture<T> future) {
        return ClickHouseDeferredValue.of(future, 0);
    }

    public static <T> ClickHouseDeferredValue<T> of(CompletableFuture<T> future, int timeout) {
        CompletableFuture<Object> f = future != null ? future : CompletableFuture.completedFuture(null);
        int t = timeout < 0 ? 0 : timeout;
        Supplier<Object> supplier = () -> {
            try {
                return f.get(t, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                future.cancel(false);
                throw new CompletionException(e);
            }
            catch (CancellationException e) {
                future.cancel(true);
                throw new CompletionException(e);
            }
            catch (ExecutionException | TimeoutException e) {
                throw new CompletionException(e);
            }
        };
        return new ClickHouseDeferredValue<Object>(supplier, null);
    }

    public static <T> ClickHouseDeferredValue<T> of(Supplier<T> supplier) {
        return new ClickHouseDeferredValue<T>(supplier != null ? supplier : () -> null, null);
    }

    public static <T> ClickHouseDeferredValue<T> of(T value, Class<T> clazz) {
        return new ClickHouseDeferredValue<T>(null, Optional.ofNullable(value));
    }

    private ClickHouseDeferredValue(Supplier<T> supplier, Optional<T> value) {
        this.supplier = supplier;
        this.value = value;
    }

    @Override
    public T get() {
        return this.getOptional().orElse(null);
    }

    public Optional<T> getOptional() {
        if (this.value != null) {
            return this.value;
        }
        this.value = this.supplier == null ? Optional.empty() : Optional.ofNullable(this.supplier.get());
        return this.value;
    }
}

