/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseNodes;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.config.ClickHouseClientOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;

public class ClickHouseCluster
extends ClickHouseNodes {
    private static final long serialVersionUID = 8684489015067906319L;
    private final String clusterName;

    public static ClickHouseCluster of(ClickHouseNode node, ClickHouseNode ... more) {
        return ClickHouseCluster.of(null, node, more);
    }

    public static ClickHouseCluster of(String cluster, ClickHouseNode node, ClickHouseNode ... more) {
        if (node == null) {
            throw new IllegalArgumentException("At least one non-null node is required");
        }
        LinkedList<ClickHouseNode> list = new LinkedList<ClickHouseNode>();
        list.add(node);
        if (more != null) {
            list.addAll(Arrays.asList(more));
        }
        return ClickHouseCluster.of(cluster, list);
    }

    public static ClickHouseCluster of(String cluster, Collection<ClickHouseNode> nodes) {
        if (nodes == null || nodes.isEmpty() || nodes.iterator().next() == null) {
            throw new IllegalArgumentException("At least one non-null node is required");
        }
        boolean autoDiscovery = false;
        String clusterName = cluster;
        int size = nodes.size();
        ArrayList<ClickHouseNode> list = new ArrayList<ClickHouseNode>(size);
        for (ClickHouseNode n : nodes) {
            if (n == null) continue;
            boolean bl = autoDiscovery = autoDiscovery || (Boolean)n.config.getOption(ClickHouseClientOption.AUTO_DISCOVERY) != false;
            String name = n.getCluster();
            if (ClickHouseChecker.isNullOrEmpty(name)) continue;
            if (ClickHouseChecker.isNullOrEmpty(clusterName)) {
                clusterName = name;
                continue;
            }
            if (name.equals(clusterName)) continue;
            throw new IllegalArgumentException(ClickHouseUtils.format("Cluster name should be [%s] for all %d node(s), but it's [%s] for %s", clusterName, size, name, n));
        }
        if (autoDiscovery && ClickHouseChecker.isNullOrEmpty(clusterName)) {
            throw new IllegalArgumentException("Please specify non-empty cluster name in order to use auto discovery");
        }
        for (ClickHouseNode n : nodes) {
            if (n == null || list.contains(n = clusterName.equals(n.getCluster()) ? n : ClickHouseNode.builder(n).cluster(clusterName).build())) continue;
            list.add(n);
        }
        return new ClickHouseCluster(clusterName, list);
    }

    protected ClickHouseCluster(String cluster, Collection<ClickHouseNode> nodes) {
        super(nodes);
        this.clusterName = cluster;
    }

    public String getCluster() {
        return this.clusterName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 31 + this.clusterName.hashCode();
        result = 31 * result + this.checking.hashCode();
        result = 31 * result + this.index.hashCode();
        result = 31 * result + this.policy.hashCode();
        result = 31 * result + this.nodes.hashCode();
        result = 31 * result + this.faultyNodes.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseCluster other = (ClickHouseCluster)obj;
        return this.clusterName.equals(other.clusterName) && this.policy.equals(other.policy) && this.nodes.equals(other.nodes) && this.faultyNodes.equals(other.faultyNodes);
    }

    @Override
    public String toString() {
        return "ClickHouseCluster [name=" + this.clusterName + ", checking=" + this.checking.get() + ", index=" + this.index.get() + ", lock=r" + this.lock.getReadHoldCount() + 'w' + this.lock.getWriteHoldCount() + ", nodes=" + this.nodes.size() + ", faulty=" + this.faultyNodes.size() + ", policy=" + this.policy.getClass().getSimpleName() + "]@" + this.hashCode();
    }
}

