/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.service;

import com.bstek.urule.RuleException;
import com.bstek.urule.Utils;
import com.bstek.urule.model.flow.FlowDefinition;
import com.bstek.urule.model.rete.JsonUtils;
import com.bstek.urule.runtime.KnowledgePackage;
import com.bstek.urule.runtime.KnowledgePackageWrapper;
import com.bstek.urule.runtime.service.RemoteService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class RemoteServiceImpl
implements RemoteService {
    private String resporityServerUrl;
    private Logger log = Logger.getLogger(RemoteServiceImpl.class.getName());

    @Override
    public KnowledgePackage getKnowledge(String packageId, String timestamp) {
        if (StringUtils.isEmpty((String)this.resporityServerUrl)) {
            return null;
        }
        this.log.info("Load knowledgepackage from remote...");
        String content = this.sendRequest(packageId, timestamp);
        if (StringUtils.isEmpty((String)content)) {
            return null;
        }
        KnowledgePackageWrapper wrapper = JsonUtils.parseKnowledgePackageWrapper(content);
        KnowledgePackage knowledgePackage = wrapper.getKnowledgePackage();
        Map<String, FlowDefinition> flowMap = knowledgePackage.getFlowMap();
        if (flowMap != null && flowMap.size() > 0) {
            for (FlowDefinition fd : flowMap.values()) {
                fd.buildConnectionToNode();
            }
        }
        return knowledgePackage;
    }

    private String sendRequest(String packageId, String timestamp) {
        HttpURLConnection connection = null;
        OutputStreamWriter writer = null;
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            packageId = Utils.encodeURL(packageId);
            packageId = Utils.encodeURL(packageId);
            String content = "packageId=" + packageId + "";
            if (StringUtils.isNotEmpty((String)timestamp)) {
                content = content + "&timestamp=" + timestamp + "";
            }
            URL url = new URL(this.resporityServerUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Accept-Charset", "utf-8");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Content-Length", String.valueOf(content.length()));
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            connection.connect();
            writer = new OutputStreamWriter(connection.getOutputStream());
            writer.write(content);
            writer.flush();
            if (connection.getResponseCode() != 200) {
                throw new RuleException("Server request was failed, Response message : " + connection.getResponseMessage());
            }
            inputStream = connection.getInputStream();
            inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            bufferedReader = new BufferedReader(inputStreamReader);
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuleException(e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public void setResporityServerUrl(String resporityServerUrl) {
        if (StringUtils.isEmpty((String)resporityServerUrl) || resporityServerUrl.equals("urule.resporityServerUrl")) {
            return;
        }
        resporityServerUrl = resporityServerUrl.endsWith("/") ? resporityServerUrl + "urule/loadknowledge" : resporityServerUrl + "/urule/loadknowledge";
        this.resporityServerUrl = resporityServerUrl;
    }
}

