/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.service;

import com.bstek.urule.RuleException;
import com.bstek.urule.runtime.KnowledgePackage;
import com.bstek.urule.runtime.cache.CacheUtils;
import com.bstek.urule.runtime.service.KnowledgePackageService;
import com.bstek.urule.runtime.service.KnowledgeService;
import com.bstek.urule.runtime.service.RemoteService;
import java.io.IOException;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class KnowledgeServiceImpl
implements KnowledgeService,
ApplicationContextAware {
    private long knowledgeUpdateCycle;
    private RemoteService remoteService;
    private KnowledgePackageService knowledgePackageService;
    private Logger log = Logger.getLogger(KnowledgeServiceImpl.class.getName());

    @Override
    public KnowledgePackage[] getKnowledges(String[] packageIds) throws IOException {
        KnowledgePackage[] packages = new KnowledgePackage[packageIds.length];
        for (int i = 0; i < packageIds.length; ++i) {
            String packageId = packageIds[i];
            packages[i] = this.getKnowledge(packageId);
        }
        return packages;
    }

    @Override
    public KnowledgePackage getKnowledge(String packageId) throws IOException {
        if (this.knowledgeUpdateCycle == 0L) {
            return this.fetchKnowledgePackage(packageId);
        }
        KnowledgePackage knowledgePackage = CacheUtils.getKnowledgeCache().getKnowledge(packageId);
        if (this.knowledgeUpdateCycle == 1L) {
            if (knowledgePackage == null) {
                knowledgePackage = this.fetchKnowledgePackage(packageId);
                knowledgePackage.resetTimestamp();
                CacheUtils.getKnowledgeCache().putKnowledge(packageId, knowledgePackage);
            }
            return knowledgePackage;
        }
        if (knowledgePackage == null) {
            knowledgePackage = this.fetchKnowledgePackage(packageId);
            CacheUtils.getKnowledgeCache().putKnowledge(packageId, knowledgePackage);
        } else {
            long timestamp = knowledgePackage.getTimestamp();
            long now = System.currentTimeMillis();
            long mm = now - timestamp;
            if (mm >= this.knowledgeUpdateCycle) {
                KnowledgePackage remoteKnowledgePackage = this.remoteService.getKnowledge(packageId, String.valueOf(knowledgePackage.getTimestamp()));
                if (remoteKnowledgePackage == null) {
                    this.log.info("Not need update remote knowledgepackage.");
                    knowledgePackage.resetTimestamp();
                    CacheUtils.getKnowledgeCache().putKnowledge(packageId, knowledgePackage);
                } else {
                    this.log.info("Need update remote knowledgepackage.");
                    remoteKnowledgePackage.resetTimestamp();
                    CacheUtils.getKnowledgeCache().putKnowledge(packageId, remoteKnowledgePackage);
                }
            }
        }
        return knowledgePackage;
    }

    private KnowledgePackage fetchKnowledgePackage(String packageId) throws IOException {
        KnowledgePackage knowledgePackage = this.remoteService.getKnowledge(packageId, null);
        if (knowledgePackage == null) {
            if (this.knowledgePackageService == null) {
                throw new RuleException("Remote service and local KnowledgePackageService all unavailable");
            }
            knowledgePackage = this.knowledgePackageService.buildKnowledgePackage(packageId);
        }
        return knowledgePackage;
    }

    public void setRemoteService(RemoteService remoteService) {
        this.remoteService = remoteService;
    }

    public void setKnowledgeUpdateCycle(String knowledgeUpdateCycle) {
        if (StringUtils.isEmpty((String)knowledgeUpdateCycle) || knowledgeUpdateCycle.equals("${urule.knowledgeUpdateCycle}")) {
            return;
        }
        this.knowledgeUpdateCycle = Long.valueOf(knowledgeUpdateCycle);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        boolean hasBean = applicationContext.containsBean("urule.knowledgePackageService");
        if (hasBean) {
            this.knowledgePackageService = (KnowledgePackageService)applicationContext.getBean("urule.knowledgePackageService");
        }
    }
}

