/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.rete;

import com.bstek.urule.RuleException;
import com.bstek.urule.Utils;
import com.bstek.urule.action.ActionValue;
import com.bstek.urule.action.ExecuteMethodAction;
import com.bstek.urule.model.GeneralEntity;
import com.bstek.urule.model.function.Argument;
import com.bstek.urule.model.function.FunctionDescriptor;
import com.bstek.urule.model.rule.AbstractValue;
import com.bstek.urule.model.rule.ArithmeticType;
import com.bstek.urule.model.rule.CommonFunctionValue;
import com.bstek.urule.model.rule.ComplexArithmetic;
import com.bstek.urule.model.rule.ConstantValue;
import com.bstek.urule.model.rule.MethodValue;
import com.bstek.urule.model.rule.NamedReferenceValue;
import com.bstek.urule.model.rule.ParameterValue;
import com.bstek.urule.model.rule.ParenValue;
import com.bstek.urule.model.rule.SimpleArithmetic;
import com.bstek.urule.model.rule.SimpleArithmeticValue;
import com.bstek.urule.model.rule.SimpleValue;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.ValueType;
import com.bstek.urule.model.rule.VariableCategoryValue;
import com.bstek.urule.model.rule.VariableValue;
import com.bstek.urule.model.rule.lhs.CommonFunctionParameter;
import com.bstek.urule.runtime.rete.Context;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValueCompute {
    public static final String BEAN_ID = "urule.valueCompute";

    public Object complexValueCompute(Value value, Object matchedObject, Context context, List<Object> allMatchedObjects, Map<String, Object> variableMap) {
        return this.compute(value, context, matchedObject, allMatchedObjects, variableMap);
    }

    public Object simpleArithmeticCompute(Context context, Object leftObj, SimpleArithmetic simpleArithmetic) {
        String expr = null;
        expr = !(leftObj instanceof Number) ? "\"" + leftObj + "\"" : leftObj.toString();
        while (simpleArithmetic != null) {
            ArithmeticType type = simpleArithmetic.getType();
            SimpleArithmeticValue nextValue = simpleArithmetic.getValue();
            expr = expr + type.toString() + "\"" + nextValue.getContent() + "\"";
            simpleArithmetic = nextValue.getArithmetic();
        }
        return context.parseExpression(expr);
    }

    private Object compute(Value value, Context context, Object matchedFact, List<Object> allMatchedObjects, Map<String, Object> variableMap) {
        Object leftObj = this.fetchValue(value, context, matchedFact, allMatchedObjects, variableMap);
        ComplexArithmetic arithmetic = value.getArithmetic();
        if (arithmetic == null) {
            return leftObj;
        }
        StringBuffer expr = new StringBuffer();
        this.addToExpr(expr, leftObj);
        while (arithmetic != null) {
            ArithmeticType type = arithmetic.getType();
            this.addToExpr(expr, (Object)type);
            AbstractValue rightValue = (AbstractValue)arithmetic.getValue();
            if (rightValue instanceof ParenValue) {
                ParenValue pv = (ParenValue)rightValue;
                Object obj = this.compute(pv.getValue(), context, matchedFact, allMatchedObjects, variableMap);
                this.addToExpr(expr, obj);
            } else {
                Object rightObj = this.fetchValue(rightValue, context, matchedFact, allMatchedObjects, variableMap);
                if (rightObj == null) {
                    rightObj = "null";
                }
                this.addToExpr(expr, rightObj);
            }
            arithmetic = rightValue.getArithmetic();
        }
        return context.parseExpression(expr.toString());
    }

    private void addToExpr(StringBuffer expr, Object obj) {
        expr.append(" ");
        if (obj instanceof ArithmeticType) {
            expr.append(obj.toString());
        } else if (obj instanceof Number) {
            expr.append(obj.toString());
        } else {
            expr.append("\"" + obj + "\"");
        }
        expr.append(" ");
    }

    private Object fetchValue(Value value, Context context, Object matchedFact, List<Object> allMatchedObjects, Map<String, Object> variableMap) {
        Object left = null;
        ValueType type = value.getValueType();
        if (type.equals((Object)ValueType.Input)) {
            left = ((SimpleValue)value).getContent();
        } else if (type.equals((Object)ValueType.Constant)) {
            ConstantValue cv = (ConstantValue)value;
            left = cv.getConstantName();
        } else {
            if (type.equals((Object)ValueType.VariableCategory)) {
                VariableCategoryValue vc = (VariableCategoryValue)value;
                String categoryName = vc.getVariableCategory();
                return this.findObject(context, matchedFact, categoryName, allMatchedObjects);
            }
            if (type.equals((Object)ValueType.Parameter)) {
                ParameterValue pv = (ParameterValue)value;
                String categoryName = "\u53c2\u6570";
                Object object = this.findObject(context, matchedFact, categoryName, allMatchedObjects);
                if (object == null) {
                    return null;
                }
                String property = pv.getVariableName();
                left = Utils.getObjectProperty(object, property);
            } else if (type.equals((Object)ValueType.Method)) {
                MethodValue mv = (MethodValue)value;
                ExecuteMethodAction action = new ExecuteMethodAction();
                action.setBeanId(mv.getBeanId());
                action.setBeanLabel(mv.getBeanLabel());
                action.setMethodName(mv.getMethodName());
                action.setMethodLabel(mv.getMethodLabel());
                action.setParameters(mv.getParameters());
                ActionValue actionValue = action.execute(context, matchedFact, allMatchedObjects, variableMap);
                left = actionValue != null ? actionValue.getValue() : null;
            } else if (type.equals((Object)ValueType.CommonFunction)) {
                CommonFunctionValue v = (CommonFunctionValue)value;
                CommonFunctionParameter functionParameter = v.getParameter();
                Value propertyValue = functionParameter.getObjectParameter();
                Object object = this.complexValueCompute(propertyValue, matchedFact, context, allMatchedObjects, variableMap);
                FunctionDescriptor fun = Utils.findFunctionDescriptor(v.getName());
                Argument arg = fun.getArgument();
                String property = null;
                if (arg.isNeedProperty()) {
                    property = functionParameter.getProperty();
                }
                left = fun.doFunction(object, property, context.getWorkingMemory());
            } else if (type.equals((Object)ValueType.Paren)) {
                ParenValue parenValue = (ParenValue)value;
                left = this.compute(parenValue.getValue(), context, matchedFact, allMatchedObjects, variableMap);
            } else if (type.equals((Object)ValueType.NamedReference)) {
                NamedReferenceValue namedValue = (NamedReferenceValue)value;
                String prop = namedValue.getPropertyName();
                String refName = namedValue.getReferenceName();
                if (variableMap == null) {
                    throw new RuleException("Reference [" + refName + "] not define");
                }
                Object obj = variableMap.get(refName);
                if (obj == null) {
                    refName = refName.substring(1, refName.length());
                    obj = variableMap.get(refName);
                }
                if (obj == null) {
                    throw new RuleException("Reference [" + refName + "] not define");
                }
                left = prop != null ? Utils.getObjectProperty(obj, prop) : obj;
            } else {
                VariableValue vv = (VariableValue)value;
                String categoryName = vv.getVariableCategory();
                Object object = this.findObject(context, matchedFact, categoryName, allMatchedObjects);
                if (object == null) {
                    return null;
                }
                String property = vv.getVariableName();
                left = Utils.getObjectProperty(object, property);
            }
        }
        return left;
    }

    private Object findObject(Context context, Object matchedFact, String categoryName, List<Object> allMatchedObjects) {
        String className = context.getVariableCategoryClass(categoryName);
        Object object = this.findObject(className, matchedFact, context);
        if (allMatchedObjects != null && object != null && !allMatchedObjects.contains(object)) {
            allMatchedObjects.add(object);
        }
        return object;
    }

    public Object findObject(String className, Object matchedFact, Context context) {
        GeneralEntity entity;
        if (className.equals(HashMap.class.getName())) {
            return context.getWorkingMemory().getParameters();
        }
        if (matchedFact instanceof Collection) {
            Collection coll = (Collection)matchedFact;
            for (Object obj : coll) {
                GeneralEntity entity2;
                if (obj.getClass().getName().equals(className)) {
                    return obj;
                }
                if (!(obj instanceof GeneralEntity) || !(entity2 = (GeneralEntity)obj).getTargetClass().equals(className)) continue;
                return obj;
            }
        } else {
            GeneralEntity entity3;
            if (matchedFact.getClass().getName().equals(className)) {
                return matchedFact;
            }
            if (matchedFact instanceof GeneralEntity && (entity3 = (GeneralEntity)matchedFact).getTargetClass().equals(className)) {
                return matchedFact;
            }
        }
        Object object = null;
        List<Object> allFacts = context.getWorkingMemory().getAllFacts();
        for (Object obj : allFacts) {
            if (obj.getClass().getName().equals(className)) {
                object = obj;
                break;
            }
            if (!(obj instanceof GeneralEntity) || !(entity = (GeneralEntity)obj).getTargetClass().equals(className)) continue;
            object = obj;
            break;
        }
        if (object == null) {
            allFacts = context.getWorkingMemory().getHistoryFacts();
            for (Object obj : allFacts) {
                if (obj.getClass().getName().equals(className)) {
                    object = obj;
                    break;
                }
                if (!(obj instanceof GeneralEntity) || !(entity = (GeneralEntity)obj).getTargetClass().equals(className)) continue;
                object = obj;
                break;
            }
        }
        return object;
    }
}

