/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.rete;

import com.bstek.urule.runtime.rete.AbstractActivity;
import com.bstek.urule.runtime.rete.Activity;
import com.bstek.urule.runtime.rete.CriteriaActivity;
import com.bstek.urule.runtime.rete.EvaluationContext;
import com.bstek.urule.runtime.rete.FactTracker;
import com.bstek.urule.runtime.rete.ObjectTypeActivity;
import com.bstek.urule.runtime.rete.OrActivity;
import com.bstek.urule.runtime.rete.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class ReteInstance {
    private List<ObjectTypeActivity> objectTypeActivities;

    public ReteInstance(List<ObjectTypeActivity> objectTypeActivities) {
        this.objectTypeActivities = objectTypeActivities;
    }

    public Collection<FactTracker> enter(EvaluationContext context, Object obj) {
        Collection<FactTracker> trackers = null;
        for (ObjectTypeActivity objectTypeActivity : this.objectTypeActivities) {
            Collection<FactTracker> result;
            if (!objectTypeActivity.support(obj) || (result = objectTypeActivity.enter(context, obj, new FactTracker(), new HashMap<String, Object>())) == null) continue;
            if (trackers == null) {
                trackers = result;
                continue;
            }
            trackers.addAll(result);
        }
        return trackers;
    }

    public List<ObjectTypeActivity> getObjectTypeActivities() {
        return this.objectTypeActivities;
    }

    public void reset() {
        for (ObjectTypeActivity objectTypeActivity : this.objectTypeActivities) {
            List<Path> paths = objectTypeActivity.getPaths();
            this.resetActivities(paths, false);
        }
    }

    public void resetForReevaluate(Object valuateObj) {
        for (ObjectTypeActivity objectTypeActivity : this.objectTypeActivities) {
            if (!objectTypeActivity.support(valuateObj)) continue;
            List<Path> paths = objectTypeActivity.getPaths();
            this.resetActivities(paths, true);
        }
    }

    private void resetActivities(List<Path> paths, boolean forReevaluate) {
        if (paths == null) {
            return;
        }
        for (Path path : paths) {
            AbstractActivity ac;
            path.setPassed(false);
            Activity activity = path.getTo();
            if (forReevaluate) {
                if (activity instanceof OrActivity) {
                    ac = (OrActivity)activity;
                    ((OrActivity)ac).reset();
                }
                if (activity instanceof CriteriaActivity) {
                    ac = (CriteriaActivity)activity;
                    ((CriteriaActivity)ac).reset();
                }
            } else if (activity instanceof AbstractActivity) {
                ac = (AbstractActivity)activity;
                ac.reset();
            }
            this.resetActivities(activity.getPaths(), forReevaluate);
        }
    }
}

