/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.rete;

import com.bstek.urule.Utils;
import com.bstek.urule.debug.MsgType;
import com.bstek.urule.model.rule.lhs.EvaluateResponse;
import com.bstek.urule.model.rule.lhs.NamedCriteria;
import com.bstek.urule.runtime.rete.AbstractActivity;
import com.bstek.urule.runtime.rete.Context;
import com.bstek.urule.runtime.rete.EvaluationContext;
import com.bstek.urule.runtime.rete.FactTracker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class NamedCriteriaActivity
extends AbstractActivity {
    protected NamedCriteria criteria;
    private boolean pass;
    private boolean debug;

    public NamedCriteriaActivity(NamedCriteria criteria, boolean debug) {
        this.criteria = criteria;
        this.debug = debug;
    }

    public List<FactTracker> enter(EvaluationContext context, Object obj, FactTracker tracker, Map<String, Object> variableMap) {
        String referenceName = this.criteria.getReferenceName();
        if (this.pass && (StringUtils.isBlank((String)referenceName) || variableMap.containsKey(referenceName))) {
            return null;
        }
        ArrayList<Object> allMatchedObjects = new ArrayList<Object>();
        EvaluateResponse response = this.criteria.evaluate(context, obj, allMatchedObjects);
        boolean result = response.getResult();
        this.doDebug(response, context);
        if (result) {
            if (StringUtils.isNotBlank((String)referenceName)) {
                variableMap.put(referenceName, obj);
            }
            context.setPrevActivity(this);
            this.pass = true;
            tracker.addObjectCriteria(obj, this.criteria);
            for (Object e : allMatchedObjects) {
                tracker.addObjectCriteria(e, this.criteria);
            }
            return this.visitPahs(context, obj, tracker, variableMap);
        }
        return null;
    }

    private void doDebug(EvaluateResponse response, Context context) {
        if (!this.debug || !Utils.isDebug()) {
            return;
        }
        String id = this.criteria.getId();
        StringBuffer sb = new StringBuffer();
        sb.append("^^^\u547d\u540d\u6761\u4ef6\uff1a" + id);
        String result = response.getResult() ? "\u6ee1\u8db3" : "\u4e0d\u6ee1\u8db3";
        sb.append(" =>" + result);
        System.out.println(sb.toString());
        context.debugMsg(sb.toString(), MsgType.Condition, this.debug);
    }

    @Override
    public boolean orNodeIsPassed() {
        return false;
    }

    @Override
    public void reset() {
        this.pass = false;
    }
}

