/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.rete;

import com.bstek.urule.model.GeneralEntity;
import com.bstek.urule.model.rule.lhs.BaseCriteria;
import com.bstek.urule.runtime.agenda.Activation;
import com.bstek.urule.runtime.agenda.ActivationImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FactTracker {
    private Activation activation;
    private Map<Object, List<BaseCriteria>> objectCriteriaMap = new HashMap<Object, List<BaseCriteria>>();

    public Activation getActivation() {
        return this.activation;
    }

    public void setActivation(Activation activation) {
        ActivationImpl ac = (ActivationImpl)activation;
        ac.setObjectCriteriaMap(this.objectCriteriaMap);
        this.activation = activation;
    }

    public Map<Object, List<BaseCriteria>> getObjectCriteriaMap() {
        return this.objectCriteriaMap;
    }

    public void addObjectCriteria(Object obj, BaseCriteria criteria) {
        if (obj instanceof HashMap && !(obj instanceof GeneralEntity)) {
            obj = HashMap.class.getName();
        }
        if (this.objectCriteriaMap.containsKey(obj)) {
            List<BaseCriteria> list = this.objectCriteriaMap.get(obj);
            if (!list.contains(criteria)) {
                list.add(criteria);
            }
        } else {
            ArrayList<BaseCriteria> list = new ArrayList<BaseCriteria>();
            list.add(criteria);
            this.objectCriteriaMap.put(obj, list);
        }
    }

    public FactTracker newSubFactTracker() {
        FactTracker tracker = new FactTracker();
        tracker.getObjectCriteriaMap().putAll(this.objectCriteriaMap);
        return tracker;
    }
}

